/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.util.NotImplementedException;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class ParsingLayerCacheManager
extends LayerCacheManager
implements ContentHandler,
ErrorHandler,
EntityResolver {
    private static final String[] ATTR_TYPES = new String[]{"boolvalue", "bytevalue", "charvalue", "doublevalue", "floatvalue", "intvalue", "longvalue", "methodvalue", "newvalue", "serialvalue", "shortvalue", "stringvalue", "urlvalue"};
    private static final String DTD_1_0 = "-//NetBeans//DTD Filesystem 1.0//EN";
    private static final String DTD_1_1 = "-//NetBeans//DTD Filesystem 1.1//EN";
    private Locator locator;
    private MemFolder root;
    private Stack curr;
    private URL base;
    private StringBuffer buf = new StringBuffer();
    private int fileCount;
    private int folderCount;
    private int attrCount;
    private Set oneLayerFiles;
    private boolean checkingForDuplicates;
    private String currPath;

    protected ParsingLayerCacheManager(File cacheDir) throws IOException {
        super(cacheDir);
    }

    @Override
    public final void store(FileSystem fs, List urls) throws IOException {
        this.store(fs, this.createRoot(urls));
    }

    @Override
    public final FileSystem store(List urls) throws IOException {
        return this.store(this.createRoot(urls));
    }

    private MemFolder createRoot(List urls) throws IOException {
        this.root = new MemFolder(null);
        this.curr = new Stack();
        this.curr.push(this.root);
        try {
            XMLReader r = XMLUtil.createXMLReader();
            r.setFeature("http://xml.org/sax/features/validation", false);
            r.setFeature("http://xml.org/sax/features/namespaces", false);
            r.setFeature("http://xml.org/sax/features/string-interning", true);
            r.setContentHandler(this);
            r.setErrorHandler(this);
            r.setEntityResolver(this);
            Exception carrier = null;
            urls = new ArrayList(urls);
            Collections.reverse(urls);
            this.checkingForDuplicates = LayerCacheManager.err.isLoggable(16);
            for (URL this.base : urls) {
                if (this.checkingForDuplicates) {
                    this.oneLayerFiles = new HashSet(100);
                    this.currPath = null;
                }
                LayerCacheManager.err.log("Parsing: " + this.base);
                try {
                    r.parse(this.base.toExternalForm());
                }
                catch (Exception e) {
                    this.curr.clear();
                    this.curr.push(this.root);
                    LayerCacheManager.err.log("Caught " + e + " while parsing: " + this.base);
                    if (carrier == null) {
                        carrier = e;
                        continue;
                    }
                    LayerCacheManager.err.annotate((Throwable)carrier, (Throwable)e);
                }
            }
            if (carrier != null) {
                throw carrier;
            }
            LayerCacheManager.err.log("Finished layer parsing; " + this.fileCount + " files, " + this.folderCount + " folders, " + this.attrCount + " attributes");
            MemFolder memFolder = this.root;
            return memFolder;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.toString());
            LayerCacheManager.err.annotate((Throwable)ioe, (Throwable)e);
            throw ioe;
        }
        finally {
            this.attrCount = 0;
            this.folderCount = 0;
            this.fileCount = 0;
            this.base = null;
            this.locator = null;
            this.curr = null;
            this.root = null;
            this.oneLayerFiles = null;
            this.currPath = null;
        }
    }

    protected void store(FileSystem fs, MemFolder root) throws IOException {
        throw new NotImplementedException();
    }

    protected FileSystem store(MemFolder root) throws IOException {
        throw new NotImplementedException();
    }

    protected abstract boolean openURLs();

    @Override
    public void startElement(String ns, String lname, String qname, Attributes attrs) throws SAXException {
        if (qname == "filesystem") {
            return;
        }
        if (qname == "folder") {
            this.fileOrFolder(qname, attrs);
        } else if (qname == "file") {
            MemFile file = (MemFile)this.fileOrFolder(qname, attrs);
            file.contents = null;
            String u = attrs.getValue("url");
            if (u != null) {
                try {
                    file.ref = new URL(this.base, u);
                }
                catch (MalformedURLException mfue) {
                    SAXException saxe = new SAXException(mfue.toString());
                    LayerCacheManager.err.annotate((Throwable)saxe, (Throwable)mfue);
                    throw saxe;
                }
            } else {
                file.ref = null;
            }
        } else if (qname == "attr") {
            ++this.attrCount;
            MemAttr attr = new MemAttr();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                if ("name".equals(attrName)) {
                    attr.name = attrs.getValue(i);
                } else {
                    int idx = Arrays.binarySearch(ATTR_TYPES, attrName);
                    if (idx >= 0) {
                        attr.type = ATTR_TYPES[idx];
                        attr.data = attrs.getValue(i);
                    }
                }
                if (attr.name != null && attr.data != null) break;
            }
            if (attr.type == null) {
                throw new SAXParseException("unknown <attr> value type for " + attr.name, this.locator);
            }
            MemFileOrFolder parent = (MemFileOrFolder)this.curr.peek();
            if (parent.attrs == null) {
                parent.attrs = new LinkedList();
            }
            Iterator it = parent.attrs.iterator();
            while (it.hasNext()) {
                if (!((MemAttr)it.next()).name.equals(attr.name)) continue;
                --this.attrCount;
                it.remove();
            }
            parent.attrs.add(attr);
            if (this.checkingForDuplicates && !this.oneLayerFiles.add(this.currPath + "//" + attr.name)) {
                LayerCacheManager.err.log(16, "Warning: layer " + this.base + " contains duplicate attributes " + attr.name + " for " + this.currPath);
            }
        } else {
            throw new SAXException(qname);
        }
    }

    private MemFileOrFolder fileOrFolder(String qname, Attributes attrs) {
        String name = attrs.getValue("name");
        if (name == null) {
            throw new NullPointerException("No name");
        }
        if (!(this.curr.peek() instanceof MemFolder)) {
            throw new ClassCastException("Stack: " + this.curr);
        }
        MemFolder parent = (MemFolder)this.curr.peek();
        MemFileOrFolder f = null;
        if (parent.children == null) {
            parent.children = new LinkedList();
        } else {
            for (MemFileOrFolder f2 : parent.children) {
                if (!f2.name.equals(name)) continue;
                f = f2;
                break;
            }
        }
        if (f == null) {
            if (qname == "folder") {
                f = new MemFolder(this.base);
                ++this.folderCount;
            } else {
                f = new MemFile(this.base);
                ++this.fileCount;
            }
            f.name = name;
            parent.children.add(f);
        }
        this.curr.push(f);
        if (this.checkingForDuplicates) {
            this.currPath = this.currPath == null ? name : this.currPath + "/" + name;
            if (!this.oneLayerFiles.add(this.currPath)) {
                LayerCacheManager.err.log(16, "Warning: layer " + this.base + " contains duplicate " + qname + "s named " + this.currPath);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String ns, String lname, String qname) throws SAXException {
        if (qname == "file" && this.buf.length() > 0) {
            String text = this.buf.toString().trim();
            if (text.length() > 0) {
                MemFile file = (MemFile)this.curr.peek();
                if (file.ref != null) {
                    throw new SAXParseException("CDATA plus url= in <file>", this.locator);
                }
                LayerCacheManager.err.log(16, "Warning: use of inline CDATA text contents in <file name=\"" + file.name + "\"> deprecated for performance and charset safety at " + this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ". Please use the 'url' attribute instead, or the file attribute 'originalFile' on *.shadow files (with IDE/1 > 2.23).");
                file.contents = text.getBytes();
            }
            this.buf.setLength(0);
        }
        if (qname == "file" && this.openURLs()) {
            MemFile file = (MemFile)this.curr.peek();
            if (file.ref != null && file.ref.toExternalForm().startsWith("jar:file:")) {
                try {
                    URLConnection conn = file.ref.openConnection();
                    conn.connect();
                    byte[] buf = new byte[conn.getContentLength()];
                    try (InputStream is = conn.getInputStream();){
                        int read;
                        for (int pos = 0; pos < buf.length; pos += read) {
                            read = is.read(buf, pos, buf.length - pos);
                            if (read >= 1) continue;
                            throw new IOException("Premature EOF on " + file.ref.toExternalForm());
                        }
                        if (is.read() != -1) {
                            throw new IOException("Delayed EOF on " + file.ref.toExternalForm());
                        }
                    }
                    file.contents = buf;
                    file.ref = null;
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
            }
        }
        if (qname == "file" || qname == "folder") {
            this.curr.pop();
            if (this.checkingForDuplicates) {
                int i = this.currPath.lastIndexOf(47);
                this.currPath = i == -1 ? null : this.currPath.substring(0, i);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        Object currF = this.curr.peek();
        if (!(currF instanceof MemFile)) {
            return;
        }
        this.buf.append(ch, start, len);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        LayerCacheManager.err.notify(1, (Throwable)e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public InputSource resolveEntity(String pubid, String sysid) throws SAXException, IOException {
        if (pubid != null && (pubid.equals(DTD_1_0) || pubid.equals(DTD_1_1))) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.curr.size() != 1) {
            throw new SAXException("Wrong stack: " + this.curr);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String str, String str1) throws SAXException {
    }

    @Override
    public void skippedEntity(String str) throws SAXException {
    }

    @Override
    public void processingInstruction(String str, String str1) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] values, int param, int param2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String str) throws SAXException {
    }

    protected static final class MemAttr {
        public String name;
        public String type;
        public String data;

        protected MemAttr() {
        }

        public String toString() {
            return "MemAttr[" + this.name + "," + this.type + "," + this.data + "]";
        }
    }

    protected static final class MemFile
    extends MemFileOrFolder {
        public byte[] contents = null;
        public URL ref = null;

        public MemFile(URL base) {
            super(base);
        }

        public String toString() {
            return "MemFile[" + this.name + "]";
        }
    }

    protected static final class MemFolder
    extends MemFileOrFolder {
        public List children = null;

        public MemFolder(URL base) {
            super(base);
        }

        public String toString() {
            return "MemFolder[" + this.name + "]";
        }
    }

    protected static abstract class MemFileOrFolder {
        public String name;
        public List attrs = null;
        public final URL base;

        public MemFileOrFolder(URL base) {
            this.base = base;
        }
    }
}

