/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.core.startup.layers.FixedFileSystem;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class SystemFileSystem
extends MultiFileSystem
implements FileSystem.Status {
    static final long serialVersionUID = -7761052280240991668L;
    private static final String SYSTEM_NAME = "SystemFileSystem";
    private static final String ATTR_BUNDLE = "SystemFileSystem.localizingBundle";
    private static final String ATTR_ICON_16 = "SystemFileSystem.icon";
    private static final String ATTR_ICON_32 = "SystemFileSystem.icon32";
    private ModuleLayeredFileSystem user;
    private ModuleLayeredFileSystem home;
    private static MessageFormat homeFormat;
    private static MessageFormat userFormat;

    private SystemFileSystem(FileSystem[] fss) throws PropertyVetoException {
        super(fss);
        this.user = (ModuleLayeredFileSystem)fss[0];
        this.home = fss.length > 2 ? (ModuleLayeredFileSystem)fss[1] : null;
        this.setSystemName(SYSTEM_NAME);
        this.setHidden(true);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SystemFileSystem.class, (String)"CTL_SystemFileSystem");
    }

    public ModuleLayeredFileSystem getInstallationLayer() {
        return this.home;
    }

    public ModuleLayeredFileSystem getUserLayer() {
        return this.user;
    }

    public final void setLayers(FileSystem[] arr) throws IllegalArgumentException {
        HashSet<FileSystem> s = new HashSet<FileSystem>();
        for (int i = 0; i < arr.length; ++i) {
            if (s.contains(arr[i])) {
                throw new IllegalArgumentException("Overlap in filesystem layers");
            }
            s.add(arr[i]);
        }
        this.setDelegates((FileSystem[])arr.clone());
        this.firePropertyChange("layers", null, null);
    }

    public FileSystem[] getLayers() {
        return (FileSystem[])this.getDelegates().clone();
    }

    protected FileSystem createWritableOnForRename(String oldName, String newName) throws IOException {
        return this.createWritableOn(oldName);
    }

    protected FileSystem createWritableOn(String name) throws IOException {
        FileSystem[] fss = this.getDelegates();
        for (int index = 0; index < fss.length; ++index) {
            if (fss[index].isReadOnly()) continue;
            return fss[index];
        }
        throw new IOException("No writable filesystems in our delegates");
    }

    protected Set createLocksOn(String name) throws IOException {
        LocalFileSystemEx.potentialLock(name);
        return super.createLocksOn(name);
    }

    private static boolean isWritableOn(String name, FileSystem fs) {
        if (fs.isReadOnly()) {
            return false;
        }
        if (fs instanceof ModuleLayeredFileSystem) {
            FileSystem[] fss = ((ModuleLayeredFileSystem)fs).getLayers();
            for (int i = 0; i < fss.length; ++i) {
                if (fss[i].findResource(name) == null) continue;
                return !fss[i].isReadOnly();
            }
            throw new IllegalArgumentException("did not find " + name + " on " + fs);
        }
        return true;
    }

    public boolean isPersistent() {
        return true;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String s, Set set) {
        for (FileObject fo : set) {
            String fixedName;
            String bundleName = (String)fo.getAttribute(ATTR_BUNDLE);
            if (bundleName != null) {
                try {
                    bundleName = Utilities.translate((String)bundleName);
                    ResourceBundle b = NbBundle.getBundle((String)bundleName, (Locale)Locale.getDefault(), (ClassLoader)((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)));
                    try {
                        return b.getString(fo.getPath());
                    }
                    catch (MissingResourceException missingResourceException) {
                    }
                }
                catch (MissingResourceException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, 0, "Computing display name for " + fo, null, null, null);
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if ((fixedName = FixedFileSystem.deflt.annotateName(fo.getPath())) == null) continue;
            return fixedName;
        }
        return this.annotateNameNoLocalization(s, set);
    }

    private String annotateNameNoLocalization(String s, Set set) {
        if (this.home == null || this.user == null) {
            return s;
        }
        Iterator it = set.iterator();
        int cnt = 0;
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if (!fo.isRoot()) {
                ++cnt;
            }
            if (this.findSystem(fo) != this.home) continue;
            return SystemFileSystem.getHomeFormat().format(new Object[]{s});
        }
        if (cnt == 0) {
            return s;
        }
        return SystemFileSystem.getUserFormat().format(new Object[]{s});
    }

    public Image annotateIcon(Image im, int type, Set s) {
        String attr;
        if (type == 1) {
            attr = ATTR_ICON_16;
        } else if (type == 2) {
            attr = ATTR_ICON_32;
        } else {
            return im;
        }
        for (FileObject fo : s) {
            Image anntIm;
            Object value = fo.getAttribute(attr);
            if (value != null) {
                if (value instanceof URL) {
                    return Toolkit.getDefaultToolkit().getImage((URL)value);
                }
                if (value instanceof Image) {
                    return (Image)value;
                }
                ErrorManager.getDefault().log(16, "Attribute " + attr + " on " + fo + " expected to be a URL or Image; was: " + value);
            }
            if ((anntIm = FixedFileSystem.deflt.annotateIcon(fo.getPath())) == null) continue;
            return anntIm;
        }
        return im;
    }

    static SystemFileSystem create(File userDir, File homeDir, File[] extradirs) throws PropertyVetoException, IOException {
        LocalFileSystemEx home;
        Object user;
        if (userDir != null) {
            if (!userDir.exists()) {
                userDir.mkdirs();
            }
            LocalFileSystemEx l = new LocalFileSystemEx();
            l.setRootDirectory(userDir);
            user = l;
        } else {
            user = FileUtil.createMemoryFileSystem();
        }
        if (homeDir == null) {
            home = null;
        } else {
            home = new LocalFileSystemEx();
            home.setRootDirectory(homeDir);
            home.setReadOnly(true);
        }
        LocalFileSystem[] extras = new LocalFileSystem[extradirs.length];
        for (int i = 0; i < extradirs.length; ++i) {
            extras[i] = new LocalFileSystemEx();
            extras[i].setRootDirectory(extradirs[i]);
            extras[i].setReadOnly(true);
        }
        FileSystem[] arr = new FileSystem[home == null ? 2 : 3];
        arr[0] = new ModuleLayeredFileSystem((FileSystem)user, new FileSystem[0], null);
        if (home != null) {
            File cachedir = new File(new File(userDir.getParentFile(), "var"), "cache");
            arr[1] = new ModuleLayeredFileSystem((FileSystem)home, (FileSystem[])extras, cachedir);
        }
        FixedFileSystem.deflt = new FixedFileSystem("org.netbeans.core.projects.FixedFileSystem", "Automatic Manifest Installation");
        arr[home == null ? 1 : 2] = FixedFileSystem.deflt;
        return new SystemFileSystem(arr);
    }

    private static MessageFormat getUserFormat() {
        if (userFormat == null) {
            userFormat = new MessageFormat(NbBundle.getMessage(SystemFileSystem.class, (String)"CTL_UserFile"));
        }
        return userFormat;
    }

    private static MessageFormat getHomeFormat() {
        if (homeFormat == null) {
            homeFormat = new MessageFormat(NbBundle.getMessage(SystemFileSystem.class, (String)"CTL_HomeFile"));
        }
        return homeFormat;
    }

    protected void notifyMigration(FileObject fo) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fo, false, true));
    }

    private Object writeReplace() throws ObjectStreamException {
        new NotSerializableException("WARNING - SystemFileSystem is not designed to be serialized").printStackTrace();
        return new SingletonSerializer();
    }

    private static final class SingletonSerializer
    implements Serializable {
        private static final long serialVersionUID = 6436781994611L;

        SingletonSerializer() {
        }

        private Object readResolve() throws ObjectStreamException {
            return Repository.getDefault().getDefaultFileSystem();
        }
    }
}

