/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;

public class GarbageCollectAction
extends CallableSystemAction {
    public String getName() {
        return NbBundle.getBundle((Class)GarbageCollectAction.class).getString("CTL_GarbageCollect");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GarbageCollectAction.class);
    }

    public void performAction() {
        GarbageCollectAction.gc();
    }

    private static void gc() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                System.gc();
                System.runFinalization();
                System.gc();
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public Component getToolbarPresenter() {
        return new MemButton();
    }

    private static final class MemButton
    extends JLabel
    implements ActionListener,
    ComponentListener {
        private static final boolean AUTOMATIC_REFRESH;
        private static final int TICK = 1000;
        private final Runtime r = Runtime.getRuntime();
        private final Format f = new MessageFormat(" {0,number,0.0}/{1,number,0.0}MB ");
        private final Timer t = new Timer(1000, this);
        private double proportion = 0.0;
        private double[] graph = null;
        private int graphPointer;
        private int graphBase;
        private boolean containsMouse = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MemButton() {
            this.enableEvents(16L);
            this.setText(this.f.format(new Object[]{new Double(999.0), new Double(999.0)}));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
            this.setToolTipText(NbBundle.getMessage((Class)(class$org$openide$actions$GarbageCollectAction == null ? (class$org$openide$actions$GarbageCollectAction = GarbageCollectAction.class$("org.openide.actions.GarbageCollectAction")) : class$org$openide$actions$GarbageCollectAction), (String)"CTL_GC"));
        }

        public void paintBorder(Graphics graphics) {
        }

        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            dimension.height = this.getParent().getHeight();
            return dimension;
        }

        public void addNotify() {
            super.addNotify();
            this.getParent().addComponentListener(this);
            if (this.getParent().isVisible()) {
                if (AUTOMATIC_REFRESH) {
                    this.t.start();
                }
                this.update(false);
            }
        }

        public void removeNotify() {
            this.getParent().removeComponentListener(this);
            this.t.stop();
            super.removeNotify();
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (AUTOMATIC_REFRESH) {
                this.t.start();
            }
            this.update(false);
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.t.stop();
        }

        private void update(boolean bl) {
            long l = this.r.totalMemory();
            long l2 = l - this.r.freeMemory();
            this.proportion = (double)l2 / (double)l;
            if (bl && this.graph != null) {
                this.graph[this.graphPointer] = this.proportion;
                this.graphPointer = (this.graphPointer + 1) % this.graph.length;
                if (this.graphPointer == this.graphBase) {
                    this.graphBase = (this.graphPointer + 1) % this.graph.length;
                }
            }
            Double d = new Double((double)l / 1024.0 / 1024.0);
            Double d2 = new Double((double)l2 / 1024.0 / 1024.0);
            String string = this.f.format(new Object[]{d2, d});
            this.setText(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            dimension.height -= 4;
            dimension.width -= 3;
            graphics.translate(3, 1);
            Color color = graphics.getColor();
            try {
                int n;
                Color color2 = UIManager.getColor("controlShadow");
                graphics.setColor(color2);
                int n2 = dimension.width - 2;
                if (this.graph == null) {
                    this.graph = new double[n2];
                    this.graphPointer = 0;
                    this.graphBase = 0;
                } else if (this.graph.length != n2) {
                    n = this.graph.length;
                    double[] dArray = new double[n2];
                    int n3 = n2;
                    int n4 = this.graphPointer;
                    while (n4 != this.graphBase && n3 > 0) {
                        n4 = (n4 + n - 1) % n;
                        dArray[--n3] = this.graph[n4];
                    }
                    this.graph = dArray;
                    this.graphPointer = 0;
                    this.graphBase = n3 % n2;
                }
                n = dimension.width - 3;
                if (!$assertionsDisabled && this.graphBase < 0) {
                    throw new AssertionError((Object)("graphBase=" + this.graphBase));
                }
                if (!$assertionsDisabled && this.graphBase >= n2) {
                    throw new AssertionError((Object)("graphBase=" + this.graphBase + " bufferLength=" + n2));
                }
                int n5 = this.graphPointer;
                while (n5 != this.graphBase) {
                    if (!$assertionsDisabled && n5 < 0) {
                        throw new AssertionError((Object)("i=" + n5));
                    }
                    if (!$assertionsDisabled && n5 >= n2) {
                        throw new AssertionError((Object)("i=" + n5 + " bufferLength=" + n2));
                    }
                    n5 = (n5 + n2 - 1) % n2;
                    double d = this.graph[n5];
                    int n6 = (int)((double)(dimension.height - 2) * d);
                    graphics.drawLine(n, dimension.height - 1 - n6, n, dimension.height - 1);
                    --n;
                }
                color2 = this.containsMouse ? this.getBackground().brighter() : this.getBackground().darker();
                graphics.setColor(color2);
                graphics.drawRect(0, 1, dimension.width - 2, dimension.height - 2);
                if (this.containsMouse) {
                    graphics.drawRect(1, 2, dimension.width - 4, dimension.height - 4);
                }
            }
            finally {
                graphics.setColor(color);
                graphics.translate(-3, -1);
            }
            super.paintComponent(graphics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.getID() == 500) {
                Graphics graphics = this.getGraphics();
                Color color = graphics.getColor();
                try {
                    graphics.setColor(UIManager.getColor("info"));
                    graphics.fillRect(0, 1, this.getWidth(), this.getHeight() - 1);
                    graphics.setColor(UIManager.getColor("infoText"));
                    graphics.setFont(this.getFont());
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    String string = NbBundle.getMessage((Class)(class$org$openide$actions$GarbageCollectAction == null ? (class$org$openide$actions$GarbageCollectAction = GarbageCollectAction.class$("org.openide.actions.GarbageCollectAction")) : class$org$openide$actions$GarbageCollectAction), (String)"MSG_GC");
                    Rectangle rectangle = new Rectangle();
                    SwingUtilities.layoutCompoundLabel(fontMetrics, string, null, 0, 2, 0, 2, new Rectangle(), new Rectangle(), rectangle, 0);
                    graphics.drawString(string, rectangle.x, rectangle.y);
                }
                finally {
                    graphics.setColor(color);
                }
                GarbageCollectAction.gc();
                this.repaint();
            } else if (mouseEvent.getID() == 504) {
                this.setToolTipText(NbBundle.getMessage((Class)(class$org$openide$actions$GarbageCollectAction == null ? (class$org$openide$actions$GarbageCollectAction = GarbageCollectAction.class$("org.openide.actions.GarbageCollectAction")) : class$org$openide$actions$GarbageCollectAction), (String)"CTL_GC") + " [" + this.getText() + "]");
                this.containsMouse = true;
                this.repaint();
            } else if (mouseEvent.getID() == 505) {
                this.containsMouse = false;
                this.repaint();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.update(true);
        }

        static {
            $assertionsDisabled = !(class$org$openide$actions$GarbageCollectAction == null ? (class$org$openide$actions$GarbageCollectAction = GarbageCollectAction.class$("org.openide.actions.GarbageCollectAction")) : class$org$openide$actions$GarbageCollectAction).desiredAssertionStatus();
            AUTOMATIC_REFRESH = System.getProperty("org.netbeans.log.startup") == null;
        }
    }
}

