/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotUndoException;
import org.openide.ErrorManager;
import org.openide.actions.RedoAction;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class UndoAction
extends CallableSystemAction {
    private static Listener listener;
    private static UndoRedo last;
    private static String SWING_DEFAULT_LABEL;
    private static UndoAction undoAction;
    private static RedoAction redoAction;

    public boolean isEnabled() {
        UndoAction.initializeUndoRedo();
        return super.isEnabled();
    }

    static synchronized void initializeUndoRedo() {
        if (listener != null) {
            return;
        }
        listener = new Listener();
        TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)registry));
        last = UndoAction.getUndoRedo();
        last.addChangeListener((ChangeListener)listener);
        UndoAction.updateStatus();
    }

    static synchronized void updateStatus() {
        if (undoAction == null) {
            undoAction = (UndoAction)UndoAction.findObject((Class)UndoAction.class, (boolean)false);
        }
        if (redoAction == null) {
            redoAction = (RedoAction)UndoAction.findObject((Class)RedoAction.class, (boolean)false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UndoRedo undoRedo = UndoAction.getUndoRedo();
                if (undoAction != null) {
                    undoAction.setEnabled(undoRedo.canUndo());
                }
                if (redoAction != null) {
                    redoAction.setEnabled(undoRedo.canRedo());
                }
            }
        });
    }

    static UndoRedo getUndoRedo() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        return topComponent == null ? UndoRedo.NONE : topComponent.getUndoRedo();
    }

    public String getName() {
        String string = UndoAction.getUndoRedo().getUndoPresentationName();
        if (string != null && SWING_DEFAULT_LABEL != null && string.startsWith(SWING_DEFAULT_LABEL)) {
            string = string.substring(0, SWING_DEFAULT_LABEL.length()).trim();
        }
        return NbBundle.getMessage((Class)UndoAction.class, (String)"Undo", (Object)string);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(UndoAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/undo.gif";
    }

    public void performAction() {
        try {
            UndoRedo undoRedo = UndoAction.getUndoRedo();
            if (undoRedo.canUndo()) {
                undoRedo.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            ErrorManager.getDefault().notify((Throwable)cannotUndoException);
        }
        UndoAction.updateStatus();
    }

    protected boolean asynchronous() {
        return false;
    }

    static {
        last = UndoRedo.NONE;
        SWING_DEFAULT_LABEL = UIManager.getString("AbstractUndoableEdit.undoText");
        undoAction = null;
        redoAction = null;
    }

    private static final class Listener
    implements PropertyChangeListener,
    ChangeListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            UndoAction.updateStatus();
            last.removeChangeListener((ChangeListener)this);
            last = UndoAction.getUndoRedo();
            last.addChangeListener((ChangeListener)this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            UndoAction.updateStatus();
        }
    }
}

