/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;

class HtmlBrowserComponent
extends CloneableTopComponent
implements PropertyChangeListener {
    static final long serialVersionUID = 2912844785502987960L;
    public static final String MODE_NAME = "webbrowser";
    private HtmlBrowser browserComponent;

    public HtmlBrowserComponent() {
        this(true, true);
    }

    public HtmlBrowserComponent(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    public HtmlBrowserComponent(HtmlBrowser.Factory factory, boolean bl, boolean bl2) {
        this.setName("");
        this.setLayout(new BorderLayout());
        this.browserComponent = new HtmlBrowser(factory, bl, bl2);
        this.add((Component)this.browserComponent, "Center");
        this.browserComponent.getBrowserImpl().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.browserComponent.getBrowserComponent() != null) {
            this.putClientProperty("InternalBrowser", Boolean.TRUE);
        }
        this.setToolTipText(NbBundle.getBundle((Class)HtmlBrowser.class).getString("HINT_WebBrowser"));
    }

    public int getPersistenceType() {
        return 1;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("title")) {
            return;
        }
        String string = this.browserComponent.getBrowserImpl().getTitle();
        if (string == null || string.length() < 1) {
            return;
        }
        this.setName(string);
        this.setDisplayName(string);
    }

    public void open() {
        if (this.browserComponent.getBrowserComponent() == null) {
            return;
        }
        super.open();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new BrowserReplacer(this);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.setStatusLineVisible(objectInput.readBoolean());
        this.setToolbarVisible(objectInput.readBoolean());
        this.browserComponent.setURL((URL)objectInput.readObject());
    }

    protected CloneableTopComponent createClonedObject() {
        HtmlBrowserComponent htmlBrowserComponent = new HtmlBrowserComponent();
        htmlBrowserComponent.setURL(this.getDocumentURL());
        return htmlBrowserComponent;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HtmlBrowserComponent.class);
    }

    protected void componentActivated() {
        this.browserComponent.getBrowserImpl().getComponent().requestFocusInWindow();
        super.componentActivated();
    }

    public Image getIcon() {
        return new ImageIcon(HtmlBrowser.class.getResource("/org/openide/resources/html/htmlView.gif")).getImage();
    }

    public void setURL(String string) {
        this.browserComponent.setURL(string);
    }

    public void setURL(URL uRL) {
        this.browserComponent.setURL(uRL);
    }

    public final URL getDocumentURL() {
        return this.browserComponent.getDocumentURL();
    }

    public final void setEnableHome(boolean bl) {
        this.browserComponent.setEnableHome(bl);
    }

    public final void setEnableLocation(boolean bl) {
        this.browserComponent.setEnableLocation(bl);
    }

    public boolean isStatusLineVisible() {
        return this.browserComponent.isStatusLineVisible();
    }

    public void setStatusLineVisible(boolean bl) {
        this.browserComponent.setStatusLineVisible(bl);
    }

    public boolean isToolbarVisible() {
        return this.browserComponent.isToolbarVisible();
    }

    public void setToolbarVisible(boolean bl) {
        this.browserComponent.setToolbarVisible(bl);
    }

    protected String preferredID() {
        return "HtmlBrowserComponent";
    }

    public static final class BrowserReplacer
    implements Externalizable {
        static final long serialVersionUID = 5915713034827048413L;
        private transient HtmlBrowserComponent bComp = null;
        transient boolean statLine;
        transient boolean toolbar;
        transient URL url;

        public BrowserReplacer() {
        }

        public BrowserReplacer(HtmlBrowserComponent htmlBrowserComponent) {
            this.bComp = htmlBrowserComponent;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeBoolean(this.bComp.isStatusLineVisible());
            objectOutput.writeBoolean(this.bComp.isToolbarVisible());
            objectOutput.writeObject(this.bComp.getDocumentURL());
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.statLine = objectInput.readBoolean();
            this.toolbar = objectInput.readBoolean();
            this.url = (URL)objectInput.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                if (this.url.getProtocol().equals("http") && InetAddress.getByName(this.url.getHost()).equals(InetAddress.getLocalHost())) {
                    this.url.openStream();
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {
                return null;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
            this.bComp = new HtmlBrowserComponent(this.statLine, this.toolbar);
            this.bComp.setURL(this.url);
            return this.bComp;
        }
    }
}

