/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.ManifestSection;
import org.openide.ErrorManager;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ReorderAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.InstanceSupport;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.util.io.SafeException;

public final class LoaderPoolNode
extends AbstractNode {
    private static final String LOADER_POOL_ICON_BASE = "org/netbeans/core/resources/loaderPool";
    private static LoaderPoolNode loaderPoolNode;
    private static final ErrorManager err;
    private static LoaderChildren myChildren;
    private static List loaders;
    private static Set modifiedLoaders;
    private static Map names2Loaders;
    private static Map repNames2Loaders;
    private static Map installBefores;
    private static Map installAfters;
    private static Object[] loadersArray;
    private static boolean installationFinished;
    private static boolean updatingBatch;
    private static boolean updatingBatchUsed;
    private static final String LOADER_POOL_NAME = "loaders.ser";
    private static NbLoaderPool nbLoaderPool;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$nodes$BeanNode;
    static /* synthetic */ Class class$org$netbeans$core$LoaderPoolNode$LoaderPoolItemNode;
    static /* synthetic */ Class class$org$openide$filesystems$MIMEResolver;

    private LoaderPoolNode() {
        super((Children)new LoaderChildren());
        myChildren = (LoaderChildren)this.getChildren();
        this.setName("LoaderPoolNode");
        this.setDisplayName(NbBundle.getMessage((Class)LoaderPoolNode.class, (String)"CTL_LoaderPool"));
        this.setIconBase(LOADER_POOL_ICON_BASE);
        this.getCookieSet().add((Node.Cookie)new Index());
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)LoaderPoolNode.getNbLoaderPool()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LoaderPoolNode.class);
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)ReorderAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
    }

    public static synchronized void beginUpdates() {
        updatingBatch = true;
        updatingBatchUsed = false;
    }

    public static synchronized void endUpdates() {
        if (!updatingBatch) {
            throw new IllegalStateException();
        }
        updatingBatch = false;
        if (updatingBatchUsed) {
            updatingBatchUsed = false;
            LoaderPoolNode.resort();
        }
    }

    public static void waitFinished() {
        LoaderPoolNode.getNbLoaderPool().fireTask.waitFinished();
    }

    public static void add(ManifestSection.LoaderSection loaderSection) throws Exception {
        DataLoader dataLoader = (DataLoader)loaderSection.getInstance();
        LoaderPoolNode.doAdd(dataLoader, loaderSection);
    }

    static synchronized void doAdd(DataLoader dataLoader, ManifestSection.LoaderSection loaderSection) throws Exception {
        Class<?> clazz;
        Iterator iterator;
        if (err.isLoggable(1) && loaderSection != null) {
            iterator = loaderSection.getInstallBefore() == null ? null : Arrays.asList(loaderSection.getInstallBefore());
            clazz = loaderSection.getInstallAfter() == null ? null : Arrays.asList(loaderSection.getInstallAfter());
            err.log("add: " + dataLoader + " repclass: " + dataLoader.getRepresentationClass().getName() + " before: " + iterator + " after: " + clazz);
        }
        iterator = loaders.iterator();
        clazz = dataLoader.getClass();
        while (iterator.hasNext()) {
            if (iterator.next().getClass() != clazz) continue;
            iterator.remove();
            break;
        }
        loaders.add(dataLoader);
        dataLoader.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        dataLoader.addPropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        String string = clazz.getName();
        names2Loaders.put(string, dataLoader);
        repNames2Loaders.put(dataLoader.getRepresentationClassName(), dataLoader);
        if (loaderSection != null) {
            String[] stringArray;
            String[] stringArray2 = loaderSection.getInstallBefore();
            if (stringArray2 != null) {
                installBefores.put(string, stringArray2);
            }
            if ((stringArray = loaderSection.getInstallAfter()) != null) {
                installAfters.put(string, stringArray);
            }
        }
        if (updatingBatch) {
            updatingBatchUsed = true;
        } else {
            LoaderPoolNode.resort();
        }
    }

    private static synchronized void resort() {
        HashMap hashMap = new HashMap();
        LoaderPoolNode.add2Deps(hashMap, installBefores, true);
        LoaderPoolNode.add2Deps(hashMap, installAfters, false);
        if (err.isLoggable(1)) {
            err.log("Before sort: " + loaders);
        }
        try {
            loaders = Utilities.topologicalSort((Collection)loaders, hashMap);
            if (err.isLoggable(1)) {
                err.log("After sort: " + loaders);
            }
        }
        catch (TopologicalSortException topologicalSortException) {
            err.notify(1, (Throwable)topologicalSortException);
            err.log(16, "Contradictory loader ordering: " + hashMap);
        }
        LoaderPoolNode.update();
    }

    private static void add2Deps(Map map, Map map2, boolean bl) {
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            DataLoader dataLoader = (DataLoader)names2Loaders.get(string);
            if (dataLoader == null) {
                throw new IllegalStateException("No such loader: " + string);
            }
            String[] stringArray = (String[])entry.getValue();
            if (stringArray == null) {
                throw new IllegalStateException("Null Install-" + (bl ? "Before" : "After") + " for " + string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                DataLoader dataLoader2 = (DataLoader)repNames2Loaders.get(string2);
                if (dataLoader2 != null) {
                    if (bl) {
                        LoaderPoolNode.addDep(map, dataLoader, dataLoader2);
                        continue;
                    }
                    LoaderPoolNode.addDep(map, dataLoader2, dataLoader);
                    continue;
                }
                dataLoader2 = (DataLoader)names2Loaders.get(string2);
                if (dataLoader2 == null) continue;
                LoaderPoolNode.warn(string, string2, dataLoader2.getRepresentationClassName());
            }
        }
    }

    private static void addDep(Map map, DataLoader dataLoader, DataLoader dataLoader2) {
        LinkedList<DataLoader> linkedList = (LinkedList<DataLoader>)map.get(dataLoader);
        if (linkedList == null) {
            linkedList = new LinkedList<DataLoader>();
            map.put(dataLoader, linkedList);
        }
        if (!linkedList.contains(dataLoader2)) {
            linkedList.add(dataLoader2);
        }
    }

    private static void warn(String string, String string2, String string3) {
        err.log(16, "Warning: a possible error in the manifest containing " + string + " was found.");
        err.log(16, "The loader specified an Install-{After,Before} on " + string2 + ", but this is a DataLoader class.");
        err.log(16, "Probably you wanted " + string3 + " which is the loader's representation class.");
    }

    static void installationFinished() {
        installationFinished = true;
        if (myChildren != null) {
            myChildren.update();
        }
    }

    static synchronized boolean isModified(DataLoader dataLoader) {
        return modifiedLoaders.contains(dataLoader);
    }

    private static synchronized void writePool(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        String string;
        Object object2;
        if (err.isLoggable(1)) {
            err.log("writePool");
        }
        objectOutputStream.writeObject(new HashMap());
        objectOutputStream.writeObject(new HashMap());
        Collection collection = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances();
        Iterator iterator = loaders.iterator();
        while (iterator.hasNext()) {
            object2 = (DataLoader)iterator.next();
            if (!LoaderPoolNode.isModified((DataLoader)object2)) {
                string = object2.getClass().getName();
                if (err.isLoggable(1)) {
                    err.log("writing unmodified " + string);
                }
                objectOutputStream.writeObject("=" + string);
                continue;
            }
            try {
                string = new NbMarshalledObject(object2);
            }
            catch (IOException iOException) {
                err.notify((Throwable)iOException);
                string = null;
            }
            if (string == null) continue;
            if (err.isLoggable(1)) {
                err.log("writing modified " + object2.getClass().getName());
            }
            object = object2.getClass();
            Iterator iterator2 = collection.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator2.next();
                if (!moduleInfo.isEnabled() || !moduleInfo.owns((Class)object)) continue;
                if (err.isLoggable(1)) {
                    err.log("belongs to module: " + moduleInfo.getCodeNameBase());
                }
                objectOutputStream.writeObject(moduleInfo.getCodeNameBase());
                int n = moduleInfo.getCodeNameRelease();
                objectOutputStream.writeInt(n);
                SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
                if (specificationVersion != null) {
                    objectOutputStream.writeObject(specificationVersion.toString());
                } else {
                    objectOutputStream.writeObject(null);
                }
                bl = true;
                break;
            }
            if (!bl && err.isLoggable(1)) {
                err.log("does not belong to any module");
            }
            objectOutputStream.writeObject(string);
        }
        if (err.isLoggable(1)) {
            err.log("writing null");
        }
        objectOutputStream.writeObject(null);
        object2 = LoaderPoolNode.getNbLoaderPool().allLoaders();
        while (object2.hasMoreElements()) {
            string = (DataLoader)object2.nextElement();
            if (loaders.contains(string)) continue;
            if (!LoaderPoolNode.isModified((DataLoader)string)) {
                object = string.getClass().getName();
                if (!err.isLoggable(1)) continue;
                err.log("skipping unmodified " + (String)object);
                continue;
            }
            try {
                object = new NbMarshalledObject((Object)string);
            }
            catch (IOException iOException) {
                err.notify((Throwable)iOException);
                object = null;
            }
            if (object == null) continue;
            if (err.isLoggable(1)) {
                err.log("writing " + string.getClass().getName());
            }
            objectOutputStream.writeObject(object);
        }
        if (err.isLoggable(1)) {
            err.log("writing null");
        }
        objectOutputStream.writeObject(null);
        if (err.isLoggable(1)) {
            err.log("done writing");
        }
    }

    private static synchronized void readPool(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        Iterator iterator;
        objectInputStream.readObject();
        objectInputStream.readObject();
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object3 = null;
        Iterator iterator2 = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances().iterator();
        HashMap hashMap = new HashMap();
        while (iterator2.hasNext()) {
            iterator = (ModuleInfo)iterator2.next();
            hashMap.put(iterator.getCodeNameBase(), iterator);
        }
        while (true) {
            Object object4;
            if ((iterator = objectInputStream.readObject()) == null) {
                if (!err.isLoggable(1)) break;
                err.log("reading null");
                break;
            }
            if (iterator instanceof String) {
                SpecificationVersion specificationVersion;
                object2 = (String)((Object)iterator);
                if (((String)object2).length() > 0 && ((String)object2).charAt(0) == '=') {
                    String string = ((String)object2).substring(1);
                    object4 = (DataLoader)names2Loaders.get(string);
                    if (object4 != null) {
                        if (err.isLoggable(1)) {
                            err.log("reading unmodified " + string);
                        }
                        linkedList.add(object4);
                        hashSet.add(object4.getClass());
                        continue;
                    }
                    if (!err.isLoggable(1)) continue;
                    err.log("skipping unmodified nonexistent " + string);
                    continue;
                }
                int n = objectInputStream.readInt();
                object4 = (String)objectInputStream.readObject();
                object = (NbMarshalledObject)objectInputStream.readObject();
                ModuleInfo moduleInfo = (ModuleInfo)hashMap.get(object2);
                if (moduleInfo == null) {
                    if (!err.isLoggable(1)) continue;
                    err.log("No known module " + (String)object2 + ", skipping loader");
                    continue;
                }
                if (!moduleInfo.isEnabled()) {
                    if (!err.isLoggable(1)) continue;
                    err.log("Module " + (String)object2 + " is disabled, skipping loader");
                    continue;
                }
                if (moduleInfo.getCodeNameRelease() < n) {
                    if (!err.isLoggable(1)) continue;
                    err.log("Module " + (String)object2 + " is too old (major vers.), skipping loader");
                    continue;
                }
                if (object4 != null && ((specificationVersion = moduleInfo.getSpecificationVersion()) == null || specificationVersion.compareTo((Object)new SpecificationVersion((String)object4)) < 0)) {
                    if (!err.isLoggable(1)) continue;
                    err.log("Module " + (String)object2 + " is too old (spec. vers.), skipping loader");
                    continue;
                }
                if (err.isLoggable(1)) {
                    err.log("Module " + (String)object2 + " is OK, will try to restore loader");
                }
            } else {
                object = (NbMarshalledObject)iterator;
            }
            object2 = null;
            try {
                DataLoader dataLoader = (DataLoader)object.get();
                if (dataLoader == null) continue;
                object4 = dataLoader.getClass();
                if (err.isLoggable(1)) {
                    err.log("reading modified " + ((Class)object4).getName());
                }
                linkedList.add(dataLoader);
                hashSet.add(object4);
            }
            catch (IOException iOException) {
                object2 = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object2 = classNotFoundException;
            }
            if (object2 == null) continue;
            ErrorManager.getDefault().annotate((Throwable)object2, 16, null, null, null, null);
            if (object3 == null) {
                object3 = object2;
                continue;
            }
            ErrorManager.getDefault().annotate((Throwable)object3, (Throwable)object2);
        }
        while (true) {
            if ((iterator = (NbMarshalledObject)objectInputStream.readObject()) == null) {
                if (!err.isLoggable(1)) break;
                err.log("reading null");
                break;
            }
            object = null;
            try {
                object2 = (DataLoader)iterator.get();
                if (err.isLoggable(1)) {
                    err.log("reading " + object2.getClass().getName());
                }
            }
            catch (IOException iOException) {
                object = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = classNotFoundException;
            }
            if (object == null) continue;
            ErrorManager.getDefault().annotate((Throwable)object, 16, null, null, null, null);
            if (object3 == null) {
                object3 = object;
                continue;
            }
            ErrorManager.getDefault().annotate((Throwable)object3, (Throwable)object);
        }
        if (err.isLoggable(1)) {
            err.log("done reading");
        }
        iterator = loaders.iterator();
        while (iterator.hasNext()) {
            object = (DataLoader)iterator.next();
            if (hashSet.contains(object.getClass())) continue;
            linkedList.add(object);
        }
        if (linkedList.size() > new HashSet(linkedList).size()) {
            throw new IllegalStateException("Duplicates in " + linkedList);
        }
        loaders = linkedList;
        LoaderPoolNode.resort();
        if (object3 != null) {
            throw new SafeException((Exception)object3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() throws IOException {
        FileObject fileObject = LoaderPoolNode.getLoaderPoolStorage(true);
        FileLock fileLock = fileObject.lock();
        try {
            NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(fileObject.getOutputStream(fileLock));
            try {
                NbObjectOutputStream.writeSafely((ObjectOutput)nbObjectOutputStream, (Object)LoaderPoolNode.getNbLoaderPool());
            }
            finally {
                nbObjectOutputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws IOException {
        FileObject fileObject = LoaderPoolNode.getLoaderPoolStorage(false);
        if (fileObject != null) {
            NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(fileObject.getInputStream());
            try {
                NbObjectInputStream.readSafely((ObjectInput)nbObjectInputStream);
            }
            finally {
                nbObjectInputStream.close();
            }
        }
    }

    public static FileObject getLoaderPoolStorage(boolean bl) throws IOException {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(LOADER_POOL_NAME);
        if (fileObject == null && bl) {
            fileObject = fileSystem.getRoot().createData(LOADER_POOL_NAME);
        }
        return fileObject;
    }

    private static synchronized void update() {
        if (err.isLoggable(1)) {
            err.log("update");
        }
        loadersArray = null;
        NbLoaderPool nbLoaderPool = LoaderPoolNode.getNbLoaderPool();
        if (nbLoaderPool != null && installationFinished) {
            nbLoaderPool.superFireChangeEvent();
            if (myChildren != null) {
                myChildren.update();
            }
        }
        if (nbLoaderPool != null) {
            Enumeration enumeration = nbLoaderPool.allLoaders();
            while (enumeration.hasMoreElements()) {
                DataLoader dataLoader = (DataLoader)enumeration.nextElement();
                dataLoader.removePropertyChangeListener((PropertyChangeListener)nbLoaderPool);
                dataLoader.addPropertyChangeListener((PropertyChangeListener)nbLoaderPool);
            }
        }
    }

    public static synchronized boolean remove(DataLoader dataLoader) {
        if (loaders.remove(dataLoader)) {
            if (err.isLoggable(1)) {
                err.log("remove: " + dataLoader);
            }
            String string = dataLoader.getClass().getName();
            names2Loaders.remove(string);
            repNames2Loaders.remove(dataLoader.getRepresentationClassName());
            installBefores.remove(string);
            installAfters.remove(string);
            dataLoader.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
            if (updatingBatch) {
                updatingBatchUsed = true;
            } else {
                LoaderPoolNode.resort();
            }
            modifiedLoaders.remove(dataLoader);
            return true;
        }
        return false;
    }

    public static synchronized LoaderPoolNode getLoaderPoolNode() {
        if (loaderPoolNode == null) {
            loaderPoolNode = new LoaderPoolNode();
        }
        return loaderPoolNode;
    }

    public static synchronized NbLoaderPool getNbLoaderPool() {
        if (nbLoaderPool == null) {
            nbLoaderPool = (NbLoaderPool)DataLoaderPool.getDefault();
        }
        return nbLoaderPool;
    }

    static /* synthetic */ Object[] access$302(Object[] objectArray) {
        loadersArray = objectArray;
        return objectArray;
    }

    static {
        err = ErrorManager.getDefault().getInstance("org.netbeans.core.LoaderPoolNode");
        loaders = new ArrayList();
        modifiedLoaders = new HashSet();
        names2Loaders = new HashMap(200);
        repNames2Loaders = new HashMap(200);
        installBefores = new HashMap();
        installAfters = new HashMap();
        installationFinished = false;
        updatingBatch = false;
        updatingBatchUsed = false;
        nbLoaderPool = null;
    }

    private final class Index
    extends Index.Support {
        Index() {
        }

        public Node[] getNodes() {
            Enumeration enumeration = LoaderPoolNode.this.getChildren().nodes();
            ArrayList<LoaderPoolItemNode> arrayList = new ArrayList<LoaderPoolItemNode>();
            while (enumeration.hasMoreElements()) {
                LoaderPoolItemNode loaderPoolItemNode = (LoaderPoolItemNode)((Object)enumeration.nextElement());
                if (loaderPoolItemNode.isSystem) continue;
                arrayList.add(loaderPoolItemNode);
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reorder(int[] nArray) {
            Class clazz = class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode;
            synchronized (clazz) {
                Object[] objectArray;
                Object[] objectArray2 = loaders.toArray();
                if (objectArray2.length == nArray.length) {
                    objectArray = new Object[objectArray2.length];
                    for (int i = 0; i < objectArray2.length; ++i) {
                        if (objectArray[nArray[i]] != null) {
                            throw new IllegalArgumentException();
                        }
                        objectArray[nArray[i]] = objectArray2[i];
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                loaders = new ArrayList<Object>(Arrays.asList(objectArray));
                LoaderPoolNode.update();
            }
        }
    }

    public static final class NbLoaderPool
    extends DataLoaderPool
    implements PropertyChangeListener,
    Runnable,
    LookupListener {
        private static final long serialVersionUID = -8488524097175567566L;
        private transient RequestProcessor.Task fireTask = rp.create((Runnable)this, true);
        private transient Lookup.Result mimeResolvers = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$filesystems$MIMEResolver == null ? (class$org$openide$filesystems$MIMEResolver = LoaderPoolNode.class$("org.openide.filesystems.MIMEResolver")) : class$org$openide$filesystems$MIMEResolver));
        private static RequestProcessor rp = new RequestProcessor("Refresh Loader Pool");

        public NbLoaderPool() {
            this.mimeResolvers.addLookupListener((LookupListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Enumeration loaders() {
            Object[] objectArray = loadersArray;
            if (objectArray == null) {
                Class clazz = class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode;
                synchronized (clazz) {
                    objectArray = LoaderPoolNode.access$302(loaders.toArray());
                }
            }
            return Enumerations.array((Object[])objectArray);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataLoader dataLoader = (DataLoader)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("actions".equals(string) && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            modifiedLoaders.add(dataLoader);
            if (err.isLoggable(1)) {
                err.log("Got change in " + dataLoader.getClass().getName() + "." + string);
            }
            if ("actions".equals(string) || "displayName".equals(string)) {
                return;
            }
            if (installationFinished) {
                this.superFireChangeEvent();
            }
        }

        void superFireChangeEvent() {
            err.log("Change in loader pool scheduled");
            this.fireTask.schedule(1000);
        }

        public void run() {
            err.log("going to fire change in loaders");
            super.fireChangeEvent(new ChangeEvent(this));
            err.log("change event fired");
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            LoaderPoolNode.writePool(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            LoaderPoolNode.readPool(objectInputStream);
        }

        private Object readResolve() {
            return LoaderPoolNode.getNbLoaderPool();
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (Main.isInitialized()) {
                this.superFireChangeEvent();
            }
        }
    }

    private static final class LoaderChildren
    extends Children.Keys {
        public LoaderChildren() {
            this.update();
        }

        public void update() {
            LinkedList linkedList = new LinkedList();
            Enumeration enumeration = LoaderPoolNode.getNbLoaderPool().allLoaders();
            while (enumeration.hasMoreElements()) {
                linkedList.add(enumeration.nextElement());
            }
            this.setKeys(linkedList);
        }

        protected Node[] createNodes(Object object) {
            try {
                return new Node[]{new LoaderPoolItemNode((DataLoader)object)};
            }
            catch (IntrospectionException introspectionException) {
                err.notify((Throwable)introspectionException);
                return new Node[0];
            }
        }
    }

    private static class LoaderPoolItemNode
    extends BeanNode {
        boolean isSystem;

        public LoaderPoolItemNode(DataLoader dataLoader) throws IntrospectionException {
            super((Object)dataLoader);
            this.setSynchronizeName(false);
            String string = this.getDisplayName();
            this.setName(dataLoader.getClass().getName());
            boolean bl = this.isSystem = !loaders.contains(dataLoader);
            if (this.isSystem) {
                this.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode), (String)"LBL_system_data_loader", (Object)string));
            } else {
                this.setDisplayName(string);
            }
        }

        public SystemAction[] createActions() {
            if (this.isSystem) {
                return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = LoaderPoolNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
            }
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = LoaderPoolNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = LoaderPoolNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = LoaderPoolNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public Action getPreferredAction() {
            return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            HelpCtx helpCtx = super.getHelpCtx();
            if (helpCtx == null || helpCtx.getHelpID() == null || helpCtx.getHelpID().equals((class$org$openide$nodes$BeanNode == null ? (class$org$openide$nodes$BeanNode = LoaderPoolNode.class$("org.openide.nodes.BeanNode")) : class$org$openide$nodes$BeanNode).getName())) {
                helpCtx = new HelpCtx(class$org$netbeans$core$LoaderPoolNode$LoaderPoolItemNode == null ? (class$org$netbeans$core$LoaderPoolNode$LoaderPoolItemNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode$LoaderPoolItemNode")) : class$org$netbeans$core$LoaderPoolNode$LoaderPoolItemNode);
            }
            return helpCtx;
        }
    }
}

