/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class NbAuthenticator
extends Authenticator {
    NbAuthenticator() {
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        InetAddress inetAddress = this.getRequestingSite();
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)NbAuthenticator.class);
        String string = inetAddress == null ? resourceBundle.getString("CTL_PasswordProtected") : inetAddress.getHostName();
        PasswordPanel passwordPanel = new PasswordPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)passwordPanel, string);
        dialogDescriptor.setHelpCtx(new HelpCtx(NbAuthenticator.class.getName() + ".getPasswordAuthentication"));
        passwordPanel.setPrompt(this.getRequestingPrompt());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue().equals(NotifyDescriptor.OK_OPTION)) {
            return new PasswordAuthentication(passwordPanel.getUsername(), passwordPanel.getPassword());
        }
        return null;
    }

    static class PasswordPanel
    extends JPanel {
        private static final int DEFAULT_WIDTH = 200;
        private static final int DEFAULT_HEIGHT = 0;
        static final long serialVersionUID = 1555749205340031767L;
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$NbAuthenticator == null ? (class$org$netbeans$core$NbAuthenticator = NbAuthenticator.class$("org.netbeans.core.NbAuthenticator")) : class$org$netbeans$core$NbAuthenticator));
        private JPanel mainPanel;
        private JLabel promptLabel;
        private JLabel jLabel1;
        private JTextField usernameField;
        private JLabel jLabel2;
        private JPasswordField passwordField;

        public PasswordPanel() {
            this.initComponents();
            this.usernameField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_UserNameField"));
            this.passwordField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_PasswordField"));
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(dimension.width, 200), Math.max(dimension.height, 0));
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
            this.promptLabel = new JLabel();
            this.promptLabel.setHorizontalAlignment(0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            this.mainPanel.add((Component)this.promptLabel, gridBagConstraints);
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(this.bundle.getString("LAB_AUTH_User_Name"));
            this.jLabel1.setDisplayedMnemonic(this.bundle.getString("LAB_AUTH_User_Name_Mnemonic").charAt(0));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 5, 12);
            gridBagConstraints.anchor = 17;
            this.mainPanel.add((Component)this.jLabel1, gridBagConstraints);
            this.usernameField = new JTextField();
            this.usernameField.setMinimumSize(new Dimension(70, 20));
            this.usernameField.setPreferredSize(new Dimension(70, 20));
            this.jLabel1.setLabelFor(this.usernameField);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.mainPanel.add((Component)this.usernameField, gridBagConstraints);
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$NbAuthenticator == null ? (class$org$netbeans$core$NbAuthenticator = NbAuthenticator.class$("org.netbeans.core.NbAuthenticator")) : class$org$netbeans$core$NbAuthenticator)).getString("LAB_AUTH_Password"));
            this.jLabel2.setDisplayedMnemonic(this.bundle.getString("LAB_AUTH_Password_Mnemonic").charAt(0));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.anchor = 17;
            this.mainPanel.add((Component)this.jLabel2, gridBagConstraints);
            this.passwordField = new JPasswordField();
            this.passwordField.setMinimumSize(new Dimension(70, 20));
            this.passwordField.setPreferredSize(new Dimension(70, 20));
            this.jLabel2.setLabelFor(this.passwordField);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.mainPanel.add((Component)this.passwordField, gridBagConstraints);
            this.add((Component)this.mainPanel, "Center");
        }

        String getUsername() {
            return this.usernameField.getText();
        }

        char[] getPassword() {
            return this.passwordField.getPassword();
        }

        void setPrompt(String string) {
            if (string == null) {
                this.promptLabel.setVisible(false);
                this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_NbAuthenticatorPasswordPanel"));
            } else {
                this.promptLabel.setVisible(true);
                this.promptLabel.setText(string);
                this.getAccessibleContext().setAccessibleDescription(string);
            }
        }
    }
}

