/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Collection;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExClipboard;

public final class NbClipboard
extends ExClipboard
implements LookupListener,
AWTEventListener,
Runnable {
    private ErrorManager log;
    private Clipboard systemClipboard;
    private ExClipboard.Convertor[] convertors;
    private Lookup.Result result;
    private boolean slowSystemClipboard;
    private Transferable last;
    private long lastWindowActivated;
    private long lastWindowDeactivated;
    private Object lastWindowDeactivatedSource;
    private RequestProcessor.Task syncTask = new RequestProcessor("System clipboard synchronizer").create((Runnable)this);
    private Transferable data;
    private ClipboardOwner dataOwner;

    public NbClipboard() {
        super("NBClipboard");
        this.systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.log = ErrorManager.getDefault().getInstance("org.netbeans.core.NbClipboard");
        this.result = Lookup.getDefault().lookup(new Lookup.Template(ExClipboard.Convertor.class));
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
        this.slowSystemClipboard = System.getProperty("netbeans.slow.system.clipboard.hack") != null ? Boolean.getBoolean("netbeans.slow.system.clipboard.hack") : true;
        if (this.slowSystemClipboard) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    protected synchronized ExClipboard.Convertor[] getConvertors() {
        return this.convertors;
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        Collection collection = this.result.allInstances();
        ExClipboard.Convertor[] convertorArray = new ExClipboard.Convertor[collection.size()];
        this.convertors = collection.toArray(convertorArray);
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (this.log.isLoggable(1)) {
            this.log.log(1, "setContents called with: ");
            this.logFlavors(transferable);
        }
        transferable = this.convert(transferable);
        if (this.log.isLoggable(1)) {
            this.log.log(1, "After conversion:");
            this.logFlavors(transferable);
        }
        if (this.slowSystemClipboard) {
            super.setContents(transferable, clipboardOwner);
        } else {
            if (this.last != null) {
                NbClipboard.transferableOwnershipLost((Transferable)this.last);
            }
            this.last = transferable;
        }
        this.data = transferable;
        this.dataOwner = clipboardOwner;
        this.syncTask.schedule(0);
        this.fireClipboardChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getContents(Object object) {
        try {
            Transferable transferable;
            if (this.slowSystemClipboard) {
                if (this.lastWindowActivated != 0L && this.lastWindowActivated + 100L < System.currentTimeMillis()) {
                    this.lastWindowActivated = 0L;
                    this.syncTask.schedule(0);
                    this.syncTask.waitFinished(100L);
                }
                transferable = super.getContents(object);
            } else {
                this.syncTask.waitFinished();
                transferable = this.systemClipboard.getContents(object);
            }
            NbClipboard nbClipboard = this;
            synchronized (nbClipboard) {
                if (this.log.isLoggable(1)) {
                    this.log.log(1, "getContents by " + object);
                    this.logFlavors(transferable);
                }
                if (transferable == null) {
                    return null;
                }
                Transferable transferable2 = this.convert(transferable);
                if (this.log.isLoggable(1)) {
                    this.log.log(1, "getContents by " + object);
                    this.logFlavors(transferable2);
                    transferable2 = new LoggableTransferable(transferable2);
                }
                return transferable2;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Transferable transferable = null;
        ClipboardOwner clipboardOwner = null;
        Object object = this;
        synchronized (object) {
            if (this.data != null) {
                transferable = this.data;
                clipboardOwner = this.dataOwner;
            }
            this.data = null;
            this.dataOwner = null;
        }
        if (transferable != null) {
            if (this.log.isLoggable(1)) {
                this.log.log(1, "systemClipboard updated:");
                this.logFlavors(transferable);
            }
            this.systemClipboard.setContents(transferable, clipboardOwner);
            return;
        }
        try {
            object = this.systemClipboard.getContents(this);
            super.setContents((Transferable)object, null);
            if (this.log.isLoggable(1)) {
                this.log.log(1, "internal clipboard updated:");
                this.logFlavors((Transferable)object);
            }
            this.fireClipboardChange();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void waitFinished() {
        this.syncTask.waitFinished();
    }

    final void activateWindowHack(boolean bl) {
        this.lastWindowActivated = System.currentTimeMillis();
        if (bl) {
            this.syncTask.schedule(0);
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof WindowEvent)) {
            return;
        }
        if (aWTEvent.getID() == 206) {
            this.lastWindowDeactivated = System.currentTimeMillis();
            this.lastWindowDeactivatedSource = aWTEvent.getSource();
        }
        if (aWTEvent.getID() == 205) {
            if (System.currentTimeMillis() - this.lastWindowDeactivated < 100L && aWTEvent.getSource() == this.lastWindowDeactivatedSource) {
                this.activateWindowHack(false);
            }
            if (this.log.isLoggable(1)) {
                this.log.log(1, "window activated scheduling update");
            }
            this.syncTask.schedule(0);
        }
    }

    private void logFlavors(Transferable transferable) {
        if (transferable == null) {
            this.log.log(1, "  no clipboard contents");
        } else {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                this.log.log(1, "  " + i + " = " + dataFlavorArray[i]);
            }
        }
    }

    private final class LoggableTransferable
    implements Transferable {
        private Transferable delegate;

        public LoggableTransferable(Transferable transferable) {
            this.delegate = transferable;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            ErrorManager errorManager = NbClipboard.this.log;
            NbClipboard.this.log;
            errorManager.log(1, "Request for flavor: " + dataFlavor);
            Object object = this.delegate.getTransferData(dataFlavor);
            ErrorManager errorManager2 = NbClipboard.this.log;
            NbClipboard.this.log;
            errorManager2.log(1, "Returning value: " + object);
            return object;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.delegate.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            boolean bl = this.delegate.isDataFlavorSupported(dataFlavor);
            ErrorManager errorManager = NbClipboard.this.log;
            NbClipboard.this.log;
            errorManager.log(1, "isDataFlavorSupported: " + dataFlavor + " result: " + bl);
            return bl;
        }
    }
}

