/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.netbeans.core.NotifyException;
import org.netbeans.core.startup.TopLogging;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.xml.sax.SAXParseException;

public final class NbErrorManager
extends ErrorManager {
    private static final Map map = new WeakHashMap(11);
    private static final MessageFormat EXC_HEADER = new MessageFormat("{0}*********** Exception occurred ************ at {1,time,short} on {1,date,medium}", Locale.ENGLISH);
    private PrintStream logWriter;
    private final int minLogSeverity;
    private final String prefix;
    private final int uniquifier;
    private static final Map uniquifiedIds = new HashMap(20);
    private static Map NESTS;
    static /* synthetic */ Class class$java$lang$Object;

    public NbErrorManager() {
        this(null, NbErrorManager.defaultSeverity(), null);
    }

    NbErrorManager(PrintStream printStream) {
        this(null, NbErrorManager.defaultSeverity(), printStream);
    }

    private static int defaultSeverity() {
        String string = System.getProperty("ErrorManager.minimum");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NbErrorManager(String string, int n, PrintStream printStream) {
        this.prefix = string;
        this.minLogSeverity = n;
        this.logWriter = printStream;
        Map map = uniquifiedIds;
        synchronized (map) {
            Integer n2 = (Integer)uniquifiedIds.get(string);
            this.uniquifier = n2 == null ? 1 : n2 + 1;
            uniquifiedIds.put(string, new Integer(this.uniquifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream getLogWriter() {
        Object object = this;
        synchronized (object) {
            if (this.logWriter != null) {
                return this.logWriter;
            }
            this.logWriter = System.err;
        }
        object = TopLogging.getLogOutputStream();
        NbErrorManager nbErrorManager = this;
        synchronized (nbErrorManager) {
            this.logWriter = object;
            return this.logWriter;
        }
    }

    public synchronized Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
        ArrayList<Ann> arrayList;
        Object v = map.get(throwable);
        if (v == null) {
            arrayList = new ArrayList<Ann>();
            map.put(throwable, arrayList);
        } else {
            arrayList = (ArrayList<Ann>)v;
        }
        arrayList.add(0, new Ann(n, string, string2, throwable2, date));
        return throwable;
    }

    public synchronized Throwable attachAnnotations(Throwable throwable, ErrorManager.Annotation[] annotationArray) {
        ArrayList<ErrorManager.Annotation> arrayList;
        Object v = map.get(throwable);
        if (v == null) {
            arrayList = new ArrayList<ErrorManager.Annotation>(annotationArray.length + 5);
            map.put(throwable, arrayList);
        } else {
            arrayList = (ArrayList<ErrorManager.Annotation>)v;
        }
        arrayList.addAll(0, Arrays.asList(annotationArray));
        return throwable;
    }

    public boolean isNotifiable(int n) {
        return this.isLoggable(n + 1);
    }

    public synchronized void notify(int n, Throwable throwable) {
        Object object;
        boolean bl;
        Exc exc = this.createExc(throwable, n);
        if (!this.isNotifiable(exc.getSeverity())) {
            return;
        }
        boolean bl2 = bl = n != 256;
        if (bl && (object = this.findAnnotations(throwable)) != null) {
            for (int i = 0; i < ((ErrorManager.Annotation[])object).length; ++i) {
                if (!(object[i] instanceof Ann) || ((Ann)object[i]).getSeverity() != 256) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            object = this.getLogWriter();
            if (this.prefix != null) {
                ((PrintStream)object).print("[" + this.prefix + "] ");
            }
            String string = exc.getSeverity() == 1 ? "INFORMATIONAL " : "";
            ((PrintStream)object).println(EXC_HEADER.format(new Object[]{string, exc.getDate()}));
            exc.printStackTrace((PrintStream)object);
        }
        if (exc.getSeverity() > 1) {
            NotifyException.notify(exc);
        }
    }

    Exc createExc(Throwable throwable, int n) {
        ErrorManager.Annotation[] annotationArray = this.findAnnotations(throwable);
        return new Exc(throwable, n, annotationArray, this.findAnnotations0(throwable, true, new HashSet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int n, String string) {
        if (this.isLoggable(n)) {
            PrintStream printStream = this.getLogWriter();
            if (this.prefix != null) {
                boolean bl;
                if (this.uniquifier > 1) {
                    bl = true;
                } else if (this.uniquifier == 1) {
                    Map map = uniquifiedIds;
                    synchronized (map) {
                        int n2 = (Integer)uniquifiedIds.get(this.prefix);
                        bl = n2 > 1;
                    }
                } else {
                    throw new IllegalStateException("prefix != null yet uniquifier == 0");
                }
                if (bl) {
                    printStream.print("[" + this.prefix + " #" + this.uniquifier + "] ");
                } else {
                    printStream.print("[" + this.prefix + "] ");
                }
            }
            printStream.println(string);
        }
    }

    public boolean isLoggable(int n) {
        return n >= this.minLogSeverity;
    }

    public final ErrorManager getInstance(String string) {
        String string2 = this.prefix == null ? string : this.prefix + '.' + string;
        int n = this.minLogSeverity;
        String string3 = string2;
        while (string3 != null) {
            String string4 = System.getProperty(string3);
            if (string4 != null) {
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    this.notify(16, numberFormatException);
                }
                break;
            }
            int n2 = string3.lastIndexOf(46);
            if (n2 == -1) {
                string3 = null;
                continue;
            }
            string3 = string3.substring(0, n2);
        }
        return new NbErrorManager(string2, n, this.logWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Throwable extractNestedThrowable(Throwable throwable) {
        Class clazz = NbErrorManager.class;
        synchronized (clazz) {
            if (NESTS == null) {
                NESTS = new HashMap(50);
                NESTS.put("java.lang.ClassNotFoundException", "getException");
                NESTS.put("java.lang.ExceptionInInitializerError", "getException");
                NESTS.put("java.lang.reflect.InvocationTargetException", "getTargetException");
                NESTS.put("java.lang.reflect.UndeclaredThrowableException", "getUndeclaredThrowable");
                NESTS.put("java.security.PrivilegedActionException", "getException");
                NESTS.put("javax.naming.NamingException", "getRootCause");
                NESTS.put("javax.xml.parsers.FactoryConfigurationError", "getException");
                NESTS.put("javax.xml.transform.TransformerException", "getException");
                NESTS.put("javax.xml.transform.TransformerFactoryConfigurationError", "getException");
                NESTS.put("org.openide.compiler.CompilerGroupException", ".exception");
                NESTS.put("org.openide.src.SourceException$IO", "getReason");
                NESTS.put("org.openide.src.SourceException$Veto", "getReason");
                NESTS.put("org.openide.src.SourceVetoException", "getNestedException");
                NESTS.put("org.openide.util.MutexException", "getException");
                NESTS.put("org.openide.util.io.OperationException", "getException");
                NESTS.put("org.openide.util.io.SafeException", "getException");
                NESTS.put("org.xml.sax.SAXException", "getException");
            }
        }
        for (clazz = throwable.getClass(); clazz != (class$java$lang$Object == null ? NbErrorManager.class$("java.lang.Object") : class$java$lang$Object); clazz = clazz.getSuperclass()) {
            String string = (String)NESTS.get(clazz.getName());
            if (string == null) continue;
            try {
                if (string.charAt(0) == '.') {
                    Field field = clazz.getField(string.substring(1));
                    return (Throwable)field.get(throwable);
                }
                Method method = clazz.getMethod(string, null);
                return (Throwable)method.invoke((Object)throwable, null);
            }
            catch (Exception exception) {
                System.err.println("From throwable class: " + clazz.getName());
                exception.printStackTrace();
            }
        }
        return null;
    }

    public synchronized ErrorManager.Annotation[] findAnnotations(Throwable throwable) {
        return this.findAnnotations0(throwable, false, new HashSet());
    }

    private synchronized ErrorManager.Annotation[] findAnnotations0(Throwable throwable, boolean bl, Set set) {
        String string;
        Object object;
        Object object2;
        ArrayList<Ann> arrayList = (ArrayList<Ann>)map.get(throwable);
        if (throwable instanceof MissingResourceException) {
            arrayList = arrayList == null ? new ArrayList<Ann>(1) : new ArrayList(arrayList);
            object2 = (MissingResourceException)throwable;
            object = object2.getClassName();
            if (object != null) {
                arrayList.add(new Ann(4096, NbBundle.getMessage((Class)NbErrorManager.class, (String)"EXC_MissingResourceException_class_name", (Object)object), null, null, null));
            }
            if ((string = object2.getKey()) != null) {
                arrayList.add(new Ann(4096, NbBundle.getMessage((Class)NbErrorManager.class, (String)"EXC_MissingResourceException_key", (Object)string), null, null, null));
            }
            if (arrayList.size() == 0) {
                arrayList = null;
            }
        } else {
            object2 = NbErrorManager.extractNestedThrowable(throwable);
            if (object2 != null) {
                arrayList = arrayList == null ? new ArrayList(1) : new ArrayList(arrayList);
                arrayList.add(new Ann(0, null, null, (Throwable)object2, null));
            }
        }
        if (throwable instanceof SAXParseException) {
            object2 = (SAXParseException)throwable;
            object = object2.getPublicId();
            string = object2.getSystemId();
            if (object != null || string != null) {
                int n = object2.getColumnNumber();
                int n2 = object2.getLineNumber();
                String string2 = n != -1 || n2 != -1 ? NbBundle.getMessage((Class)NbErrorManager.class, (String)"EXC_sax_parse_col_line", (Object[])new Object[]{String.valueOf(object), String.valueOf(string), new Integer(n), new Integer(n2)}) : NbBundle.getMessage((Class)NbErrorManager.class, (String)"EXC_sax_parse", (Object)String.valueOf(object), (Object)String.valueOf(string));
                arrayList = arrayList == null ? new ArrayList(1) : new ArrayList(arrayList);
                arrayList.add(new Ann(0, string2, null, null, null));
            }
        }
        if (bl && arrayList != null) {
            object2 = new ArrayList();
            object = arrayList.iterator();
            while (object.hasNext()) {
                string = (ErrorManager.Annotation)object.next();
                Throwable throwable2 = string.getStackTrace();
                if (throwable2 == null || set.contains(throwable2)) continue;
                set.add(throwable2);
                ErrorManager.Annotation[] annotationArray = this.findAnnotations0(throwable2, true, set);
                if (annotationArray == null || annotationArray.length <= 0) continue;
                object2.addAll(Arrays.asList(annotationArray));
            }
            arrayList.addAll((Collection<Ann>)object2);
        }
        if (arrayList == null) {
            object2 = null;
        } else {
            object2 = new ErrorManager.Annotation[arrayList.size()];
            arrayList.toArray((T[])object2);
        }
        return object2;
    }

    public String toString() {
        return super.toString() + "<" + this.prefix + "," + this.minLogSeverity + ">";
    }

    static {
        System.setProperty("sun.awt.exception.handler", "org.netbeans.core.NbErrorManager$AWTHandler");
        NESTS = null;
    }

    public static final class AWTHandler {
        public static void handle(Throwable throwable) {
            if (throwable.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            ErrorManager.getDefault().notify(131072, throwable);
        }
    }

    final class Exc {
        private Throwable t;
        private Date d;
        private ErrorManager.Annotation[] arr;
        private ErrorManager.Annotation[] arrAll;
        private int severity;

        Exc(Throwable throwable, int n, ErrorManager.Annotation[] annotationArray, ErrorManager.Annotation[] annotationArray2) {
            this.t = throwable;
            this.severity = n;
            this.arr = annotationArray == null ? new ErrorManager.Annotation[]{} : annotationArray;
            this.arrAll = annotationArray2 == null ? new ErrorManager.Annotation[]{} : annotationArray2;
        }

        String getMessage() {
            String string = this.t.getMessage();
            if (string != null) {
                return string;
            }
            return (String)this.find(1);
        }

        String getLocalizedMessage() {
            String string = this.t.getLocalizedMessage();
            if (string != null && !string.equals(this.t.getMessage())) {
                return string;
            }
            if (this.arrAll == null) {
                return (String)this.find(2);
            }
            for (int i = 0; i < this.arrAll.length; ++i) {
                String string2 = this.arrAll[i].getLocalizedMessage();
                if (string2 == null) continue;
                return string2;
            }
            return string;
        }

        boolean isLocalized() {
            String string = this.t.getLocalizedMessage();
            if (string != null && !string.equals(this.t.getMessage())) {
                return true;
            }
            if (this.arrAll == null) {
                return (String)this.find(2) != null;
            }
            for (int i = 0; i < this.arrAll.length; ++i) {
                String string2 = this.arrAll[i].getLocalizedMessage();
                if (string2 == null) continue;
                return true;
            }
            return false;
        }

        String getClassName() {
            return (String)this.find(3);
        }

        int getSeverity() {
            if (this.severity != 0) {
                return this.severity;
            }
            ErrorManager.Annotation[] annotationArray = this.arrAll != null ? this.arrAll : this.arr;
            for (int i = 0; i < annotationArray.length; ++i) {
                int n = annotationArray[i].getSeverity();
                if (n <= this.severity) continue;
                this.severity = n;
            }
            if (this.severity == 0) {
                this.severity = this.t instanceof Error ? 65536 : 4096;
            }
            return this.severity;
        }

        Date getDate() {
            if (this.d == null) {
                this.d = (Date)this.find(4);
            }
            return this.d;
        }

        void printStackTrace(PrintStream printStream) {
            this.printStackTrace(new PrintWriter(printStream, true));
        }

        void printStackTrace(PrintWriter printWriter) {
            this.printStackTrace(printWriter, new HashSet(10));
        }

        private void printStackTrace(PrintWriter printWriter, Set set) {
            Object object;
            Object object2;
            if (this.t != null && !set.add(this.t)) {
                NbErrorManager.this.log(16, "WARNING - ErrorManager detected cyclic exception nesting:");
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Throwable throwable = (Throwable)iterator.next();
                    NbErrorManager.this.log(16, "\t" + throwable);
                    ErrorManager.Annotation[] annotationArray = NbErrorManager.this.findAnnotations(throwable);
                    if (annotationArray == null) continue;
                    for (int i = 0; i < annotationArray.length; ++i) {
                        Throwable throwable2 = annotationArray[i].getStackTrace();
                        if (throwable2 == null) continue;
                        NbErrorManager.this.log(16, "\t=> " + throwable2);
                    }
                }
                NbErrorManager.this.log(16, "Be sure not to annotate an exception with itself, directly or indirectly.");
                return;
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == null) continue;
                object2 = this.arr[i].getStackTrace();
                String string = this.arr[i].getLocalizedMessage();
                if (string == null) {
                    string = this.arr[i].getMessage();
                }
                if (string == null || object2 != null) continue;
                printWriter.println("Annotation: " + string);
            }
            if (this.t instanceof VirtualMachineError) {
                this.t.printStackTrace(printWriter);
            } else {
                StackTraceElement[] stackTraceElementArray = this.t.getStackTrace();
                object2 = new Throwable().getStackTrace();
                int n = -1;
                for (int i = 1; i <= Math.min(stackTraceElementArray.length, ((StackTraceElement[])object2).length); ++i) {
                    if (stackTraceElementArray[stackTraceElementArray.length - i].equals(object2[((StackTraceElement[])object2).length - i])) continue;
                    n = stackTraceElementArray.length - i + 1;
                    break;
                }
                object = this.decompose(this.t);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (i == n) {
                        printWriter.print("[catch]");
                        if (object[i].charAt(0) == '\t') {
                            printWriter.print(' ');
                            object[i] = ((String)object[i]).substring(1);
                        }
                    }
                    printWriter.println(object[i]);
                }
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == null || (object2 = this.arr[i].getStackTrace()) == null) continue;
                ErrorManager.Annotation[] annotationArray = NbErrorManager.this.findAnnotations((Throwable)object2);
                object = new Exc((Throwable)object2, 0, annotationArray, null);
                printWriter.println("==>");
                super.printStackTrace(printWriter, set);
            }
        }

        private String[] decompose(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.toString(), "\n\r");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            return stringArray;
        }

        private Object find(int n) {
            return this.find(n, true);
        }

        private Object find(int n, boolean bl) {
            for (int i = 0; i < this.arr.length; ++i) {
                ErrorManager.Annotation annotation = this.arr[i];
                Object object = null;
                switch (n) {
                    case 1: {
                        object = annotation.getMessage();
                        break;
                    }
                    case 2: {
                        object = annotation.getLocalizedMessage();
                        break;
                    }
                    case 3: {
                        Throwable throwable = annotation.getStackTrace();
                        object = throwable == null ? null : throwable.getClass().getName();
                        break;
                    }
                    case 4: {
                        object = annotation.getDate();
                    }
                }
                if (object == null) continue;
                return object;
            }
            if (!bl) {
                return null;
            }
            switch (n) {
                case 1: {
                    return this.t.getMessage();
                }
                case 2: {
                    return this.t.getLocalizedMessage();
                }
                case 3: {
                    return this.t.getClass().getName();
                }
                case 4: {
                    return new Date();
                }
            }
            throw new IllegalArgumentException("Unknown " + new Integer(n));
        }
    }

    private static final class Ann
    implements ErrorManager.Annotation {
        private int severity;
        private String message;
        private String localizedMessage;
        private Throwable stackTrace;
        private Date date;

        public Ann(int n, String string, String string2, Throwable throwable, Date date) {
            this.severity = n;
            this.message = string;
            this.localizedMessage = string2;
            this.stackTrace = throwable;
            this.date = date;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocalizedMessage() {
            return this.localizedMessage;
        }

        public Throwable getStackTrace() {
            return this.stackTrace;
        }

        public Date getDate() {
            return this.date;
        }

        public int getSeverity() {
            return this.severity;
        }

        public String toString() {
            return "NbEM.Ann[severity=" + this.severity + ",message=" + this.message + ",localizedMessage=" + this.localizedMessage + ",stackTrace=" + this.stackTrace + ",date=" + this.date + "]";
        }
    }
}

