/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.xml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.Environment;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class FileEntityResolver
extends EntityCatalog
implements Environment.Provider {
    private static final String ENTITY_PREFIX = "/xml/entities";
    private static final String LOOKUP_PREFIX = "/xml/lookups";
    static final ErrorManager ERR = ErrorManager.getDefault().getInstance(FileEntityResolver.class.getName());
    static final boolean LOG = ERR.isLoggable(1);
    private static Method method;
    private static final StopSaxException STOP;

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        if (string == null) {
            return null;
        }
        String string3 = FileEntityResolver.convertPublicId(string);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(ENTITY_PREFIX);
        stringBuffer.append(string3);
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(stringBuffer.toString());
        if (fileObject != null) {
            InputSource inputSource = new InputSource(fileObject.getInputStream());
            try {
                Object object = fileObject.getAttribute("hint.originalPublicID");
                if (object instanceof String) {
                    inputSource.setPublicId((String)object);
                }
                URL uRL = fileObject.getURL();
                inputSource.setSystemId(uRL.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return inputSource;
        }
        return null;
    }

    public Lookup getEnvironment(DataObject dataObject) {
        if (dataObject instanceof XMLDataObject) {
            XMLDataObject xMLDataObject = (XMLDataObject)dataObject;
            String string = null;
            try {
                DocumentType documentType = xMLDataObject.getDocument().getDoctype();
                if (documentType != null) {
                    string = documentType.getPublicId();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return null;
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
                return null;
            }
            if (string == null) {
                return null;
            }
            string = FileEntityResolver.convertPublicId(string);
            return new Lkp(string, (DataObject)xMLDataObject);
        }
        if (dataObject instanceof InstanceDataObject) {
            return this.getEnvForIDO((InstanceDataObject)dataObject);
        }
        return null;
    }

    private Lookup getEnvForIDO(InstanceDataObject instanceDataObject) {
        DTDParser dTDParser = new DTDParser(instanceDataObject.getPrimaryFile());
        dTDParser.parse();
        String string = dTDParser.getPublicId();
        if (string == null) {
            return null;
        }
        string = FileEntityResolver.convertPublicId(string);
        return new Lkp(string, (DataObject)instanceDataObject);
    }

    private static Lookup findLookup(DataObject dataObject, DataObject dataObject2) {
        if (dataObject2 == null) {
            return null;
        }
        try {
            InstanceCookie instanceCookie = (InstanceCookie)dataObject2.getCookie(InstanceCookie.class);
            if (instanceCookie != null) {
                Object object = instanceCookie.instanceCreate();
                if (object instanceof Environment.Provider) {
                    return ((Environment.Provider)object).getEnvironment(dataObject);
                }
                if (!(dataObject instanceof XMLDataObject)) {
                    return null;
                }
                if (object instanceof XMLDataObject.Processor) {
                    XMLDataObject.Info info = new XMLDataObject.Info();
                    info.addProcessorClass(object.getClass());
                    object = info;
                }
                if (object instanceof XMLDataObject.Info) {
                    return FileEntityResolver.createInfoLookup((XMLDataObject)dataObject, (XMLDataObject.Info)object);
                }
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lookup createInfoLookup(XMLDataObject xMLDataObject, XMLDataObject.Info info) {
        Class clazz = FileEntityResolver.class;
        synchronized (clazz) {
            if (method == null) {
                try {
                    Method method = XMLDataObject.class.getDeclaredMethod("createInfoLookup", XMLDataObject.class, XMLDataObject.Info.class);
                    method.setAccessible(true);
                    FileEntityResolver.method = method;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                    return null;
                }
            }
        }
        try {
            return (Lookup)method.invoke(null, xMLDataObject, info);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String convertPublicId(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            block9: {
                int n5 = cArray[n4];
                switch (n2) {
                    case 0: {
                        if (n5 == 43 || n5 == 45 || n5 == 73 || n5 == 83 || n5 == 79) break block9;
                        n2 = 1;
                    }
                    case 1: {
                        if (n5 != 47) break;
                        n2 = 2;
                        if (++n == 3) {
                            return new String(cArray, 0, n3);
                        }
                        cArray[n3++] = 47;
                    }
                    {
                        break block9;
                    }
                    case 2: {
                        if (n5 == 47) break block9;
                        n2 = 1;
                    }
                }
                cArray[n3++] = n5 >= 65 && n5 <= 90 || n5 >= 97 && n5 <= 122 || n5 >= 48 && n5 <= 57 ? n5 : 95;
            }
            ++n4;
        }
        return new String(cArray, 0, n3);
    }

    private static FileObject findObject(String string, FileObject[] fileObjectArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(LOOKUP_PREFIX);
        stringBuffer.append(string);
        int n = stringBuffer.length();
        stringBuffer.append(".instance");
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        String string2 = stringBuffer.toString();
        int n2 = FileEntityResolver.searchFolder(fileObject, string2, fileObjectArray);
        if (n2 == -1) {
            return null;
        }
        FileObject fileObject2 = fileObjectArray[0].getFileObject(string2.substring(n2));
        if (fileObject2 == null) {
            stringBuffer.setLength(n);
            stringBuffer.append(".xml");
            fileObject2 = fileObjectArray[0].getFileObject(stringBuffer.toString().substring(n2));
        }
        return fileObject2;
    }

    private static int searchFolder(FileObject fileObject, String string, FileObject[] fileObjectArray) {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(47, n)) == -1) {
                fileObjectArray[0] = fileObject;
                return n;
            }
            if (n2 == n) {
                ++n;
                continue;
            }
            FileObject fileObject2 = fileObject.getFileObject(string.substring(n, n2));
            if (fileObject2 == null) {
                fileObjectArray[0] = fileObject;
                return -1;
            }
            n = n2 + 1;
            fileObject = fileObject2;
        }
    }

    static {
        STOP = new StopSaxException();
    }

    private static final class Lkp
    extends ProxyLookup
    implements PropertyChangeListener,
    FileChangeListener {
        private String id;
        private DataObject xml;
        private volatile FileObject folder;
        private volatile DataObject obj;

        public Lkp(String string, DataObject dataObject) {
            super(new Lookup[0]);
            this.id = string;
            this.xml = dataObject;
        }

        protected void beforeLookup(Lookup.Template template) {
            if (LOG) {
                ERR.log("beforeLookup: " + template.getType() + " for " + this.xml);
            }
            if (this.folder == null && this.obj == null) {
                this.update();
            }
        }

        private void update() {
            if (LOG) {
                ERR.log("update: " + this.id + " for " + this.xml);
            }
            FileObject[] fileObjectArray = new FileObject[1];
            FileObject fileObject = FileEntityResolver.findObject(this.id, fileObjectArray);
            if (LOG) {
                ERR.log("fo: " + fileObject + " for " + this.xml);
            }
            DataObject dataObject = null;
            if (fileObject != null) {
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                    if (LOG) {
                        ERR.log("object found: " + dataObject + " for " + this.xml);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ERR.notify((Throwable)dataObjectNotFoundException);
                }
            }
            if (dataObject == this.obj) {
                if (LOG) {
                    ERR.log("same data object for " + this.xml);
                }
                Lookup lookup = FileEntityResolver.findLookup(this.xml, dataObject);
                if (dataObject != null && lookup != null) {
                    if (LOG) {
                        ERR.log("updating lookups for " + this.xml);
                    }
                    this.setLookups(new Lookup[]{lookup});
                    if (LOG) {
                        ERR.log("updating lookups done for " + this.xml);
                    }
                    return;
                }
            } else {
                Lookup lookup = FileEntityResolver.findLookup(this.xml, dataObject);
                if (dataObject != null && lookup != null) {
                    if (LOG) {
                        ERR.log("change the lookup");
                    }
                    dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataObject));
                    this.setLookups(new Lookup[]{lookup});
                    if (LOG) {
                        ERR.log("change in lookup done for " + this.xml);
                    }
                    this.obj = dataObject;
                    if (LOG) {
                        ERR.log("data object updated to " + this.obj + " for " + this.xml);
                    }
                    return;
                }
                this.obj = dataObject;
                if (LOG) {
                    ERR.log("data object updated to " + this.obj + " for " + this.xml);
                }
            }
            if (LOG) {
                ERR.log("delegating to nobody for " + this.obj + " for " + this.xml);
            }
            this.setLookups(new Lookup[0]);
            if (this.folder != fileObjectArray[0]) {
                this.folder = fileObjectArray[0];
                fileObjectArray[0].addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObjectArray[0]));
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.update();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.update();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.update();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("cookie" == string || "name" == string || "valid" == string || "primaryFile" == string) {
                this.update();
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.update();
        }

        public void fileChanged(FileEvent fileEvent) {
        }
    }

    private static class DTDParser
    extends DefaultHandler
    implements LexicalHandler {
        private String publicId = null;
        private FileObject src;

        public DTDParser(FileObject fileObject) {
            this.src = fileObject;
        }

        public String getPublicId() {
            return this.publicId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void parse() {
            block22: {
                InputStream inputStream = null;
                XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)false);
                xMLReader.setContentHandler(this);
                xMLReader.setEntityResolver(this);
                inputStream = this.src.getInputStream();
                InputSource inputSource = new InputSource(inputStream);
                try {
                    xMLReader.setFeature("http://xml.org/sax/features/validation", false);
                }
                catch (SAXException sAXException) {
                    ErrorManager.getDefault().log(1, "Warning: XML parser does not support validation feature.");
                }
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException sAXException) {
                    ErrorManager.getDefault().log(4096, "Warning: XML parser does not support lexical-handler feature.");
                }
                xMLReader.parse(inputSource);
                Object var6_9 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block22;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                break block22;
                {
                    catch (StopSaxException stopSaxException) {
                        Object var6_10 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block22;
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                        break block22;
                    }
                    catch (Exception exception) {
                        if (exception.getClass().getName().equals("org.openide.util.lookup.AbstractLookup$ISE")) {
                            throw (IllegalStateException)exception;
                        }
                        try {
                            if (this.src.getFileSystem() == Repository.getDefault().getDefaultFileSystem()) {
                                ErrorManager.getDefault().notify(1, (Throwable)exception);
                            }
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                        }
                        Object var6_11 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block22;
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    throw throwable;
                }
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = new InputSource(new StringReader(""));
            inputSource.setSystemId("StringReader");
            return inputSource;
        }

        public void endDTD() throws SAXException {
            throw STOP;
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.publicId = string2;
        }

        public void startEntity(String string) throws SAXException {
        }

        public void endEntity(String string) throws SAXException {
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }
    }

    private static class StopSaxException
    extends SAXException {
        public StopSaxException() {
            super("STOP");
        }
    }
}

