/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.daemon;

import org.apache.directory.daemon.Bootstrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsvcBootstrapper
extends Bootstrapper {
    private static final Logger log = LoggerFactory.getLogger((Class)JsvcBootstrapper.class);
    private boolean isListenerShuttingDown = false;
    private boolean isDaemonShuttingDown = false;
    private Thread thread;

    public void init(String[] args) {
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("init(String[]) called with args: \n");
            for (int ii = 0; ii < args.length; ++ii) {
                buf.append("\t").append(args[ii]).append("\n");
            }
            log.debug(buf.toString());
        }
        this.setInstallationLayout(args[0]);
        this.setParentLoader(Thread.currentThread().getContextClassLoader());
        this.callInit(JsvcBootstrapper.shift(args, 1));
        this.thread = new Thread((Runnable)new ShutdownListener(), "ShutdownListenerThread");
    }

    public void start() {
        log.debug("start() called");
        this.callStart();
        this.thread.start();
    }

    public void stop() throws Exception {
        log.debug("stop() called using regular shutdown with signals");
        if (!this.isListenerShuttingDown) {
            this.isDaemonShuttingDown = true;
            this.callStop(EMPTY_STRARRAY);
        }
    }

    public void destroy() {
        log.debug("destroy() called");
        this.callDestroy();
    }

    class ShutdownListener
    implements Runnable {
        ShutdownListener() {
        }

        public void run() {
            JsvcBootstrapper.this.waitForShutdown();
            log.debug("ShutdownListener came out of waitForShutdown");
            if (!JsvcBootstrapper.this.isDaemonShuttingDown) {
                JsvcBootstrapper.this.isListenerShuttingDown = true;
                log.debug("ShutdownListener will invoke callStop(String[]).");
                JsvcBootstrapper.this.callStop(Bootstrapper.EMPTY_STRARRAY);
                log.debug("ShutdownListener will invoke callDestroy().");
                JsvcBootstrapper.this.callDestroy();
                log.debug("ShutdownListener will exit the system.");
                System.exit(0);
            }
        }
    }
}

