/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public abstract class DialogDisplayer {
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    protected DialogDisplayer() {
    }

    public static DialogDisplayer getDefault() {
        DialogDisplayer dialogDisplayer = (DialogDisplayer)Lookup.getDefault().lookup(DialogDisplayer.class);
        if (dialogDisplayer == null) {
            dialogDisplayer = new Trivial();
        }
        return dialogDisplayer;
    }

    public abstract Object notify(NotifyDescriptor var1);

    public abstract Dialog createDialog(DialogDescriptor var1);

    private static final class Trivial
    extends DialogDisplayer {
        private Trivial() {
        }

        public Object notify(NotifyDescriptor notifyDescriptor) {
            StandardDialog standardDialog = new StandardDialog(notifyDescriptor.getTitle(), true, notifyDescriptor, null, null);
            standardDialog.show();
            return notifyDescriptor.getValue() != null ? notifyDescriptor.getValue() : NotifyDescriptor.CLOSED_OPTION;
        }

        public Dialog createDialog(final DialogDescriptor dialogDescriptor) {
            final StandardDialog standardDialog = new StandardDialog(dialogDescriptor.getTitle(), dialogDescriptor.isModal(), dialogDescriptor, dialogDescriptor.getClosingOptions(), dialogDescriptor.getButtonListener());
            dialogDescriptor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("title".equals(string)) {
                        standardDialog.setTitle(dialogDescriptor.getTitle());
                    } else if ("message".equals(string)) {
                        standardDialog.updateMessage();
                        standardDialog.validate();
                        standardDialog.repaint();
                    } else if ("options".equals(string) || "optionType".equals(string)) {
                        standardDialog.updateOptions();
                        standardDialog.validate();
                        standardDialog.repaint();
                    }
                }
            });
            return standardDialog;
        }

        private static Component message2Component(Object object) {
            if (object instanceof Component) {
                return (Component)object;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                for (int i = 0; i < objectArray.length; ++i) {
                    jPanel.add(Trivial.message2Component(objectArray[i]));
                }
                return jPanel;
            }
            if (object instanceof Icon) {
                return new JLabel((Icon)object);
            }
            String string = object.toString();
            JTextArea jTextArea = new JTextArea(string);
            Color color = UIManager.getColor("Label.background");
            if (color != null) {
                jTextArea.setBackground(color);
            }
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setTabSize(4);
            jTextArea.setColumns(40);
            if (string.indexOf(10) != -1) {
                return new JScrollPane(jTextArea);
            }
            return jTextArea;
        }

        private static Component option2Button(Object object, NotifyDescriptor notifyDescriptor, ActionListener actionListener, JRootPane jRootPane) {
            boolean bl;
            String string;
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                abstractButton.addActionListener(actionListener);
                return abstractButton;
            }
            if (object instanceof Component) {
                return (Component)object;
            }
            if (object instanceof Icon) {
                return new JLabel((Icon)object);
            }
            if (object == NotifyDescriptor.OK_OPTION) {
                string = "OK";
                bl = true;
            } else if (object == NotifyDescriptor.CANCEL_OPTION) {
                string = "Cancel";
                bl = false;
            } else if (object == NotifyDescriptor.YES_OPTION) {
                string = "Yes";
                bl = true;
            } else if (object == NotifyDescriptor.NO_OPTION) {
                string = "No";
                bl = false;
            } else {
                if (object == NotifyDescriptor.CLOSED_OPTION) {
                    throw new IllegalArgumentException();
                }
                string = object.toString();
                bl = false;
            }
            JButton jButton = new JButton(string);
            if (bl && jRootPane.getDefaultButton() == null) {
                jRootPane.setDefaultButton(jButton);
            }
            jButton.getAccessibleContext().setAccessibleName(string);
            jButton.addActionListener(actionListener);
            return jButton;
        }

        private static final class StandardDialog
        extends JDialog {
            private final NotifyDescriptor nd;
            private Component messageComponent;
            private final JPanel buttonPanel;
            private final Object[] closingOptions;
            private final ActionListener buttonListener;
            private boolean haveFinalValue = false;

            public StandardDialog(String string, boolean bl, NotifyDescriptor notifyDescriptor, Object[] objectArray, ActionListener actionListener) {
                super((Frame)null, string, bl);
                this.nd = notifyDescriptor;
                this.closingOptions = objectArray;
                this.buttonListener = actionListener;
                this.getContentPane().setLayout(new BorderLayout());
                this.setDefaultCloseOperation(2);
                this.updateMessage();
                this.buttonPanel = new JPanel();
                this.buttonPanel.setLayout(new FlowLayout(2));
                this.updateOptions();
                this.getContentPane().add(this.buttonPanel, "South", 1);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
                String string2 = "cancel";
                this.getRootPane().getInputMap(1).put(keyStroke, string2);
                AbstractAction abstractAction = new AbstractAction(this){
                    private final /* synthetic */ StandardDialog this$0;
                    {
                        this.this$0 = standardDialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        StandardDialog.access$100(this.this$0);
                    }
                };
                this.getRootPane().getActionMap().put(string2, abstractAction);
                this.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ StandardDialog this$0;
                    {
                        this.this$0 = standardDialog;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        if (!StandardDialog.access$200(this.this$0)) {
                            StandardDialog.access$300(this.this$0).setValue(NotifyDescriptor.CLOSED_OPTION);
                        }
                    }
                });
                this.pack();
                Rectangle rectangle = Utilities.getUsableScreenBounds();
                int n = rectangle.width * 9 / 10;
                int n2 = rectangle.height * 9 / 10;
                Dimension dimension = this.getPreferredSize();
                dimension.width = Math.min(dimension.width, n);
                dimension.height = Math.min(dimension.height, n2);
                this.setBounds(Utilities.findCenterBounds((Dimension)dimension));
            }

            private void cancel() {
                this.nd.setValue(NotifyDescriptor.CANCEL_OPTION);
                this.haveFinalValue = true;
                this.dispose();
            }

            public void updateMessage() {
                if (this.messageComponent != null) {
                    this.getContentPane().remove(this.messageComponent);
                }
                this.messageComponent = Trivial.message2Component(this.nd.getMessage());
                this.getContentPane().add(this.messageComponent, "Center");
            }

            public void updateOptions() {
                int n;
                HashSet<Object> hashSet = new HashSet<Object>(5);
                Object[] objectArray = this.nd.getOptions();
                if (objectArray == null) {
                    switch (this.nd.getOptionType()) {
                        case -1: 
                        case 2: {
                            objectArray = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
                            break;
                        }
                        case 0: {
                            objectArray = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION};
                            break;
                        }
                        case 1: {
                            objectArray = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, NotifyDescriptor.CANCEL_OPTION};
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                this.buttonPanel.removeAll();
                JRootPane jRootPane = this.getRootPane();
                for (n = 0; n < objectArray.length; ++n) {
                    hashSet.add(objectArray[n]);
                    this.buttonPanel.add(Trivial.option2Button(objectArray[n], this.nd, this.makeListener(objectArray[n]), jRootPane));
                }
                objectArray = this.nd.getAdditionalOptions();
                if (objectArray != null) {
                    for (n = 0; n < objectArray.length; ++n) {
                        hashSet.add(objectArray[n]);
                        this.buttonPanel.add(Trivial.option2Button(objectArray[n], this.nd, this.makeListener(objectArray[n]), jRootPane));
                    }
                }
                if (this.closingOptions != null) {
                    for (n = 0; n < this.closingOptions.length; ++n) {
                        if (!hashSet.add(this.closingOptions[n])) continue;
                        ActionListener actionListener = this.makeListener(this.closingOptions[n]);
                        this.attachActionListener(this.closingOptions[n], actionListener);
                    }
                }
            }

            private void attachActionListener(Object object, ActionListener actionListener) {
                if (object instanceof JButton) {
                    JButton jButton = (JButton)object;
                    jButton.addActionListener(actionListener);
                    return;
                }
                Method method = null;
                try {
                    method = object.getClass().getMethod("addActionListener", class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = DialogDisplayer.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = null;
                }
                catch (SecurityException securityException) {
                    method = null;
                }
                if (method != null) {
                    try {
                        method.invoke(object, actionListener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            private ActionListener makeListener(Object object) {
                return new ActionListener(this, object){
                    private final /* synthetic */ Object val$option;
                    private final /* synthetic */ StandardDialog this$0;
                    {
                        this.this$0 = standardDialog;
                        this.val$option = object;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        StandardDialog.access$300(this.this$0).setValue(this.val$option);
                        if (StandardDialog.access$600(this.this$0) != null) {
                            ActionEvent actionEvent2 = new ActionEvent(this.val$option, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
                            StandardDialog.access$600(this.this$0).actionPerformed(actionEvent2);
                        }
                        if (StandardDialog.access$700(this.this$0) == null || Arrays.asList(StandardDialog.access$700(this.this$0)).contains(this.val$option)) {
                            StandardDialog.access$202(this.this$0, true);
                            this.this$0.setVisible(false);
                        }
                    }
                };
            }

            static /* synthetic */ void access$100(StandardDialog standardDialog) {
                standardDialog.cancel();
            }

            static /* synthetic */ boolean access$200(StandardDialog standardDialog) {
                return standardDialog.haveFinalValue;
            }

            static /* synthetic */ NotifyDescriptor access$300(StandardDialog standardDialog) {
                return standardDialog.nd;
            }

            static /* synthetic */ ActionListener access$600(StandardDialog standardDialog) {
                return standardDialog.buttonListener;
            }

            static /* synthetic */ Object[] access$700(StandardDialog standardDialog) {
                return standardDialog.closingOptions;
            }

            static /* synthetic */ boolean access$202(StandardDialog standardDialog, boolean bl) {
                standardDialog.haveFinalValue = bl;
                return standardDialog.haveFinalValue;
            }
        }
    }
}

