/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

final class BrokenDataShadow
extends MultiDataObject {
    private URL url;
    private static Map allDataShadows;
    private static final long serialVersionUID = -3046981691235483810L;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$java$lang$String;

    public BrokenDataShadow(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        try {
            this.url = DataShadow.readURL(fileObject);
        }
        catch (IOException iOException) {
            try {
                this.url = new URL("file", null, "/UNKNOWN");
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify(4096, (Throwable)malformedURLException);
            }
        }
        BrokenDataShadow.enqueueBrokenDataShadow(this);
    }

    static synchronized Map getDataShadowsSet() {
        if (allDataShadows == null) {
            allDataShadows = new HashMap();
        }
        return allDataShadows;
    }

    private static synchronized void enqueueBrokenDataShadow(BrokenDataShadow brokenDataShadow) {
        Map map = BrokenDataShadow.getDataShadowsSet();
        String string = brokenDataShadow.getUrl().toExternalForm();
        DataShadow.DSWeakReference dSWeakReference = new DataShadow.DSWeakReference(brokenDataShadow);
        Set<DataShadow.DSWeakReference> set = (Set<DataShadow.DSWeakReference>)map.get(string);
        if (set == null) {
            set = Collections.singleton(dSWeakReference);
            BrokenDataShadow.getDataShadowsSet().put(string, set);
        } else {
            if (!(set instanceof HashSet)) {
                set = new HashSet<DataShadow.DSWeakReference>(set);
                BrokenDataShadow.getDataShadowsSet().put(string, set);
            }
            set.add(dSWeakReference);
        }
    }

    private static synchronized List getAllDataShadows() {
        if (allDataShadows == null || allDataShadows.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(allDataShadows.size());
        Iterator iterator = allDataShadows.values().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Reference reference = (Reference)iterator2.next();
                Object t = reference.get();
                if (t == null) continue;
                arrayList.add(t);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkValidity(EventObject eventObject) {
        DataObject dataObject = null;
        if (eventObject instanceof OperationEvent) {
            dataObject = ((OperationEvent)eventObject).getObject();
        }
        FileObject fileObject = null;
        if (dataObject != null) {
            fileObject = dataObject.getPrimaryFile();
        } else if (eventObject instanceof FileEvent) {
            fileObject = ((FileEvent)eventObject).getFile();
        }
        try {
            if (!fileObject.getFileSystem().equals(Repository.getDefault().getDefaultFileSystem())) {
                return;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().log(16, fileStateInvalidException.toString());
            return;
        }
        Object object = BrokenDataShadow.class;
        synchronized (object) {
            if (allDataShadows == null || allDataShadows.isEmpty()) {
                return;
            }
        }
        try {
            object = fileObject.getURL().toExternalForm();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return;
        }
        Set set = null;
        Object object2 = BrokenDataShadow.class;
        synchronized (object2) {
            if (allDataShadows == null || allDataShadows.isEmpty()) {
                return;
            }
            if (dataObject != null && (set = (Set)allDataShadows.get(object)) == null) {
                return;
            }
        }
        object2 = BrokenDataShadow.getAllDataShadows();
        if (object2 == null) {
            return;
        }
        int n = object2.size();
        for (int i = 0; i < n; ++i) {
            Object e = object2.get(i);
            ((BrokenDataShadow)e).refresh();
        }
    }

    private BrokenDataShadow(FileObject fileObject) throws DataObjectExistsException {
        this(fileObject, DataLoaderPool.getShadowLoader());
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public void refresh() {
        try {
            if (URLMapper.findFileObject((URL)this.getUrl()) != null) {
                this.setValid(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        return new BrokenShadowNode(this);
    }

    URL getUrl() {
        return this.url;
    }

    private static final class BrokenShadowNode
    extends DataNode {
        private static MessageFormat format;
        private Sheet sheet;
        private static final String ICON_NAME = "org/openide/loaders/brokenShadow";

        public BrokenShadowNode(BrokenDataShadow brokenDataShadow) {
            super(brokenDataShadow, Children.LEAF);
            this.setIconBase(ICON_NAME);
        }

        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(DataObject.getString("FMT_brokenShadowName"));
            }
            return format.format(this.createArguments());
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = BrokenDataShadow.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = BrokenDataShadow.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BrokenDataShadow.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BrokenDataShadow.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BrokenDataShadow.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BrokenDataShadow.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.sheet == null) {
                this.sheet = this.cloneSheet();
            }
            return this.sheet.toArray();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] propertySetArray = super.getPropertySets();
            Sheet sheet = new Sheet();
            for (int i = 0; i < propertySetArray.length; ++i) {
                Sheet.Set set = new Sheet.Set();
                set.put(propertySetArray[i].getProperties());
                set.setName(propertySetArray[i].getName());
                set.setDisplayName(propertySetArray[i].getDisplayName());
                set.setShortDescription(propertySetArray[i].getShortDescription());
                this.modifySheetSet(set);
                sheet.put(set);
            }
            return sheet;
        }

        private void modifySheetSet(Sheet.Set set) {
            Object object = set.remove("name");
            if (object != null) {
                object = new PropertySupport.Name((Node)this);
                set.put(object);
                object = new Name();
                set.put(object);
            }
        }

        private Object[] createArguments() {
            return new Object[]{this.getDataObject().getName()};
        }

        private final class Name
        extends PropertySupport.ReadWrite {
            public Name() {
                super("BrokenLink", class$java$lang$String == null ? (class$java$lang$String = BrokenDataShadow.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_brokenShadowOriginalName"), DataObject.getString("HINT_brokenShadowOriginalName"));
            }

            public Object getValue() {
                BrokenDataShadow brokenDataShadow = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return brokenDataShadow.getUrl().toExternalForm();
            }

            public void setValue(Object object) {
                String string = (String)object;
                BrokenDataShadow brokenDataShadow = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                try {
                    URL uRL = new URL(string);
                    DataShadow.writeOriginal(brokenDataShadow.getPrimaryFile(), uRL);
                    brokenDataShadow.url = uRL;
                }
                catch (IOException iOException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, (Throwable)iOException);
                    throw illegalArgumentException;
                }
                brokenDataShadow.refresh();
            }
        }
    }
}

