/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderList;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class FolderChildren
extends Children.Keys
implements PropertyChangeListener,
ChangeListener {
    private DataFolder folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private ErrorManager err;
    private boolean refresh;
    private RequestProcessor.Task refreshTask;
    private ChildrenRefreshRunnable refreshRunnable;
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_Refresh");
    static /* synthetic */ Class class$org$openide$loaders$FolderChildren;

    public FolderChildren(DataFolder dataFolder) {
        this(dataFolder, DataFilter.ALL);
    }

    public FolderChildren(DataFolder dataFolder, DataFilter dataFilter) {
        this.folder = dataFolder;
        this.filter = dataFilter;
        this.refreshRunnable = new ChildrenRefreshRunnable();
        this.refreshTask = refRP.create((Runnable)this.refreshRunnable);
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.err = ErrorManager.getDefault().getInstance("org.openide.loaders.FolderChildren." + dataFolder.getPrimaryFile().getPath().replace('/', '.'));
        if (!this.err.isLoggable(1)) {
            this.err = null;
        }
    }

    DataFilter getFilter() {
        return this.filter;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("children".equals(propertyChangeEvent.getPropertyName())) {
            if (this.err != null) {
                this.err.log("Got PROP_CHILDREN");
            }
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
        if ("sortMode".equals(propertyChangeEvent.getPropertyName()) || "order".equals(propertyChangeEvent.getPropertyName())) {
            if (this.err != null) {
                this.err.log("Got PROP_SORT_MODE or PROP_ORDER");
            }
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh = true;
        this.refreshChildren().schedule(0);
        this.postClearTask();
    }

    private void postClearTask() {
        refRP.post(new Runnable(){

            public void run() {
                FolderChildren.this.refreshRunnable.clear();
            }
        });
    }

    RequestProcessor.Task refreshChildren() {
        return this.refreshTask;
    }

    protected Node[] createNodes(Object object) {
        if (this.err != null) {
            this.err.log("createNodes: " + object);
        }
        FileObject fileObject = ((Pair)object).primaryFile;
        try {
            DataObject dataObject = DataObject.find(fileObject);
            if (this.filter == null || this.filter.acceptDataObject(dataObject)) {
                return new Node[]{dataObject.getClonedNodeDelegate(this.filter)};
            }
            return new Node[0];
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            return new Node[0];
        }
    }

    public Node[] getNodes(boolean bl) {
        Node[] nodeArray;
        if (bl) {
            if (FolderChildren.checkChildrenMutex()) {
                FolderList.find(this.folder.getPrimaryFile(), true).waitProcessingFinished();
                RequestProcessor.Task task = this.refreshChildren();
                nodeArray = this.getNodes();
                task.schedule(0);
                task.waitFinished();
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
            }
        }
        nodeArray = this.getNodes();
        this.postClearTask();
        return nodeArray;
    }

    public Node findChild(String string) {
        if (FolderChildren.checkChildrenMutex()) {
            this.getNodes(true);
        }
        return super.findChild(string);
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        if (this.err != null) {
            this.err.log("addNotify begin");
        }
        this.folder.addPropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).addChangeListener(this);
        }
        this.refreshChildren().schedule(0);
        if (this.err != null) {
            this.err.log("addNotify end");
        }
    }

    protected void removeNotify() {
        if (this.err != null) {
            this.err.log("removeNotify begin");
        }
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this);
        }
        this.setKeys(Collections.EMPTY_LIST);
        if (this.err != null) {
            this.err.log("removeNotify end");
        }
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    private static final class Pair {
        public FileObject primaryFile;
        public int seq;

        public Pair(FileObject fileObject) {
            this.primaryFile = fileObject;
            this.seq = DataObjectPool.getPOOL().registrationCount(fileObject);
        }

        public int hashCode() {
            return this.primaryFile.hashCode() ^ this.seq;
        }

        public boolean equals(Object object) {
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                return this.primaryFile.equals(pair.primaryFile) && this.seq == pair.seq;
            }
            return false;
        }

        public String toString() {
            return "FolderChildren.Pair[" + this.primaryFile + "," + this.seq + "]";
        }
    }

    private final class ChildrenRefreshRunnable
    implements Runnable {
        private DataObject[] ch;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ChildrenRefreshRunnable() {
        }

        public void run() {
            int n;
            if (!$assertionsDisabled && !refRP.isRequestProcessorThread()) {
                throw new AssertionError();
            }
            FolderList.find(FolderChildren.this.folder.getPrimaryFile(), true).waitProcessingFinished();
            this.ch = FolderChildren.this.folder.getChildren();
            if (FolderChildren.this.err != null) {
                FolderChildren.this.err.log("Children computed");
            }
            Object[] objectArray = new Object[this.ch.length];
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = new Pair(this.ch[n].getPrimaryFile());
            }
            FolderChildren.this.setKeys(Arrays.asList(objectArray));
            if (FolderChildren.this.refresh) {
                FolderChildren.this.refresh = false;
                for (n = 0; n < objectArray.length; ++n) {
                    FolderChildren.this.refreshKey(objectArray[n]);
                }
            }
            if (!FolderChildren.this.isInitialized()) {
                this.clear();
            }
        }

        public void clear() {
            if (!$assertionsDisabled && !refRP.isRequestProcessorThread()) {
                throw new AssertionError();
            }
            if (FolderChildren.this.err != null) {
                FolderChildren.this.err.log("Clearing the reference to children");
            }
            this.ch = null;
        }

        static {
            $assertionsDisabled = !(class$org$openide$loaders$FolderChildren == null ? (class$org$openide$loaders$FolderChildren = FolderChildren.class$("org.openide.loaders.FolderChildren")) : class$org$openide$loaders$FolderChildren).desiredAssertionStatus();
        }
    }
}

