/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.NewObjectWizardPanel;
import org.openide.loaders.TemplateWizardIterImpl;
import org.openide.loaders.TemplateWizardPanel1;
import org.openide.loaders.TemplateWizardPanel2;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class TemplateWizard
extends WizardDescriptor {
    private static final String EA_DESCRIPTION = "templateWizardURL";
    private static final String EA_ITERATOR = "templateWizardIterator";
    private static final String EA_DESC_RESOURCE = "templateWizardDescResource";
    private static final String CUSTOM_DESCRIPTION = "instantiatingWizardURL";
    private static final String CUSTOM_ITERATOR = "instantiatingIterator";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    static Dimension PREF_DIM = new Dimension(560, 350);
    private WizardDescriptor.Panel templateChooser;
    private WizardDescriptor.Panel targetChooser;
    private boolean showTargetChooser = true;
    private Iterator targetIterator;
    private TemplateWizardIterImpl iterator;
    private DataObject template;
    private DataFolder templatesFolder;
    private String targetName = null;
    private DataFolder targetDataFolder;
    private boolean titleFormatSet = false;
    private PropertyChangeListener pcl;
    private Component lastComp;
    private Set newObjects = null;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public TemplateWizard() {
        this(new TemplateWizardIterImpl());
    }

    private TemplateWizard(TemplateWizardIterImpl templateWizardIterImpl) {
        super((WizardDescriptor.Iterator)templateWizardIterImpl);
        this.iterator = templateWizardIterImpl;
        this.iterator.initialize(this);
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getMessage((Class)TemplateWizard.class, (String)"CTL_TemplateTitle"));
        this.setTitleFormat(new MessageFormat("{0}"));
    }

    protected TemplateWizard(Iterator iterator) {
        this();
        this.iterator.setIterator(iterator, false);
    }

    protected void initialize() {
        if (this.iterator != null) {
            this.iterator.initialize(this);
            this.newObjects = null;
        }
        super.initialize();
    }

    final void setTemplateImpl(DataObject dataObject, boolean bl) {
        DataObject dataObject2 = this.template;
        if (this.template != dataObject) {
            this.template = dataObject;
        }
        this.setTitle(this.getTitleFormat().format(new Object[]{dataObject.getNodeDelegate().getDisplayName()}));
        if (dataObject2 != this.template) {
            Iterator iterator;
            if (dataObject == null || (iterator = TemplateWizard.getIterator(dataObject)) == null) {
                iterator = this.defaultIterator();
            }
            this.iterator.setIterator(iterator, bl);
        }
    }

    public DataObject getTemplate() {
        return this.template;
    }

    public void setTemplate(DataObject dataObject) {
        if (dataObject != null) {
            this.setTemplateImpl(dataObject, true);
        }
    }

    public void setTemplatesFolder(DataFolder dataFolder) {
        this.templatesFolder = dataFolder;
    }

    public DataFolder getTemplatesFolder() {
        FileObject fileObject;
        DataFolder dataFolder = this.templatesFolder;
        if (dataFolder == null && (fileObject = Repository.getDefault().getDefaultFileSystem().findResource("/Templates")) != null && fileObject.isFolder()) {
            return DataFolder.findFolder(fileObject);
        }
        return dataFolder;
    }

    public DataFolder getTargetFolder() throws IOException {
        if (this.targetDataFolder == null) {
            throw new IOException(NbBundle.getMessage((Class)TemplateWizard.class, (String)"ERR_NoFilesystem"));
        }
        return this.targetDataFolder;
    }

    private void reload(DataObject dataObject) {
        Iterator iterator;
        if (dataObject == null || (iterator = TemplateWizard.getIterator(dataObject)) == null) {
            iterator = this.defaultIterator();
        }
        this.iterator.setIterator(iterator, true);
    }

    public void setTargetFolder(DataFolder dataFolder) {
        this.targetDataFolder = dataFolder;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String string) {
        this.targetName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardDescriptor.Panel templateChooser() {
        TemplateWizard templateWizard = this;
        synchronized (templateWizard) {
            if (this.templateChooser == null) {
                this.templateChooser = this.createTemplateChooser();
            }
        }
        return this.templateChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardDescriptor.Panel targetChooser() {
        TemplateWizard templateWizard = this;
        synchronized (templateWizard) {
            if (this.targetChooser == null) {
                this.targetChooser = this.createTargetChooser();
            }
        }
        return this.targetChooser;
    }

    final synchronized Iterator defaultIterator() {
        if (this.targetIterator == null) {
            this.targetIterator = this.createDefaultIterator();
        }
        return this.targetIterator;
    }

    protected WizardDescriptor.Panel createTemplateChooser() {
        return new TemplateWizardPanel1();
    }

    protected WizardDescriptor.Panel createTargetChooser() {
        return this.showTargetChooser ? new TemplateWizardPanel2() : new NewObjectWizardPanel();
    }

    protected Iterator createDefaultIterator() {
        return new DefaultIterator();
    }

    public Set instantiate() throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(null, null);
    }

    public Set instantiate(DataObject dataObject) throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(dataObject, null);
    }

    public Set instantiate(DataObject dataObject, DataFolder dataFolder) throws IOException {
        this.showTargetChooser = false;
        return this.instantiateImpl(dataObject, dataFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set instantiateNewObjects() throws IOException {
        try {
            Object object = this.getValue();
            if (object == FINISH_OPTION || object == YES_OPTION || object == OK_OPTION) {
                this.showWaitCursor();
                this.newObjects = this.handleInstantiate();
                if (this.lastComp != null) {
                    this.lastComp.removePropertyChangeListener(this.propL());
                    this.lastComp = null;
                }
            } else {
                if (this.lastComp != null) {
                    this.lastComp.removePropertyChangeListener(this.propL());
                    this.lastComp = null;
                }
                this.newObjects = null;
            }
        }
        finally {
            this.showNormalCursor();
        }
        return this.newObjects;
    }

    private Set instantiateImpl(DataObject dataObject, DataFolder dataFolder) throws IOException {
        this.showTargetChooser |= dataFolder == null;
        this.targetChooser = null;
        IllegalStateException illegalStateException = null;
        if (dataFolder != null) {
            this.setTargetFolder(dataFolder);
        }
        if (dataObject != null) {
            this.template = null;
            this.setTemplate(dataObject);
            if (this.iterator != null) {
                this.iterator.initialize(this);
            }
        } else if (this.iterator != null) {
            this.iterator.initialize(this);
            this.iterator.first();
        }
        try {
            this.updateState();
            this.setValue(null);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
            if (illegalStateException != null) {
                final IllegalStateException illegalStateException2 = illegalStateException;
                illegalStateException = null;
                dialog.addComponentListener(new ComponentAdapter(){

                    public void componentShown(ComponentEvent componentEvent) {
                        if (illegalStateException2.getMessage() != null) {
                            ErrorManager.getDefault().notify(256, illegalStateException2);
                        } else {
                            ErrorManager.getDefault().notify(illegalStateException2);
                        }
                        dialog.removeComponentListener(this);
                    }
                });
            }
            dialog.setVisible(true);
        }
        catch (IllegalStateException illegalStateException3) {
            illegalStateException = illegalStateException3;
        }
        return this.newObjects;
    }

    private void showWaitCursor() {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                try {
                    JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                    Component component = jFrame.getGlassPane();
                    component.setVisible(true);
                    component.setCursor(Cursor.getPredefinedCursor(3));
                }
                catch (NullPointerException nullPointerException) {
                    ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
                }
            }
        });
    }

    private void showNormalCursor() {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                try {
                    JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                    Component component = jFrame.getGlassPane();
                    component.setCursor(null);
                    component.setVisible(false);
                }
                catch (NullPointerException nullPointerException) {
                    ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
                }
            }
        });
    }

    public void setTitleFormat(MessageFormat messageFormat) {
        this.titleFormatSet = true;
        super.setTitleFormat(messageFormat);
    }

    public MessageFormat getTitleFormat() {
        if (!this.titleFormatSet) {
            this.setTitleFormat(new MessageFormat(NbBundle.getMessage((Class)TemplateWizard.class, (String)"CTL_TemplateTitle")));
        }
        return super.getTitleFormat();
    }

    protected Set handleInstantiate() throws IOException {
        return this.iterator.getIterator().instantiate(this);
    }

    public static void setDescription(DataObject dataObject, URL uRL) throws IOException {
        dataObject.getPrimaryFile().setAttribute(EA_DESCRIPTION, (Object)uRL);
        dataObject.getPrimaryFile().setAttribute(CUSTOM_DESCRIPTION, (Object)uRL);
    }

    public static URL getDescription(DataObject dataObject) {
        URL uRL = (URL)dataObject.getPrimaryFile().getAttribute(CUSTOM_DESCRIPTION);
        if (uRL != null) {
            return uRL;
        }
        uRL = (URL)dataObject.getPrimaryFile().getAttribute(EA_DESCRIPTION);
        if (uRL != null) {
            return uRL;
        }
        String string = (String)dataObject.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
        if (string != null) {
            try {
                URL uRL2 = new URL("nbresloc:/" + string);
                try {
                    TemplateWizard.setDescription(dataObject, uRL2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        }
        return null;
    }

    public static void setDescriptionAsResource(DataObject dataObject, String string) throws IOException {
        if (string != null && string.startsWith("/")) {
            ErrorManager.getDefault().log(16, "Warning: auto-stripping leading slash from resource path in TemplateWizard.setDescriptionAsResource: " + string);
            string = string.substring(1);
        }
        dataObject.getPrimaryFile().setAttribute(EA_DESC_RESOURCE, (Object)string);
    }

    public static String getDescriptionAsResource(DataObject dataObject) {
        return (String)dataObject.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
    }

    public static void setIterator(DataObject dataObject, Iterator iterator) throws IOException {
        dataObject.getPrimaryFile().setAttribute(CUSTOM_ITERATOR, (Object)iterator);
        dataObject.getPrimaryFile().setAttribute(EA_ITERATOR, (Object)iterator);
    }

    public static Iterator getIterator(DataObject dataObject) {
        Object object = dataObject.getPrimaryFile().getAttribute(CUSTOM_ITERATOR);
        if (object == null) {
            object = dataObject.getPrimaryFile().getAttribute(EA_ITERATOR);
        }
        Iterator iterator = null;
        if (object instanceof Iterator) {
            iterator = (Iterator)object;
        }
        if (object instanceof WizardDescriptor.InstantiatingIterator) {
            iterator = new InstantiatingIteratorBridge((WizardDescriptor.InstantiatingIterator)object);
        }
        if (iterator != null) {
            return iterator;
        }
        return (Iterator)dataObject.getCookie(Iterator.class);
    }

    static boolean checkCaseInsensitiveName(FileObject fileObject, String string, String string2) {
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(fileObject2.getExt()) || !string.equalsIgnoreCase(fileObject2.getName())) continue;
            return true;
        }
        return false;
    }

    protected void updateState() {
        super.updateState();
        if (this.lastComp != null) {
            this.lastComp.removePropertyChangeListener(this.propL());
        }
        this.lastComp = this.iterator.current().getComponent();
        this.lastComp.addPropertyChangeListener(this.propL());
        this.putProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(this.getContentSelectedIndex()));
        if (this.getContentData() != null) {
            this.putProperty(PROP_CONTENT_DATA, this.getContentData());
        }
    }

    private String[] getContentData() {
        Object object;
        Component component = this.templateChooser().getComponent();
        if (this.iterator.current() == this.templateChooser()) {
            return (String[])((JComponent)component).getClientProperty(PROP_CONTENT_DATA);
        }
        String[] stringArray = null;
        Component component2 = this.iterator.current().getComponent();
        if (component2 instanceof JComponent && (object = ((JComponent)component2).getClientProperty(PROP_CONTENT_DATA)) instanceof String[]) {
            String[] stringArray2 = (String[])object;
            Object object2 = ((JComponent)component).getClientProperty(PROP_CONTENT_DATA);
            if (object2 instanceof String[]) {
                stringArray = new String[stringArray2.length + 1];
                stringArray[0] = ((String[])object2)[0];
                System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
            } else {
                stringArray = new String[stringArray2.length];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            }
        }
        return stringArray;
    }

    private int getContentSelectedIndex() {
        Object object;
        if (this.iterator.current() == this.templateChooser()) {
            return 0;
        }
        Component component = this.iterator.current().getComponent();
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(PROP_CONTENT_SELECTED_INDEX)) instanceof Integer) {
            return (Integer)object + 1;
        }
        return 1;
    }

    final TemplateWizardIterImpl getIterImpl() {
        return this.iterator;
    }

    private PropertyChangeListener propL() {
        if (this.pcl == null) {
            this.pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TemplateWizard.PROP_CONTENT_SELECTED_INDEX.equals(propertyChangeEvent.getPropertyName())) {
                        TemplateWizard.this.putProperty(TemplateWizard.PROP_CONTENT_SELECTED_INDEX, new Integer(TemplateWizard.this.getContentSelectedIndex()));
                    } else if (TemplateWizard.PROP_CONTENT_DATA.equals(propertyChangeEvent.getPropertyName()) && TemplateWizard.this.getContentData() != null) {
                        TemplateWizard.this.putProperty(TemplateWizard.PROP_CONTENT_DATA, TemplateWizard.this.getContentData());
                    }
                }
            };
        }
        return this.pcl;
    }

    private static class InstantiatingIteratorBridge
    implements Iterator {
        private WizardDescriptor.InstantiatingIterator instantiatingIterator;
        static final /* synthetic */ boolean $assertionsDisabled;

        public InstantiatingIteratorBridge(WizardDescriptor.InstantiatingIterator instantiatingIterator) {
            this.instantiatingIterator = instantiatingIterator;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.instantiatingIterator.addChangeListener(changeListener);
        }

        public WizardDescriptor.Panel current() {
            return this.instantiatingIterator.current();
        }

        public boolean hasNext() {
            return this.instantiatingIterator.hasNext();
        }

        public boolean hasPrevious() {
            return this.instantiatingIterator.hasPrevious();
        }

        public String name() {
            return this.instantiatingIterator.name();
        }

        public void nextPanel() {
            this.instantiatingIterator.nextPanel();
        }

        public void previousPanel() {
            this.instantiatingIterator.previousPanel();
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.instantiatingIterator.removeChangeListener(changeListener);
        }

        public void initialize(TemplateWizard templateWizard) {
            this.instantiatingIterator.initialize((WizardDescriptor)templateWizard);
        }

        public Set instantiate(TemplateWizard templateWizard) throws IOException {
            Set set = this.instantiatingIterator.instantiate();
            java.util.Iterator iterator = set.iterator();
            LinkedHashSet<DataObject> linkedHashSet = new LinkedHashSet<DataObject>(set.size());
            while (iterator.hasNext()) {
                DataObject dataObject;
                Object e = iterator.next();
                if (!$assertionsDisabled && e == null) {
                    throw new AssertionError();
                }
                if (e instanceof DataObject) continue;
                if (e instanceof FileObject) {
                    try {
                        dataObject = DataObject.find((FileObject)e);
                        linkedHashSet.add(dataObject);
                        continue;
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(e);
                        }
                        continue;
                    }
                }
                if (!(e instanceof Node)) continue;
                dataObject = (DataObject)((Node)e).getCookie(class$org$openide$loaders$DataObject == null ? TemplateWizard.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (!$assertionsDisabled && dataObject == null) {
                    throw new AssertionError(e);
                }
                linkedHashSet.add(dataObject);
            }
            return linkedHashSet;
        }

        public void uninitialize(TemplateWizard templateWizard) {
            this.instantiatingIterator.uninitialize((WizardDescriptor)templateWizard);
        }

        static {
            $assertionsDisabled = !(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard).desiredAssertionStatus();
        }
    }

    private final class DefaultIterator
    implements Iterator {
        DefaultIterator() {
        }

        public String name() {
            return "";
        }

        public Set instantiate(TemplateWizard templateWizard) throws IOException {
            String string = templateWizard.getTargetName();
            DataFolder dataFolder = templateWizard.getTargetFolder();
            DataObject dataObject = templateWizard.getTemplate();
            DataObject dataObject2 = string == null ? dataObject.createFromTemplate(dataFolder) : dataObject.createFromTemplate(dataFolder, string);
            Node node = dataObject2.getNodeDelegate();
            Action action = node.getPreferredAction();
            if (action != null) {
                SwingUtilities.invokeLater(new Runnable(this, action, node){
                    private final /* synthetic */ Action val$a;
                    private final /* synthetic */ Node val$node;
                    private final /* synthetic */ DefaultIterator this$1;
                    {
                        this.this$1 = defaultIterator;
                        this.val$a = action;
                        this.val$node = node;
                    }

                    public void run() {
                        this.val$a.actionPerformed(new ActionEvent(this.val$node, 1001, ""));
                    }
                });
            }
            return Collections.singleton(dataObject2);
        }

        public void initialize(TemplateWizard templateWizard) {
        }

        public void uninitialize(TemplateWizard templateWizard) {
        }

        public WizardDescriptor.Panel current() {
            return TemplateWizard.this.targetChooser();
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public void nextPanel() {
            throw new NoSuchElementException();
        }

        public void previousPanel() {
            throw new NoSuchElementException();
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    public static interface Iterator
    extends WizardDescriptor.Iterator,
    Serializable,
    Node.Cookie {
        public Set instantiate(TemplateWizard var1) throws IOException;

        public void initialize(TemplateWizard var1);

        public void uninitialize(TemplateWizard var1);
    }
}

