/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.openthinclient.manager.runtime.util.RestartApplicationEvent;
import org.openthinclient.manager.standalone.config.ManagerStandaloneServerConfiguration;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.wizard.WizardApplicationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationControl {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationControl.class);
    private volatile boolean restartScheduled;
    private volatile ConfigurableApplicationContext context;

    public void start(String[] args) {
        if (this.context != null) {
            throw new IllegalStateException("The application has already been started");
        }
        ManagerHomeFactory managerHomeFactory = new ManagerHomeFactory();
        if (managerHomeFactory.isManagerHomeValidAndInstalled()) {
            LOG.info("\n========================================================\n\nStarting the open thinclient server\n\nHome Directory:\n{}\n========================================================", (Object)managerHomeFactory.getManagerHomeDirectory());
            this.context = SpringApplication.run(ManagerStandaloneServerConfiguration.class, (String[])args);
        } else {
            LOG.info("\n========================================================\n\nopen thinclient\nFirst Time Installation\n\n========================================================", (Object)managerHomeFactory.getManagerHomeDirectory());
            this.context = SpringApplication.run(WizardApplicationConfiguration.class, (String[])args);
        }
        this.context.addApplicationListener(event -> {
            if (event instanceof RestartApplicationEvent) {
                this.restart(args);
            }
        });
        this.context.start();
    }

    public void restart(final String[] args) {
        if (this.restartScheduled) {
            return;
        }
        LOG.info("\n========================================================\n\nopen thinclient\nAPPLICATION RESTART REQUESTED\n\n========================================================");
        this.restartScheduled = true;
        final Timer timer = new Timer(this.getClass().getSimpleName() + "-restart");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ApplicationControl.this.stop();
                ApplicationControl.this.start(args);
                ApplicationControl.this.restartScheduled = false;
                timer.cancel();
            }
        }, TimeUnit.SECONDS.toMillis(5L));
    }

    public void stop() {
        if (this.context == null) {
            return;
        }
        try {
            this.context.close();
        }
        catch (Exception e) {
            LOG.error("Application shutdown failed. Exiting", (Throwable)e);
            System.exit(-1);
        }
        this.context = null;
    }
}

