/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.view;

import com.jgoodies.validation.ValidationResultModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;

public final class ValidationResultListAdapter
extends AbstractListModel {
    private final ValidationResultModel model;
    private int oldSize;

    public ValidationResultListAdapter(ValidationResultModel model) {
        this.model = model;
        this.oldSize = this.getSize();
        model.addPropertyChangeListener("result", new ValidationResultHandler());
    }

    public Object getElementAt(int index) {
        return this.model.getResult().getMessages().get(index);
    }

    public int getSize() {
        return this.model.getResult().getMessages().size();
    }

    private final class ValidationResultHandler
    implements PropertyChangeListener {
        private ValidationResultHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int newSize = ValidationResultListAdapter.this.getSize();
            int oldLastIndex = ValidationResultListAdapter.this.oldSize - 1;
            int newLastIndex = newSize - 1;
            ValidationResultListAdapter.this.oldSize = newSize;
            this.fireListChanged(oldLastIndex, newLastIndex);
        }

        private void fireListChanged(int oldLastIndex, int newLastIndex) {
            if (oldLastIndex == newLastIndex) {
                if (newLastIndex == -1) {
                    return;
                }
                ValidationResultListAdapter.this.fireContentsChanged(ValidationResultListAdapter.this, 0, newLastIndex);
            } else {
                if (oldLastIndex >= 0) {
                    ValidationResultListAdapter.this.fireIntervalRemoved(ValidationResultListAdapter.this, 0, oldLastIndex);
                }
                if (newLastIndex >= 0) {
                    ValidationResultListAdapter.this.fireIntervalAdded(ValidationResultListAdapter.this, 0, newLastIndex);
                }
            }
        }
    }
}

