/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.view;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationResultListAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public final class ValidationResultViewFactory {
    private static final Color DEFAULT_REPORT_BACKGROUND = new Color(255, 255, 210);

    private ValidationResultViewFactory() {
    }

    public static JLabel createReportIconLabel(ValidationResultModel model) {
        JLabel label = new JLabel();
        LabelIconChangeHandler.updateVisibilityAndIcon(label, model.getSeverity());
        model.addPropertyChangeListener("severity", new LabelIconChangeHandler(label));
        return label;
    }

    public static JLabel createReportIconAndTextLabel(ValidationResultModel model) {
        JLabel label = ValidationResultViewFactory.createReportIconLabel(model);
        LabelTextChangeHandler.updateText(label, model.getResult());
        model.addPropertyChangeListener("result", new LabelTextChangeHandler(label));
        return label;
    }

    public static JComponent createReportIconAndTextPane(ValidationResultModel model) {
        JLabel label = ValidationResultViewFactory.createReportIconLabel(model);
        JTextArea area = ValidationResultViewFactory.createReportTextArea(model);
        area.setOpaque(false);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel reportPane = new JPanel(gbl);
        reportPane.setOpaque(false);
        reportPane.setVisible(model.hasMessages());
        gbc.gridwidth = 1;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 0, 0, 0);
        reportPane.add((Component)label, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 4, 0, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        reportPane.add((Component)area, gbc);
        reportPane.setFocusable(false);
        model.addPropertyChangeListener("messages", new MessageStateChangeHandler(reportPane));
        return reportPane;
    }

    public static JComponent createReportList(ValidationResultModel model) {
        return ValidationResultViewFactory.createReportList(model, DEFAULT_REPORT_BACKGROUND);
    }

    public static JComponent createReportList(ValidationResultModel model, Color backgroundColor) {
        JList<Object> list = new JList<Object>();
        list.setFocusable(false);
        list.setBackground(backgroundColor);
        list.setCellRenderer(new BasicValidationMessageCellRenderer());
        list.setModel(new ValidationResultListAdapter(model));
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setVisible(model.hasMessages());
        model.addPropertyChangeListener("messages", new MessageStateChangeHandler(scrollPane));
        return scrollPane;
    }

    public static JTextArea createReportTextArea(ValidationResultModel model) {
        return ValidationResultViewFactory.createReportTextArea(model, DEFAULT_REPORT_BACKGROUND);
    }

    public static JTextArea createReportTextArea(ValidationResultModel model, Color backgroundColor) {
        JTextArea area = new JTextArea();
        area.setEditable(false);
        area.setFocusable(false);
        area.setOpaque(true);
        area.setBackground(backgroundColor);
        MessageTextChangeHandler.updateText(area, model.getResult());
        model.addPropertyChangeListener("result", new MessageTextChangeHandler(area));
        return area;
    }

    public static JComponent createReportTextPane(ValidationResultModel model) {
        return ValidationResultViewFactory.createReportTextPane(model, DEFAULT_REPORT_BACKGROUND);
    }

    public static JComponent createReportTextPane(ValidationResultModel model, Color backgroundColor) {
        JTextArea area = ValidationResultViewFactory.createReportTextArea(model, backgroundColor);
        JScrollPane scrollPane = new JScrollPane(area);
        scrollPane.setVisible(model.hasMessages());
        model.addPropertyChangeListener("messages", new MessageStateChangeHandler(scrollPane));
        return scrollPane;
    }

    public static ImageIcon getErrorIcon() {
        return Icons.ERROR_ICON;
    }

    public static ImageIcon getWarningIcon() {
        return Icons.WARNING_ICON;
    }

    public static ImageIcon getSmallErrorIcon() {
        return Icons.SMALL_ERROR_ICON;
    }

    public static ImageIcon getSmallWarningIcon() {
        return Icons.SMALL_WARNING_ICON;
    }

    public static ImageIcon getInfoIcon() {
        return Icons.INFO_ICON;
    }

    public static ImageIcon getSmallInfoIcon() {
        return Icons.SMALL_INFO_ICON;
    }

    public static ImageIcon getCheckIcon() {
        return Icons.CHECK_ICON;
    }

    public static Icon getIcon(Severity severity) {
        if (severity == Severity.ERROR) {
            return ValidationResultViewFactory.getErrorIcon();
        }
        if (severity == Severity.WARNING) {
            return ValidationResultViewFactory.getWarningIcon();
        }
        return null;
    }

    public static Icon getSmallIcon(Severity severity) {
        if (severity == Severity.ERROR) {
            return ValidationResultViewFactory.getSmallErrorIcon();
        }
        if (severity == Severity.WARNING) {
            return ValidationResultViewFactory.getSmallWarningIcon();
        }
        return null;
    }

    private static class Icons {
        private static final byte[] ERROR_GIF_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -77, 0, 0, -1, 127, 63, -8, 88, 56, -1, 95, 63, -8, 56, 56, -33, 63, 63, -65, 63, 63, -104, 56, 56, 127, 63, 63, -1, -65, -65, -97, 127, 127, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 11, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 4, 84, 112, -55, 73, -85, -67, 120, -91, -62, 75, -54, -59, 32, 14, 68, 97, 92, 33, -96, 8, 65, -96, -104, 85, 50, 0, 0, -94, 12, 10, 82, 126, 83, 26, -32, 57, 18, -84, 55, 96, 1, 69, -91, 3, 37, -12, -77, -35, -124, 74, 98, -64, 54, -96, -106, 78, -109, 4, 1, 55, 66, 32, 76, -68, -119, -127, 64, 46, -101, -94, 21, 67, -121, 99, 64, 91, 18, -19, -125, 33, -100, -87, -37, 41, 17, 0, 59};
        private static final byte[] SMALL_ERROR_GIF_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 7, 0, 8, 0, -94, 0, 0, -1, 0, 0, -65, 63, 63, 127, 63, 63, -1, 127, 127, -65, 95, 95, -33, -65, -65, -1, -1, -1, -1, -1, -1, 33, -7, 4, 1, 0, 0, 7, 0, 44, 0, 0, 0, 0, 7, 0, 8, 0, 0, 3, 25, 88, -79, -85, 54, 96, -104, 37, -55, 19, 1, 88, 2, -80, 54, 28, 86, 93, -63, 19, 77, -118, -96, 6, 69, 2, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        private static final byte[] WARNING_GIF_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -77, 0, 0, -1, -1, 95, -1, -33, 63, -33, -65, 63, -1, -33, 95, -65, -97, 63, -1, -65, 63, -97, 127, 63, -65, -65, -65, 95, 95, 95, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 10, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 4, 69, 80, -55, 73, -85, -67, 120, 10, -110, -23, -39, 71, 39, 9, -64, 38, 126, 67, 64, -124, 25, -103, 32, 38, -122, -66, -59, -118, -111, -64, 27, -60, -43, 7, 12, -70, 26, -117, 66, 26, 0, 2, -56, 29, -57, 35, 48, 6, 104, 1, 33, -123, 96, 28, 12, 10, 5, -127, -106, -89, 32, 24, -66, -32, -80, 65, 68, 22, 69, 0, 0, 59};
        private static final byte[] SMALL_WARNING_GIF_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 7, 0, 8, 0, -77, 0, 0, -1, -1, 63, -1, -1, 127, -65, -65, 127, -33, -33, -65, -1, -33, 63, -65, -97, 63, -97, 127, 63, -1, -65, 95, -1, -1, -1, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 10, 0, 44, 0, 0, 0, 0, 7, 0, 8, 0, 0, 4, 33, 80, -95, 97, 6, 82, -78, 16, 115, 103, 73, 21, -126, 20, 65, 2, 112, 3, 105, 86, 36, 112, 0, -101, 1, 0, 9, -79, 9, 70, -95, 27, 66, 4, 0, 59};
        private static final byte[] INFO_GIF_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -94, 0, 0, 0, 0, -1, 63, 63, -65, 95, 95, -65, 127, 127, -65, -90, -54, -16, -1, -1, -1, -1, -1, -1, 0, 0, 0, 33, -7, 4, 1, 0, 0, 6, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 3, 48, 104, -70, -36, -2, 80, -107, 57, -93, 28, -128, 20, 107, 10, 0, -63, 102, 21, 68, -96, -115, 84, 21, 21, -62, 55, -120, -48, -28, -62, -15, -52, 121, -64, 123, -37, 43, -2, -46, 13, -42, 39, -96, -117, -91, 84, -100, 71, 2, 0, 59};
        private static final byte[] SMALL_INFO_GIF_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 9, 0, 9, 0, -77, 0, 0, 0, 0, -124, 57, 57, 90, 57, 90, -100, -100, -100, -100, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -7, 4, 1, 0, 0, 3, 0, 44, 0, 0, 0, 0, 9, 0, 9, 0, 0, 4, 29, 112, 12, 65, -87, -100, 36, -25, -128, 51, -48, -127, -96, 125, -101, -24, -127, 38, 65, 18, -31, 8, 14, -127, -74, 93, 65, 93, 75, 17, 0, 59};
        private static final byte[] CHECK_ICON_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -77, 0, 0, 0, 0, -1, 63, 127, -65, 127, -97, -65, -90, -54, -16, -97, -65, -65, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 5, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 4, 43, -80, -56, 73, -85, -67, 56, 19, -112, 105, 0, 67, 39, 125, -124, 88, 124, -95, 40, -128, -26, 0, 8, -40, 0, 23, 110, 16, 3, 44, -102, -83, -17, 43, -30, 56, 19, 47, -11, -101, -103, -114, -56, 8, 0, 59};
        private static final ImageIcon ERROR_ICON = new ImageIcon(ERROR_GIF_BYTES);
        private static final ImageIcon SMALL_ERROR_ICON = new ImageIcon(SMALL_ERROR_GIF_BYTES);
        private static final ImageIcon WARNING_ICON = new ImageIcon(WARNING_GIF_BYTES);
        private static final ImageIcon SMALL_WARNING_ICON = new ImageIcon(SMALL_WARNING_GIF_BYTES);
        private static final ImageIcon INFO_ICON = new ImageIcon(INFO_GIF_BYTES);
        private static final ImageIcon SMALL_INFO_ICON = new ImageIcon(SMALL_INFO_GIF_BYTES);
        private static final ImageIcon CHECK_ICON = new ImageIcon(CHECK_ICON_BYTES);

        private Icons() {
        }
    }

    private static class BasicValidationMessageCellRenderer
    extends DefaultListCellRenderer {
        private BasicValidationMessageCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, false, false);
            ValidationMessage message = (ValidationMessage)value;
            this.setIcon(ValidationResultViewFactory.getIcon(message.severity()));
            this.setText(message.formattedText());
            return this;
        }
    }

    private static final class LabelTextChangeHandler
    implements PropertyChangeListener {
        private final JLabel label;

        private LabelTextChangeHandler(JLabel label) {
            this.label = label;
        }

        private static void updateText(JLabel label, ValidationResult result) {
            label.setText(result.hasMessages() ? ((ValidationMessage)result.getMessages().get(0)).formattedText() : "");
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("result")) {
                LabelTextChangeHandler.updateText(this.label, (ValidationResult)evt.getNewValue());
            }
        }
    }

    private static final class LabelIconChangeHandler
    implements PropertyChangeListener {
        private final JLabel label;

        private LabelIconChangeHandler(JLabel label) {
            this.label = label;
        }

        private static void updateVisibilityAndIcon(JLabel aLabel, Severity severity) {
            aLabel.setVisible(severity != Severity.OK);
            if (severity == Severity.ERROR) {
                aLabel.setIcon(ValidationResultViewFactory.getErrorIcon());
            } else if (severity == Severity.WARNING) {
                aLabel.setIcon(ValidationResultViewFactory.getWarningIcon());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("severity")) {
                LabelIconChangeHandler.updateVisibilityAndIcon(this.label, (Severity)evt.getNewValue());
            }
        }
    }

    public static final class MessageStateChangeHandler
    implements PropertyChangeListener {
        private final Component component;

        public MessageStateChangeHandler(Component component) {
            this.component = component;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("messages")) {
                boolean hasMessages = (Boolean)evt.getNewValue();
                this.component.setVisible(hasMessages);
            }
        }
    }

    private static final class MessageTextChangeHandler
    implements PropertyChangeListener {
        private final JTextComponent textComponent;

        private MessageTextChangeHandler(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        private static void updateText(JTextComponent aTextComponent, ValidationResult result) {
            aTextComponent.setText(result.getMessagesText());
            aTextComponent.setCaretPosition(0);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("result")) {
                MessageTextChangeHandler.updateText(this.textComponent, (ValidationResult)evt.getNewValue());
            }
        }
    }
}

