/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.directory;

import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapContext;

public class ACLUtils {
    private final LdapContext ctx;

    public ACLUtils(LdapContext ctx) {
        this.ctx = ctx;
    }

    public void makeACSA(String dn) throws NamingException {
        Attributes ap = this.ctx.getAttributes(dn, new String[]{"administrativeRole"});
        Attribute administrativeRole = ap.get("administrativeRole");
        if (administrativeRole == null || !administrativeRole.contains("accessControlSpecificArea")) {
            BasicAttributes changes = new BasicAttributes("administrativeRole", "accessControlSpecificArea", true);
            this.ctx.modifyAttributes(dn, 1, (Attributes)changes);
        }
    }

    public void enableSearchForAllUsers(String dn) throws NamingException {
        String subentryName = "enableSearchForAllUsers";
        String aciSpec = "{ identificationTag \"enableSearchForAllUsers\", precedence 14, authenticationLevel simple, itemOrUserFirst userFirst:  {  userClasses { subtree { {} } },  userPermissions  {  {  protectedItems {entry, allUserAttributeTypesAndValues},  grantsAndDenials { grantRead, grantReturnDN, grantBrowse }  } } } }";
        String subtreeSpec = "{}";
        this.createACISubentry(dn, subentryName, aciSpec, subtreeSpec);
    }

    public void enableAdminUsers(String dn) throws NamingException {
        String subentryName = "enableAdmins";
        String subtreeSpec = "{ }";
        String aciSpec = "{ identificationTag \"enableAdmins\", precedence 20, authenticationLevel simple, itemOrUserFirst userFirst:  {  userClasses { userGroup { \"cn=administrators,ou=RealmConfiguration," + (dn.length() > 0 ? dn + "," : "") + this.ctx.getNameInNamespace() + "\" } },  userPermissions  { {  protectedItems {entry, allUserAttributeTypesAndValues},  grantsAndDenials { grantRead, grantReturnDN, grantBrowse, grantRemove, grantModify, grantAdd, grantRename, grantCompare }  } } } }";
        this.createACISubentry(dn, subentryName, aciSpec, subtreeSpec);
    }

    private void createACISubentry(String dn, String subentryName, String aciSpec, String subtreeSpec) throws NamingException {
        BasicAttributes subentry = new BasicAttributes("cn", subentryName, true);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        subentry.put(objectClass);
        objectClass.add("top");
        objectClass.add("subentry");
        objectClass.add("accessControlSubentry");
        subentry.put("subtreeSpecification", subtreeSpec);
        subentry.put("prescriptiveACI", aciSpec);
        String name = "cn=" + subentryName + (null != dn && dn.length() > 0 ? "," + dn : "");
        try {
            this.ctx.getAttributes(name);
            this.ctx.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.ctx.bind(name, null, (Attributes)subentry);
    }

    public void deleteACI(String dn, String subentryName) throws NamingException {
        this.ctx.unbind("cn=" + subentryName + (null != dn && dn.length() > 0 ? "," + dn : ""));
    }

    public void checkACI() throws NamingException {
        Attributes att = this.ctx.getAttributes("cn=enableSearchForAllUsers", new String[]{"cn", "objectclass", "subtreeSpecification", "prescriptiveACI"});
        NamingEnumeration<String> ds = att.getIDs();
        while (ds.hasMore()) {
            String name = ds.next();
            System.out.println(name + " -> " + att.get(name));
        }
    }

    public void listACIs(String dn) throws NamingException {
        NamingEnumeration<NameClassPair> ne = this.ctx.list(dn);
        while (ne.hasMoreElements()) {
            System.out.println(ne.next());
        }
    }
}

