/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.Label;
import org.slf4j.LoggerFactory;

@XmlType(name="choice-node")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ChoiceNode
extends EntryNode {
    private static final long serialVersionUID = 983752831232339241L;
    @XmlElement(name="option")
    private final List<Option> options = new ArrayList<Option>();
    private Style style;

    public List<Option> getOptions() {
        return this.options;
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public Option getSelectedOption() {
        String value = this.getValue();
        for (Option o : this.options) {
            if (!o.getValue().equals(value)) continue;
            return o;
        }
        return null;
    }

    public String getLabelForValue(String value) {
        if (null != value) {
            for (Option option : this.getOptions()) {
                if (!value.equals(option.getValue())) continue;
                return option.getLabel();
            }
        }
        return "";
    }

    protected void toStringExtended(int indent, StringBuffer sb) {
        for (Option option : this.options) {
            for (int j = 0; j < indent; ++j) {
                sb.append("  ");
            }
            sb.append("[Option: ").append(option.getName()).append(" -> ").append(option.getValue()).append("]\n");
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = Style.valueOf(style);
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public long getUID() {
        long uid = 0L;
        for (Option opt : this.options) {
            uid ^= (long)opt.getValue().hashCode();
        }
        return super.getUID() ^ uid;
    }

    @XmlType(name="choice-node-option")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Option
    implements Serializable {
        private static final long serialVersionUID = 83274659873458345L;
        @XmlElement(name="label")
        private final List<Label> labels = new ArrayList<Label>();
        @XmlAttribute(name="name")
        private String name;
        @XmlAttribute(name="value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.getLabel();
        }

        public List<Label> getLabels() {
            return this.labels;
        }

        public String getLabel() {
            for (Label label : this.labels) {
                if (!label.getLang().equals(Locale.getDefault().getLanguage())) continue;
                String labelText = label.getLabel();
                LoggerFactory.getLogger(this.getClass()).debug(labelText);
                if (labelText == null) continue;
                return labelText;
            }
            return this.getName();
        }
    }

    public static enum Style {
        COMBOBOX,
        LIST,
        LIST_MULTI,
        CHECKBOXES,
        RADIOBUTTONS;

    }
}

