/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import org.openthinclient.common.model.schema.ChoiceNode;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.GroupNode;
import org.openthinclient.common.model.schema.Label;
import org.openthinclient.common.model.schema.PasswordNode;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.SectionNode;
import org.openthinclient.common.model.schema.ValueNode;

@XmlType(name="node", propOrder={"labels", "tips", "children"})
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class Node
implements Iterable<Node>,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElements(value={@XmlElement(name="choice", type=ChoiceNode.class), @XmlElement(name="entry", type=EntryNode.class), @XmlElement(name="group", type=GroupNode.class), @XmlElement(name="password", type=PasswordNode.class), @XmlElement(name="value", type=ValueNode.class), @XmlElement(name="section", type=SectionNode.class)})
    private final List<Node> children = new ArrayList<Node>(2);
    @XmlElement(name="label")
    private final List<Label> labels = new ArrayList<Label>(4);
    @XmlElement(name="tip")
    private final List<Label> tips = new ArrayList<Label>(4);
    @XmlAttribute(name="name")
    private String name;
    private transient Node parent;
    private transient String key;

    public List<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Node getChild(String name) {
        for (Node child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public void addChild(Node child) {
        child.setParent(this);
        this.children.add(child);
    }

    public boolean removeChild(Node child) {
        if (!this.children.contains(child)) {
            return false;
        }
        child.setParent(null);
        this.children.remove(child);
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("Node name may not contain a '/'");
        }
        this.name = name;
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
        this.clearPathCache();
    }

    @Deprecated
    public void clearPathCache() {
        if (null != this.key) {
            this.key = null;
            for (Node child : this.children) {
                child.clearPathCache();
            }
        }
    }

    public String getKey() {
        if (null == this.key) {
            this.key = null == this.parent || this.parent instanceof Schema ? this.name : this.parent.getKey() + "." + this.name;
        }
        return this.key;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.children.iterator();
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public String getLabel() {
        for (Label label : this.labels) {
            String labelText;
            if (!label.getLang().equals(Locale.getDefault().getLanguage()) || (labelText = label.getLabel()) == null) continue;
            return labelText;
        }
        return this.name;
    }

    public List<Label> getTips() {
        return this.tips;
    }

    public String getTip() {
        for (Label tip : this.tips) {
            if (!tip.getLang().equals(Locale.getDefault().getLanguage())) continue;
            return tip.getLabel();
        }
        return null;
    }

    protected long getUID() {
        long uid = this.getClass().getSimpleName().hashCode();
        for (Node child : this.children) {
            uid ^= child.getUID();
        }
        return uid ^= (long)(this.getKey().hashCode() ^ this.getName().hashCode());
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        this.children.forEach(c -> c.setParent(this));
    }
}

