/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.service;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.service.DirectoryObjectService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.Filter;
import org.openthinclient.ldap.TypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractLDAPService<T extends DirectoryObject>
implements DirectoryObjectService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLDAPService.class);
    protected final RealmService realmService;
    private final Class<T> type;

    public AbstractLDAPService(Class<T> type, RealmService realmService) {
        this.type = type;
        this.realmService = realmService;
    }

    protected <O extends DirectoryObject> Stream<O> findAll(Class<O> type) {
        return this.withAllReams(realm -> {
            try {
                return realm.getDirectory().list(type, null, TypeMapping.SearchScope.SUBTREE).stream();
            }
            catch (DirectoryException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected <O extends DirectoryObject> Stream<O> findByName(Class<O> type, String name) {
        return this.withAllRealms((r, dir) -> dir.list(type, new Filter("(&(cn={0}))", name), TypeMapping.SearchScope.SUBTREE).stream());
    }

    @Override
    public Set<T> findAll() {
        return this.findAll(this.type).collect(Collectors.toSet());
    }

    @Override
    public T findByName(String name) {
        return (T)((DirectoryObject)this.findByName(this.type, name).findFirst().orElse(null));
    }

    @Override
    public void save(T object) {
        try {
            LDAPDirectory directory = ((DirectoryObject)object).getRealm() != null && ((DirectoryObject)object).getRealm().getDirectory() != null ? ((DirectoryObject)object).getRealm().getDirectory() : this.realmService.getDefaultRealm().getDirectory();
            directory.save(object);
        }
        catch (DirectoryException e) {
            throw this.translateException(e);
        }
    }

    protected <T> Stream<T> withAllRealms(RealmCallback<T> callback) {
        return this.withAllReams(r -> {
            try {
                return callback.execute((Realm)r, r.getDirectory());
            }
            catch (DirectoryException e) {
                throw this.translateException(e);
            }
        });
    }

    protected RuntimeException translateException(DirectoryException e) {
        return new RuntimeException("Failed to access directory", e);
    }

    protected <T> Stream<T> withAllReams(Function<Realm, Stream<T>> function) {
        return this.realmService.findAllRealms().stream().flatMap(function);
    }

    @Override
    public void reloadAllSchemas() {
        this.realmService.getDefaultRealm().getSchemaProvider().reload();
    }

    @FunctionalInterface
    public static interface RealmCallback<T> {
        public Stream<T> execute(Realm var1, LDAPDirectory var2) throws DirectoryException;
    }
}

