/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.service;

import java.util.Set;
import java.util.stream.Collectors;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.service.AbstractLDAPService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.ldap.DirectoryException;

public class DefaultLDAPApplicationService
extends AbstractLDAPService<Application>
implements ApplicationService {
    public DefaultLDAPApplicationService(RealmService realmService) {
        super(Application.class, realmService);
    }

    @Override
    public void delete(Application application) {
        Realm realm = application.getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("given application has no realm assigned.");
        }
        try {
            realm.getDirectory().delete(application);
        }
        catch (DirectoryException e) {
            throw new RuntimeException("Failed to delete application object", e);
        }
    }

    @Override
    public Set<Application> findAllUsingSchema(Schema<?> schema) {
        String schemaName = schema.getName();
        return this.findAll(Application.class).filter(application -> schemaName.equalsIgnoreCase(this.getSchemaName((Application)application))).collect(Collectors.toSet());
    }

    private String getSchemaName(Application application) {
        Realm realm = application.getRealm();
        Schema schema = application.getSchema(realm);
        return schema.getName();
    }
}

