/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import javax.naming.NamingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.directory.server.configuration.ServerStartupConfiguration;
import org.apache.directory.server.ssl.support.ServerX509TrustManager;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.filter.SSLFilter;

public class LdapsInitializer {
    public static IoFilterChainBuilder init(ServerStartupConfiguration cfg) throws NamingException {
        SSLContext sslCtx;
        char[] certPasswdChars = cfg.getLdapsCertificatePassword().toCharArray();
        String storePath = cfg.getLdapsCertificateFile().getPath();
        KeyStore ks = null;
        try {
            ks = LdapsInitializer.loadKeyStore(storePath, "PKCS12");
        }
        catch (Exception e) {
            try {
                ks = LdapsInitializer.loadKeyStore(storePath, "JKS");
            }
            catch (Exception e2) {
                throw (NamingException)new NamingException("Failed to load a certificate: " + storePath).initCause(e);
            }
        }
        try {
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = "SunX509";
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, certPasswdChars);
            sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(kmf.getKeyManagers(), new TrustManager[]{new ServerX509TrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Failed to create a SSL context.").initCause(e);
        }
        DefaultIoFilterChainBuilder chain = new DefaultIoFilterChainBuilder();
        chain.addLast("SSL", (IoFilter)new SSLFilter(sslCtx));
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String storePath, String storeType) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        FileInputStream in = null;
        KeyStore ks = KeyStore.getInstance(storeType);
        try {
            in = new FileInputStream(storePath);
            ks.load(in, null);
            KeyStore keyStore = ks;
            return keyStore;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

