/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.nfs;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class NFSExport
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3257846571638207028L;
    @XmlAttribute
    private String name;
    @XmlElement
    private File root;
    @XmlElement
    private final List<Group> groups = new ArrayList<Group>();
    @XmlTransient
    private boolean revoked;
    @XmlTransient
    private int cacheTimeout = 15000;

    public void setName(String name2) {
        this.name = name2;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public File getRoot() {
        return this.root;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(int cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.root.getAbsolutePath());
        sb.append("|").append(this.name);
        if (null != this.groups) {
            for (Group group : this.groups) {
                sb.append("|").append(group);
            }
        } else {
            sb.append("|*(rw)");
        }
        return sb.toString();
    }

    public NFSExport clone() {
        NFSExport clone = new NFSExport();
        clone.setName(this.name);
        clone.setRevoked(this.revoked);
        clone.setRoot(this.root);
        clone.setCacheTimeout(this.cacheTimeout);
        clone.getGroups().addAll(this.groups.stream().map(Group::clone).collect(Collectors.toList()));
        return clone;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Group
    implements Cloneable {
        private InetAddress address;
        private int mask;
        private boolean readOnly;
        private boolean wildcard;

        public InetAddress getAddress() {
            return this.address;
        }

        public int getMask() {
            return this.mask;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public boolean isWildcard() {
            return this.wildcard;
        }

        public void setAddress(InetAddress address) {
            this.address = address;
        }

        public void setMask(int mask) {
            this.mask = mask;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void setWildcard(boolean wildcard) {
            this.wildcard = wildcard;
        }

        public String toString() {
            if (this.isWildcard()) {
                return "*" + (this.readOnly ? "(ro)" : "(rw)");
            }
            return (null != this.address ? this.address.toString() : "") + (0 != this.mask ? "/" + this.mask : "") + (this.readOnly ? "(ro)" : "(rw)");
        }

        public Group clone() {
            try {
                return (Group)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }
}

