/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.configuration;

import com.levigo.util.configuration.Configuration;
import com.levigo.util.datatype.Base64;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Properties;

public class PropertiesConfigurationImpl
extends Properties
implements Configuration {
    public PropertiesConfigurationImpl() {
    }

    public PropertiesConfigurationImpl(Properties defaults) {
        super(defaults);
    }

    public void load(String resourceName, Class loaderClass) throws IOException {
        InputStream is = null;
        Locale actualLocale = Locale.getDefault();
        String actualLanguage = actualLocale.getLanguage();
        String fileName = resourceName;
        String fileSuffix = null;
        int lastIndexOfSuffix = resourceName.lastIndexOf(".");
        if (lastIndexOfSuffix >= 0) {
            fileSuffix = resourceName.substring(lastIndexOfSuffix);
            fileName = resourceName.substring(0, lastIndexOfSuffix);
        }
        String lookForResource = fileName + "_" + actualLanguage + (fileSuffix == null ? "" : fileSuffix);
        try {
            is = loaderClass.getResourceAsStream(lookForResource);
        }
        catch (SecurityException secX) {
            // empty catch block
        }
        if (is == null) {
            try {
                is = loaderClass.getResourceAsStream("/" + lookForResource);
            }
            catch (SecurityException secX) {
                // empty catch block
            }
            if (is == null) {
                try {
                    is = loaderClass.getResourceAsStream(resourceName);
                }
                catch (SecurityException secX) {
                    // empty catch block
                }
                if (is == null) {
                    try {
                        is = loaderClass.getResourceAsStream("/" + resourceName);
                    }
                    catch (SecurityException secX) {
                        // empty catch block
                    }
                }
            }
        }
        if (is == null) {
            throw new FileNotFoundException("Could not load " + resourceName);
        }
        this.load(is);
        is.close();
    }

    public boolean containsKey(String key) {
        return this.containsKey((Object)key);
    }

    public boolean getPropertyAsBoolean(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("true");
    }

    public int getPropertyAsInt(String key, int defaultValue) {
        String value = this.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getProperty(String key) {
        String result = super.getProperty(key);
        if (null != result && result.startsWith("crypt:")) {
            try {
                byte[] propertyBytes = Base64.base64ToByteArray((String)result.substring(6));
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update("DWxdHEH7mn1cn0shL+E8d7H".getBytes());
                md.update(propertyBytes, 0, 8);
                int decryptOffset = 8;
                while (decryptOffset < propertyBytes.length) {
                    byte[] cipherBlock = md.digest();
                    int i = cipherBlock.length;
                    while (i-- > 0 && decryptOffset < propertyBytes.length) {
                        int n = decryptOffset++;
                        propertyBytes[n] = (byte)(propertyBytes[n] ^ cipherBlock[i]);
                    }
                    if (decryptOffset >= propertyBytes.length) continue;
                    md.update(cipherBlock);
                }
                result = new String(propertyBytes, 8, propertyBytes.length - 8);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Crypted property, but no algorighm");
            }
        }
        return result;
    }
}

