/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.crypto;

import com.levigo.util.datatype.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SimpleCrypter {
    private static final int HASH_PREFIX_BYTE_LENGTH = 6;
    private static final int HASH_PREFIX_STRING_LENGTH = 8;
    private MessageDigest seed = MessageDigest.getInstance("SHA1");
    private byte[] seedBytes;
    private static SimpleCrypter theInstance;

    private SimpleCrypter() throws NoSuchAlgorithmException {
        this.seed.update(Long.toString(System.currentTimeMillis()).getBytes());
        this.seedBytes = this.seed.digest();
    }

    public String doEncrypt(String value) {
        byte[] valueBytes = value.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update("DWxdHEH7mn1cn0shL+E8d7H".getBytes());
            md.update(this.seedBytes, 0, 8);
            int encryptOffset = 0;
            while (encryptOffset < valueBytes.length) {
                byte[] cipherBlock = md.digest();
                int i = cipherBlock.length;
                while (i-- > 0 && encryptOffset < valueBytes.length) {
                    int n = encryptOffset++;
                    valueBytes[n] = (byte)(valueBytes[n] ^ cipherBlock[i]);
                }
                if (encryptOffset >= valueBytes.length) continue;
                md.update(cipherBlock);
            }
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        byte[] resultBytes = new byte[8 + valueBytes.length];
        System.arraycopy(this.seedBytes, 0, resultBytes, 0, 8);
        System.arraycopy(valueBytes, 0, resultBytes, 8, valueBytes.length);
        return Base64.byteArrayToBase64((byte[])resultBytes);
    }

    public String doDecrypt(String encryptedValue) {
        if (encryptedValue == null || encryptedValue.equals("")) {
            return null;
        }
        try {
            byte[] propertyBytes = Base64.base64ToByteArray((String)encryptedValue);
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update("DWxdHEH7mn1cn0shL+E8d7H".getBytes());
            md.update(propertyBytes, 0, 8);
            int decryptOffset = 8;
            while (decryptOffset < propertyBytes.length) {
                byte[] cipherBlock = md.digest();
                int i = cipherBlock.length;
                while (i-- > 0 && decryptOffset < propertyBytes.length) {
                    int n = decryptOffset++;
                    propertyBytes[n] = (byte)(propertyBytes[n] ^ cipherBlock[i]);
                }
                if (decryptOffset >= propertyBytes.length) continue;
                md.update(cipherBlock);
            }
            return new String(propertyBytes, 8, propertyBytes.length - 8);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static SimpleCrypter getInstance() throws NoSuchAlgorithmException {
        if (theInstance == null) {
            theInstance = new SimpleCrypter();
        }
        return theInstance;
    }

    public static String hash(String s) throws NoSuchAlgorithmException {
        MessageDigest ms = MessageDigest.getInstance("SHA1");
        byte[] seed = Long.toString(System.currentTimeMillis()).getBytes();
        SecureRandom sr = new SecureRandom(seed);
        byte[] prefix = new byte[6];
        sr.nextBytes(prefix);
        String prefixString = Base64.byteArrayToBase64((byte[])prefix);
        ms.update(prefix);
        ms.update(s.getBytes());
        byte[] hash = ms.digest();
        String hashString = Base64.byteArrayToBase64((byte[])hash);
        return prefixString + hashString;
    }

    public static boolean compareHashToString(String hash, String s) throws NoSuchAlgorithmException {
        MessageDigest ms = MessageDigest.getInstance("SHA1");
        String prefix = hash.substring(0, 8);
        ms.update(Base64.base64ToByteArray((String)prefix));
        ms.update(s.getBytes());
        byte[] newHash = ms.digest();
        return MessageDigest.isEqual(newHash, Base64.base64ToByteArray((String)hash.substring(8, hash.length())));
    }
}

