/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.preferences;

import com.levigo.util.datatype.Base64;
import com.levigo.util.preferences.PreferenceChangeEvent;
import com.levigo.util.preferences.PreferenceChangeListener;
import com.levigo.util.preferences.PreferenceStore;
import com.levigo.util.preferences.WildcardPreferenceStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class PreferenceStoreHolder
implements WildcardPreferenceStore {
    private static int storeIndex = 0;
    protected static PreferenceStoreHolder theInstance;
    private Map registeredStores = null;
    private EventListenerList listenerList = null;

    protected PreferenceStoreHolder() {
    }

    public static PreferenceStoreHolder getInstance() {
        if (theInstance == null) {
            theInstance = new PreferenceStoreHolder();
        }
        return theInstance;
    }

    private Map getRegisteredPreferenceStores() {
        if (this.registeredStores == null) {
            this.registeredStores = Collections.synchronizedMap(new HashMap());
        }
        return this.registeredStores;
    }

    public static boolean addPreferenceStoreByName(String storeName, PreferenceStore aStore) {
        if (aStore == null || storeName == null) {
            throw new IllegalArgumentException("Either the store to register or its name is null.");
        }
        if (!aStore.isAccessible()) {
            throw new IllegalArgumentException("Store is not accessible.");
        }
        Map allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        if (allStores.containsKey(storeName)) {
            return false;
        }
        allStores.put(storeName, aStore);
        return true;
    }

    public static PreferenceStore getPreferenceStoreByName(String storeName) {
        if (storeName == null) {
            return null;
        }
        return (PreferenceStore)PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().get(storeName);
    }

    public static boolean addPreferenceStore(PreferenceStore aStore) {
        if (aStore == null) {
            throw new IllegalArgumentException("The store to register is null.");
        }
        if (!aStore.isAccessible()) {
            throw new IllegalArgumentException("Store is not accessible.");
        }
        return PreferenceStoreHolder.addPreferenceStoreByName("registeredStore #" + ++storeIndex, aStore);
    }

    public static void removePreferenceStore(String storeName) {
        if (storeName == null) {
            return;
        }
        PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().remove(storeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPreference(String preferenceKey, Object defaultValue) {
        Object preference = null;
        Collection allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().values();
        Map map = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        synchronized (map) {
            Iterator it = allStores.iterator();
            while (it.hasNext() && preference == null) {
                preference = ((PreferenceStore)it.next()).getPreference(preferenceKey, null);
            }
        }
        return preference == null ? defaultValue : preference;
    }

    public Object getPreference(String storeName, String preferenceKey, Object defaultValue) {
        if (storeName == null) {
            return defaultValue;
        }
        PreferenceStore aStore = (PreferenceStore)PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().get(storeName);
        if (aStore == null) {
            return defaultValue;
        }
        return aStore.getPreference(preferenceKey, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPreferenceAsBoolean(String preferenceKey, boolean defaultValue) {
        boolean preference = defaultValue;
        Collection allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().values();
        Map map = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        synchronized (map) {
            Iterator it = allStores.iterator();
            while (it.hasNext() && preference == defaultValue) {
                preference = ((PreferenceStore)it.next()).getPreferenceAsBoolean(preferenceKey, defaultValue);
            }
        }
        return preference;
    }

    public boolean getPreferenceAsBoolean(String storeName, String preferenceKey, boolean defaultValue) {
        if (storeName == null) {
            return defaultValue;
        }
        PreferenceStore aStore = (PreferenceStore)PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().get(storeName);
        if (aStore == null) {
            return defaultValue;
        }
        return aStore.getPreferenceAsBoolean(preferenceKey, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferenceAsInt(String preferenceKey, int defaultValue) {
        int preference = defaultValue;
        Collection allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().values();
        Map map = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        synchronized (map) {
            Iterator it = allStores.iterator();
            while (it.hasNext() && preference == defaultValue) {
                preference = ((PreferenceStore)it.next()).getPreferenceAsInt(preferenceKey, defaultValue);
            }
        }
        return preference;
    }

    public int getPreferenceAsInt(String storeName, String preferenceKey, int defaultValue) {
        if (storeName == null) {
            return defaultValue;
        }
        PreferenceStore aStore = (PreferenceStore)PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().get(storeName);
        if (aStore == null) {
            return defaultValue;
        }
        return aStore.getPreferenceAsInt(preferenceKey, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPreferenceAsFloat(String preferenceKey, float defaultValue) {
        float preference = defaultValue;
        Collection allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().values();
        Map map = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        synchronized (map) {
            Iterator it = allStores.iterator();
            while (it.hasNext() && preference == defaultValue) {
                preference = ((PreferenceStore)it.next()).getPreferenceAsFloat(preferenceKey, defaultValue);
            }
        }
        return preference;
    }

    public float getPreferenceAsFloat(String storeName, String preferenceKey, float defaultValue) {
        if (storeName == null) {
            return defaultValue;
        }
        PreferenceStore aStore = (PreferenceStore)PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().get(storeName);
        if (aStore == null) {
            return defaultValue;
        }
        return aStore.getPreferenceAsFloat(preferenceKey, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPreferenceAsDouble(String preferenceKey, double defaultValue) {
        double preference = defaultValue;
        Collection allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().values();
        Map map = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        synchronized (map) {
            Iterator it = allStores.iterator();
            while (it.hasNext() && preference == defaultValue) {
                preference = ((PreferenceStore)it.next()).getPreferenceAsDouble(preferenceKey, defaultValue);
            }
        }
        return preference;
    }

    public double getPreferenceAsDouble(String storeName, String preferenceKey, double defaultValue) {
        if (storeName == null) {
            return defaultValue;
        }
        PreferenceStore aStore = (PreferenceStore)PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().get(storeName);
        if (aStore == null) {
            return defaultValue;
        }
        return aStore.getPreferenceAsDouble(preferenceKey, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPreferenceAsLong(String preferenceKey, long defaultValue) {
        long preference = defaultValue;
        Collection allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().values();
        Map map = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        synchronized (map) {
            Iterator it = allStores.iterator();
            while (it.hasNext() && preference == defaultValue) {
                preference = ((PreferenceStore)it.next()).getPreferenceAsLong(preferenceKey, defaultValue);
            }
        }
        return preference;
    }

    public long getPreferenceAsLong(String storeName, String preferenceKey, long defaultValue) {
        if (storeName == null) {
            return defaultValue;
        }
        PreferenceStore aStore = (PreferenceStore)PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().get(storeName);
        if (aStore == null) {
            return defaultValue;
        }
        return aStore.getPreferenceAsLong(preferenceKey, defaultValue);
    }

    public String getPreferenceAsString(String preferenceKey, String defaultValue) {
        return this.decryptValue((String)this.getPreference(preferenceKey, defaultValue));
    }

    public String getPreferenceAsString(String storeName, String preferenceKey, String defaultValue) {
        if (storeName == null) {
            return defaultValue;
        }
        PreferenceStore aStore = (PreferenceStore)PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().get(storeName);
        if (aStore == null) {
            return defaultValue;
        }
        return this.decryptValue((String)aStore.getPreference(preferenceKey, defaultValue));
    }

    private String decryptValue(String cryptedValue) {
        if (null != cryptedValue && cryptedValue.startsWith("crypt:")) {
            try {
                byte[] propertyBytes = Base64.base64ToByteArray((String)cryptedValue.substring(6));
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update("DWxdHEH7mn1cn0shL+E8d7H".getBytes());
                md.update(propertyBytes, 0, 8);
                int decryptOffset = 8;
                while (decryptOffset < propertyBytes.length) {
                    byte[] cipherBlock = md.digest();
                    int i = cipherBlock.length;
                    while (i-- > 0 && decryptOffset < propertyBytes.length) {
                        int n = decryptOffset++;
                        propertyBytes[n] = (byte)(propertyBytes[n] ^ cipherBlock[i]);
                    }
                    if (decryptOffset >= propertyBytes.length) continue;
                    md.update(cipherBlock);
                }
                cryptedValue = new String(propertyBytes, 8, propertyBytes.length - 8);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Crypted property, but no algorighm");
            }
        }
        return cryptedValue;
    }

    public boolean isAccessible() {
        return true;
    }

    public void putPreference(String storeName, String preferenceKey, boolean value) {
        if (storeName == null || preferenceKey == null) {
            throw new IllegalArgumentException("Could not store preference. Either preference key or store name is null.");
        }
        Map regStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        PreferenceStore aStore = (PreferenceStore)regStores.get(storeName);
        if (aStore == null) {
            return;
        }
        PreferenceChangeEvent evt = null;
        if (this.shouldFirePreferenceChanged()) {
            evt = new PreferenceChangeEvent(this, preferenceKey, new Boolean(aStore.getPreferenceAsBoolean(preferenceKey, false)), new Boolean(value));
        }
        aStore.putPreference(preferenceKey, value);
        this.firePreferenceChanged(evt);
    }

    public void putPreference(String storeName, String preferenceKey, int value) {
        if (storeName == null || preferenceKey == null) {
            throw new IllegalArgumentException("Could not store preference. Either preference key or store name is null.");
        }
        Map regStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        PreferenceStore aStore = (PreferenceStore)regStores.get(storeName);
        if (aStore == null) {
            return;
        }
        PreferenceChangeEvent evt = null;
        if (this.shouldFirePreferenceChanged()) {
            evt = new PreferenceChangeEvent(this, preferenceKey, new Integer(aStore.getPreferenceAsInt(preferenceKey, Integer.MIN_VALUE)), new Integer(value));
        }
        aStore.putPreference(preferenceKey, value);
        this.firePreferenceChanged(evt);
    }

    public void putPreference(String storeName, String preferenceKey, long value) {
        if (storeName == null || preferenceKey == null) {
            throw new IllegalArgumentException("Could not store preference. Either preference key or store name is null.");
        }
        Map regStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        PreferenceStore aStore = (PreferenceStore)regStores.get(storeName);
        if (aStore == null) {
            return;
        }
        PreferenceChangeEvent evt = null;
        if (this.shouldFirePreferenceChanged()) {
            evt = new PreferenceChangeEvent(this, preferenceKey, new Long(aStore.getPreferenceAsLong(preferenceKey, Long.MIN_VALUE)), new Long(value));
        }
        aStore.putPreference(preferenceKey, value);
        this.firePreferenceChanged(evt);
    }

    public void putPreference(String storeName, String preferenceKey, double value) {
        if (storeName == null || preferenceKey == null) {
            throw new IllegalArgumentException("Could not store preference. Either preference key or store name is null.");
        }
        Map regStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        PreferenceStore aStore = (PreferenceStore)regStores.get(storeName);
        if (aStore == null) {
            return;
        }
        PreferenceChangeEvent evt = null;
        if (this.shouldFirePreferenceChanged()) {
            evt = new PreferenceChangeEvent(this, preferenceKey, new Double(aStore.getPreferenceAsDouble(preferenceKey, Double.NaN)), new Double(value));
        }
        aStore.putPreference(preferenceKey, value);
        this.firePreferenceChanged(evt);
    }

    public void putPreference(String storeName, String preferenceKey, float value) {
        if (storeName == null || preferenceKey == null) {
            throw new IllegalArgumentException("Could not store preference. Either preference key or store name is null.");
        }
        Map regStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        PreferenceStore aStore = (PreferenceStore)regStores.get(storeName);
        if (aStore == null) {
            return;
        }
        PreferenceChangeEvent evt = null;
        if (this.shouldFirePreferenceChanged()) {
            evt = new PreferenceChangeEvent(this, preferenceKey, new Float(aStore.getPreferenceAsFloat(preferenceKey, Float.NaN)), new Float(value));
        }
        aStore.putPreference(preferenceKey, value);
        this.firePreferenceChanged(evt);
    }

    public void putPreference(String storeName, String preferenceKey, Object value) {
        if (storeName == null || preferenceKey == null) {
            throw new IllegalArgumentException("Could not store preference. Either preference key or store name is null.");
        }
        Map regStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        PreferenceStore aStore = (PreferenceStore)regStores.get(storeName);
        if (aStore == null) {
            return;
        }
        PreferenceChangeEvent evt = null;
        if (this.shouldFirePreferenceChanged()) {
            evt = new PreferenceChangeEvent(this, preferenceKey, aStore.getPreference(preferenceKey, null), value);
        }
        aStore.putPreference(preferenceKey, value);
        this.firePreferenceChanged(evt);
    }

    public void removePreference(String storeName, String preferenceKey) {
        if (storeName == null || preferenceKey == null) {
            throw new IllegalArgumentException("Could not remove preference. Either preference key or store name is null.");
        }
        Map regStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        PreferenceStore aStore = (PreferenceStore)regStores.get(storeName);
        if (aStore == null) {
            return;
        }
        aStore.removePreference(preferenceKey);
    }

    public Object getWildcardPreference(String preferenceKey) {
        return this.getWildcardPreference(null, preferenceKey, null);
    }

    public Object getWildcardPreference(String preferenceKey, Object defaultValue) {
        return this.getWildcardPreference(null, preferenceKey, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWildcardPreference(String storeName, String preferenceKey, Object defaultValue) {
        if (preferenceKey == null) {
            return defaultValue;
        }
        if (storeName == null) {
            Object preference = null;
            Collection allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().values();
            Map map = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
            synchronized (map) {
                Iterator it = allStores.iterator();
                while (it.hasNext() && preference == null) {
                    PreferenceStore aStore = (PreferenceStore)it.next();
                    if (!(aStore instanceof WildcardPreferenceStore)) continue;
                    preference = ((WildcardPreferenceStore)aStore).getWildcardPreference(preferenceKey, defaultValue);
                }
            }
            return preference == null ? defaultValue : preference;
        }
        PreferenceStore aStore = (PreferenceStore)this.getRegisteredPreferenceStores().get(storeName);
        if (aStore == null || !(aStore instanceof WildcardPreferenceStore)) {
            return defaultValue;
        }
        return ((WildcardPreferenceStore)aStore).getWildcardPreference(preferenceKey, defaultValue);
    }

    public void putPreference(String preferenceKey, long value) {
    }

    public void putPreference(String preferenceKey, double value) {
    }

    public void putPreference(String preferenceKey, float value) {
    }

    public void putPreference(String preferenceKey, boolean value) {
    }

    public void putPreference(String preferenceKey, int value) {
    }

    public void putPreference(String preferenceKey, Object value) {
    }

    public void removePreference(String preferenceKey) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            if (!this.containsPreferenceChangeListener(listener)) {
                this.listenerList.add(PreferenceChangeListener.class, listener);
            }
        }
    }

    private boolean containsPreferenceChangeListener(PreferenceChangeListener l) {
        if (l == null || this.listenerList == null) {
            return false;
        }
        EventListener[] registeredListeners = this.listenerList.getListeners(PreferenceChangeListener.class);
        boolean contained = false;
        for (int i = 0; !contained && i < registeredListeners.length; ++i) {
            contained = l.equals(registeredListeners[i]);
        }
        return contained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
        if (listener == null || this.listenerList == null) {
            return;
        }
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            if (this.containsPreferenceChangeListener(listener)) {
                this.listenerList.remove(PreferenceChangeListener.class, listener);
            }
        }
    }

    private boolean shouldFirePreferenceChanged() {
        return this.listenerList != null && this.listenerList.getListenerCount() > 0;
    }

    private synchronized void firePreferenceChanged(PreferenceChangeEvent evt) {
        if (this.listenerList == null || evt == null) {
            return;
        }
        EventListener[] registeredListeners = this.listenerList.getListeners(PreferenceChangeListener.class);
        for (int i = 0; i < registeredListeners.length; ++i) {
            ((PreferenceChangeListener)registeredListeners[i]).preferenceChange(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Collection allStores = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores().values();
        Map map = PreferenceStoreHolder.getInstance().getRegisteredPreferenceStores();
        synchronized (map) {
            Iterator it = allStores.iterator();
            while (it.hasNext()) {
                ((PreferenceStore)it.next()).flush();
            }
        }
    }
}

