/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.preferences;

import com.levigo.util.configuration.PropertiesConfigurationImpl;
import com.levigo.util.preferences.WildcardPreferenceStore;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesPreferenceStore
extends PropertiesConfigurationImpl
implements WildcardPreferenceStore {
    public PropertiesPreferenceStore() {
    }

    public PropertiesPreferenceStore(String preferenceName) {
        this(preferenceName, null);
    }

    public PropertiesPreferenceStore(String preferenceName, Class loaderclass) {
        this();
        try {
            this.load(preferenceName, loaderclass == null ? this.getClass() : loaderclass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PropertiesPreferenceStore(InputStream propertyInputStream) {
        this();
        try {
            this.load(propertyInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PropertiesPreferenceStore(Properties properties) {
        this();
        if (properties != null) {
            Enumeration<Object> en = properties.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                this.put(key, properties.getProperty(key));
            }
        }
    }

    public Object getPreference(String preferenceKey, Object defaultValue) {
        String result = this.getProperty(preferenceKey);
        return result == null ? defaultValue : result;
    }

    public String getPreferenceAsString(String preferenceKey, String defaultValue) {
        return (String)this.getPreference(preferenceKey, defaultValue);
    }

    public int getPreferenceAsInt(String preferenceKey, int defaultValue) {
        int result = defaultValue;
        try {
            result = Integer.decode(this.trimProperty(this.getProperty(preferenceKey)));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return result;
    }

    public long getPreferenceAsLong(String preferenceKey, long defaultValue) {
        long result = defaultValue;
        try {
            result = Long.decode(this.trimProperty(this.getProperty(preferenceKey)));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return result;
    }

    public double getPreferenceAsDouble(String preferenceKey, double defaultValue) {
        double result = defaultValue;
        try {
            result = Double.parseDouble(this.trimProperty(this.getProperty(preferenceKey)));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return result;
    }

    public float getPreferenceAsFloat(String preferenceKey, float defaultValue) {
        float result = defaultValue;
        try {
            result = Float.parseFloat(this.trimProperty(this.getProperty(preferenceKey)));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return result;
    }

    public boolean getPreferenceAsBoolean(String preferenceKey, boolean defaultValue) {
        String prop = this.trimProperty(this.getProperty(preferenceKey));
        return prop != null ? Boolean.valueOf(prop) : defaultValue;
    }

    public void putPreference(String preferenceKey, Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Properties supports only String values !! Tried to store Object of type " + (value == null ? "no Class defined" : value.getClass().getName()));
        }
        this.setProperty(preferenceKey, (String)value);
    }

    public void putPreference(String preferenceKey, int value) {
        this.putPreference(preferenceKey, "" + value);
    }

    public void putPreference(String preferenceKey, long value) {
        this.putPreference(preferenceKey, "" + value);
    }

    public void putPreference(String preferenceKey, double value) {
        this.putPreference(preferenceKey, "" + value);
    }

    public void putPreference(String preferenceKey, float value) {
        this.putPreference(preferenceKey, "" + value);
    }

    public void putPreference(String preferenceKey, boolean value) {
        this.putPreference(preferenceKey, "" + value);
    }

    public void removePreference(String preferenceKey) {
        this.remove(preferenceKey);
    }

    public boolean isAccessible() {
        return true;
    }

    private boolean matchesWildcardKey(String testKey, String searchKey) {
        if (testKey.length() != searchKey.length()) {
            return false;
        }
        boolean match = true;
        int len = testKey.length();
        for (int i = 0; match && i < len; ++i) {
            char test = testKey.charAt(i);
            if (test == '?') continue;
            match = test == searchKey.charAt(i);
        }
        return match;
    }

    public Object getWildcardPreference(String preferenceKey) {
        return this.getWildcardPreference(preferenceKey, null);
    }

    public Object getWildcardPreference(String preferenceKey, Object defaultValue) {
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String testKey = (String)e.nextElement();
            if (!this.matchesWildcardKey(testKey, preferenceKey)) continue;
            return this.getPreference(testKey, defaultValue);
        }
        return defaultValue;
    }

    private String trimProperty(String value) {
        if (value == null) {
            return value;
        }
        return value.trim();
    }

    public void flush() {
    }
}

