/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.common.home.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.openthinclient.service.common.home.ManagerHome;

public class ApplianceConfiguration {
    private static final ApplianceConfiguration DISABLED = new ApplianceConfiguration();
    private final boolean enabled;
    private final Properties properties;

    public ApplianceConfiguration() {
        this.enabled = false;
        this.properties = new Properties();
    }

    public ApplianceConfiguration(Properties properties) {
        this.properties = properties;
        this.enabled = true;
    }

    public static ApplianceConfiguration get(ManagerHome managerHome) throws IOException {
        Path applianceConfigurationFile = managerHome.getLocation().toPath().resolve(".appliance.properties");
        if (Files.exists(applianceConfigurationFile, new LinkOption[0]) && Files.isRegularFile(applianceConfigurationFile, new LinkOption[0])) {
            Properties properties = new Properties();
            try (InputStream in = Files.newInputStream(applianceConfigurationFile, new OpenOption[0]);){
                properties.load(in);
            }
            return new ApplianceConfiguration(properties);
        }
        return DISABLED;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getNoVNCConsoleHostname() {
        return this.properties.getProperty("novnc.server.host");
    }

    public Integer getNoVNCConsolePort() {
        return Integer.valueOf(this.properties.getProperty("novnc.server.port", "5900"));
    }

    public boolean isNoVNCConsoleEncrypted() {
        return Boolean.valueOf(this.properties.getProperty("novnc.server.encrypt", "false"));
    }

    public boolean isNoVNCConsoleAutoconnect() {
        return Boolean.valueOf(this.properties.getProperty("novnc.server.autoconnect", "true"));
    }

    public boolean isNoVNCConsoleAllowfullscreen() {
        return Boolean.valueOf(this.properties.getProperty("novnc.server.allowfullscreen", "true"));
    }

    public int getNoVNCTicketExpirySeconds() {
        return Integer.valueOf(this.properties.getProperty("novnc.server.ticketExpirySeconds", "120"));
    }
}

