/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.common.home.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.openthinclient.service.common.home.Configuration;
import org.openthinclient.service.common.home.ConfigurationDirectory;
import org.openthinclient.service.common.home.ConfigurationFile;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.ManagerHomeMetadata;
import org.openthinclient.service.common.home.impl.XMLManagerHomeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagerHome
implements ManagerHome {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagerHome.class);
    private final Map<Class<? extends Configuration>, Configuration> configurations;
    private final File managerHomeDirectory;
    private final ManagerHomeMetadata managerHomeMetadata;

    public DefaultManagerHome(File managerHomeDirectory) {
        this.managerHomeDirectory = managerHomeDirectory;
        LOG.info("Using manager home: " + managerHomeDirectory.getAbsolutePath());
        this.configurations = new HashMap<Class<? extends Configuration>, Configuration>();
        if (XMLManagerHomeMetadata.exists(managerHomeDirectory.toPath())) {
            try {
                this.managerHomeMetadata = XMLManagerHomeMetadata.read(managerHomeDirectory.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read manager home metadata", e);
            }
        } else {
            this.managerHomeMetadata = XMLManagerHomeMetadata.create(managerHomeDirectory.toPath());
        }
    }

    @Override
    public ManagerHomeMetadata getMetadata() {
        return this.managerHomeMetadata;
    }

    @Override
    public synchronized <T extends Configuration> T getConfiguration(Class<T> configurationClass) {
        Configuration configuration = this.configurations.get(configurationClass);
        if (configuration == null) {
            Configuration instance;
            File file = this.getConfigurationFile(configurationClass);
            LOG.info("loading " + configurationClass.getSimpleName() + ": " + file.getAbsolutePath());
            if (file.exists()) {
                instance = (Configuration)JAXB.unmarshal((File)file, configurationClass);
                LOG.info(configurationClass.getSimpleName() + " read successfully");
            } else {
                try {
                    instance = (Configuration)configurationClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Failed to create configuration class instance", e);
                }
                LOG.info("new " + configurationClass.getSimpleName() + " instance created with defaults");
            }
            this.initializeConfigurationFiles(instance);
            this.configurations.put(configurationClass, instance);
            return (T)instance;
        }
        return (T)configuration;
    }

    private void initializeConfigurationFiles(Configuration configuration) {
        for (Field field : configuration.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                String message;
                ConfigurationFile configurationFileAnnotation = field.getAnnotation(ConfigurationFile.class);
                ConfigurationDirectory configurationDirectoryAnnotation = field.getAnnotation(ConfigurationDirectory.class);
                if (configurationFileAnnotation != null) {
                    File configurationFile = this.getConfigurationFile(configuration.getClass(), configurationFileAnnotation);
                    field.set(configuration, configurationFile);
                    message = "configuration [FILE]: " + configuration.getClass().getSimpleName() + "." + field.getName() + ": " + configurationFile.getAbsolutePath();
                    if (!configurationFile.getParentFile().exists() && !configurationFile.getParentFile().mkdirs()) {
                        LOG.error(message + " [FAIL]");
                        continue;
                    }
                    LOG.info(message + " [OK]");
                    continue;
                }
                if (configurationDirectoryAnnotation == null) continue;
                File configurationDirectory = this.getConfigurationDirectory(configuration.getClass(), configurationDirectoryAnnotation);
                field.set(configuration, configurationDirectory);
                message = "configuration [DIR]: " + configuration.getClass().getSimpleName() + "." + field.getName() + ": " + configurationDirectory.getAbsolutePath();
                if (!configurationDirectory.exists() && !configurationDirectory.mkdirs()) {
                    LOG.error(message + " [FAIL]");
                    continue;
                }
                LOG.info(message + " [OK]");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to initialize configuration", e);
            }
        }
    }

    @Override
    public File getConfigurationFile(Class<? extends Configuration> configurationClass) {
        File file = this.constructConfigurationFile(configurationClass);
        if (file.exists() && !file.isFile()) {
            throw new IllegalArgumentException("the configuration target location " + file.getAbsolutePath() + " is not a file");
        }
        return file;
    }

    private File constructConfigurationFile(Class<? extends Configuration> configurationClass) {
        ConfigurationFile path = configurationClass.getAnnotation(ConfigurationFile.class);
        if (path == null) {
            throw new IllegalArgumentException("The provided configuration class " + configurationClass + " does not define a @" + ConfigurationFile.class.getSimpleName() + " annotation.");
        }
        return new File(this.managerHomeDirectory, path.value());
    }

    @Override
    public File getConfigurationDirectory(Class<? extends Configuration> configurationClass, ConfigurationDirectory relativeConfigurationDirectory) {
        File configurationFile = this.constructConfigurationFile(configurationClass);
        File directory = new File(configurationFile.getParentFile(), relativeConfigurationDirectory.value());
        if (directory.exists() && !directory.isDirectory()) {
            throw new IllegalArgumentException("Expected directory: " + directory.getAbsolutePath());
        }
        directory.mkdirs();
        return directory;
    }

    @Override
    public File getConfigurationFile(Class<? extends Configuration> configurationClass, ConfigurationFile relativeConfigurationPath) {
        File configurationFile = this.constructConfigurationFile(configurationClass);
        File file = new File(configurationFile.getParentFile(), relativeConfigurationPath.value());
        if (file.exists() && !file.isFile()) {
            throw new IllegalArgumentException("Expected file: " + file.getAbsolutePath());
        }
        return file;
    }

    @Override
    public synchronized void save(Class<? extends Configuration> configurationClass) {
        if (configurationClass == null) {
            throw new IllegalArgumentException("configurationClass must not be null");
        }
        File configurationFile = this.getConfigurationFile(configurationClass);
        configurationFile.getParentFile().mkdirs();
        JAXB.marshal((Object)this.configurations.get(configurationClass), (File)configurationFile);
    }

    @Override
    public synchronized void saveAll() {
        this.managerHomeMetadata.save();
        this.configurations.keySet().forEach(this::save);
    }

    @Override
    public File getLocation() {
        return this.managerHomeDirectory;
    }
}

