/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.common.home.impl;

import java.io.File;
import org.openthinclient.manager.util.installation.InstallationDirectoryUtil;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.impl.DefaultManagerHome;

public class ManagerHomeFactory {
    private File managerHomeDirectory;

    public boolean isManagerHomeDefinedAsSystemProperty() {
        return this.getManagerHomeSystemProperty() != null;
    }

    private String getManagerHomeSystemProperty() {
        return System.getProperty("manager.home");
    }

    public boolean isManagerHomeValidAndInstalled() {
        File managerHomeDirectory = this.getManagerHomeDirectory();
        if (managerHomeDirectory == null) {
            return false;
        }
        return !InstallationDirectoryUtil.isInstallationDirectoryEmpty((File)managerHomeDirectory) && !InstallationDirectoryUtil.existsInstallationProgressFile((File)managerHomeDirectory);
    }

    public File getManagerHomeDirectory() {
        if (this.managerHomeDirectory != null) {
            return this.managerHomeDirectory;
        }
        String value = this.getManagerHomeSystemProperty();
        if (value != null && value.trim().length() > 0) {
            return new File(value);
        }
        return null;
    }

    public void setManagerHomeDirectory(File baseDirectory) {
        if (baseDirectory == null) {
            throw new IllegalArgumentException("baseDirectory must not be null");
        }
        this.managerHomeDirectory = baseDirectory;
    }

    public ManagerHome create() {
        File managerHomeDirectory = this.getManagerHomeDirectory();
        if (managerHomeDirectory == null) {
            throw new IllegalStateException("No manager home directory has been specified");
        }
        return new DefaultManagerHome(managerHomeDirectory);
    }
}

