/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.common.home.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openthinclient.service.common.home.ManagerHomeMetadata;

@XmlRootElement(name="manager-home-metadata", namespace="http://www.openthinclient.org/ns/manager/metadata/1.0")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XMLManagerHomeMetadata
implements ManagerHomeMetadata {
    public static final String FILENAME = ".otc-manager-home.meta";
    public static final String NAMESPACE = "http://www.openthinclient.org/ns/manager/metadata/1.0";
    @XmlAttribute(name="home-schema-version")
    private int homeSchemaVersion = 1;
    @XmlElement(name="server-id")
    private String serverId;
    @XmlTransient
    private Path metaFile;

    public static boolean exists(Path managerHome) {
        Path metaFile = managerHome.resolve(FILENAME);
        return Files.exists(metaFile, new LinkOption[0]) && Files.isRegularFile(metaFile, new LinkOption[0]);
    }

    public static XMLManagerHomeMetadata read(Path managerHome) throws IOException {
        Path metaFile = managerHome.resolve(FILENAME);
        XMLManagerHomeMetadata xmlManagerHomeMetadata = (XMLManagerHomeMetadata)JAXB.unmarshal((InputStream)Files.newInputStream(metaFile, new OpenOption[0]), XMLManagerHomeMetadata.class);
        xmlManagerHomeMetadata.metaFile = metaFile;
        return xmlManagerHomeMetadata;
    }

    public static XMLManagerHomeMetadata create(Path managerHome) {
        XMLManagerHomeMetadata xmlManagerHomeMetadata = new XMLManagerHomeMetadata();
        xmlManagerHomeMetadata.metaFile = managerHome.resolve(FILENAME);
        return xmlManagerHomeMetadata;
    }

    @Override
    public String getServerID() {
        return this.serverId;
    }

    @Override
    public void setServerID(String id) {
        this.serverId = id;
    }

    public int getHomeSchemaVersion() {
        return this.homeSchemaVersion;
    }

    public void setHomeSchemaVersion(int homeSchemaVersion) {
        this.homeSchemaVersion = homeSchemaVersion;
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.serverId != null) {
            this.serverId = this.serverId.trim();
        }
    }

    @Override
    public synchronized void save() {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{XMLManagerHomeMetadata.class});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)this, Files.newOutputStream(this.metaFile, new OpenOption[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write metadata", e);
        }
    }
}

