/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.sidebar.components;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import java.util.Collection;
import org.vaadin.spring.sidebar.SideBarItemDescriptor;
import org.vaadin.spring.sidebar.SideBarSectionDescriptor;
import org.vaadin.spring.sidebar.SideBarUtils;
import org.vaadin.spring.sidebar.components.AbstractSideBar;

public class ValoSideBar
extends AbstractSideBar<CssLayout> {
    private Layout headerLayout;
    private Component logo;
    private boolean largeIcons = false;

    public ValoSideBar(SideBarUtils sideBarUtils) {
        super(sideBarUtils);
        this.setPrimaryStyleName("valo-menu");
        this.setSizeUndefined();
    }

    @Override
    protected CssLayout createCompositionRoot() {
        CssLayout layout = new CssLayout();
        layout.addStyleName("valo-menu-part");
        if (this.largeIcons) {
            layout.addStyleName("large-icons");
        }
        layout.setWidth(null);
        layout.setHeight("100%");
        if (this.logo != null) {
            layout.addComponent(this.logo);
        }
        if (this.headerLayout != null) {
            layout.addComponent((Component)this.headerLayout);
        }
        return layout;
    }

    public boolean isLargeIcons() {
        return this.largeIcons;
    }

    public void setLargeIcons(boolean largeIcons) {
        this.largeIcons = largeIcons;
        if (this.getCompositionRoot() != null) {
            if (largeIcons) {
                ((CssLayout)this.getCompositionRoot()).addStyleName("large-icons");
            } else {
                ((CssLayout)this.getCompositionRoot()).removeStyleName("large-icons");
            }
        }
    }

    public void setHeader(Layout headerLayout) {
        if (this.getCompositionRoot() != null && this.headerLayout != null) {
            ((CssLayout)this.getCompositionRoot()).removeComponent((Component)this.headerLayout);
        }
        this.headerLayout = headerLayout;
        if (headerLayout != null) {
            headerLayout.addStyleName("valo-menu-title");
            if (this.getCompositionRoot() != null) {
                if (this.logo != null) {
                    ((CssLayout)this.getCompositionRoot()).addComponent((Component)headerLayout, 1);
                } else {
                    ((CssLayout)this.getCompositionRoot()).addComponentAsFirst((Component)headerLayout);
                }
            }
        }
    }

    public Layout getHeader() {
        return this.headerLayout;
    }

    public void setLogo(Component logo) {
        if (this.getCompositionRoot() != null && this.logo != null) {
            ((CssLayout)this.getCompositionRoot()).removeComponent(this.logo);
        }
        this.logo = logo;
        if (logo != null) {
            logo.setPrimaryStyleName("valo-menu-logo");
            logo.setSizeUndefined();
            if (this.getCompositionRoot() != null) {
                ((CssLayout)this.getCompositionRoot()).addComponentAsFirst(logo);
            }
        }
    }

    public Component getLogo() {
        return this.logo;
    }

    @Override
    protected AbstractSideBar.SectionComponentFactory<CssLayout> createDefaultSectionComponentFactory() {
        return new DefaultSectionComponentFactory();
    }

    @Override
    protected AbstractSideBar.ItemComponentFactory createDefaultItemComponentFactory() {
        return new DefaultItemComponentFactory();
    }

    public class DefaultItemComponentFactory
    implements AbstractSideBar.ItemComponentFactory {
        @Override
        public Component createItemComponent(SideBarItemDescriptor descriptor) {
            if (descriptor instanceof SideBarItemDescriptor.ViewItemDescriptor) {
                return new ViewItemButton((SideBarItemDescriptor.ViewItemDescriptor)descriptor);
            }
            return new ItemButton(descriptor);
        }
    }

    public class DefaultSectionComponentFactory
    implements AbstractSideBar.SectionComponentFactory<CssLayout> {
        private AbstractSideBar.ItemComponentFactory itemComponentFactory;

        @Override
        public void setItemComponentFactory(AbstractSideBar.ItemComponentFactory itemComponentFactory) {
            this.itemComponentFactory = itemComponentFactory;
        }

        @Override
        public void createSection(CssLayout compositionRoot, SideBarSectionDescriptor descriptor, Collection<SideBarItemDescriptor> itemDescriptors) {
            Label header = new Label();
            header.setValue(descriptor.getCaption());
            header.setSizeUndefined();
            header.setPrimaryStyleName("valo-menu-subtitle");
            compositionRoot.addComponent((Component)header);
            for (SideBarItemDescriptor item : itemDescriptors) {
                compositionRoot.addComponent(this.itemComponentFactory.createItemComponent(item));
            }
        }
    }

    static class ViewItemButton
    extends ItemButton
    implements ViewChangeListener {
        private final String viewName;
        private static final String STYLE_SELECTED = "selected";

        ViewItemButton(SideBarItemDescriptor.ViewItemDescriptor descriptor) {
            super(descriptor);
            this.viewName = descriptor.getViewName();
        }

        public void attach() {
            super.attach();
            if (this.getUI().getNavigator() == null) {
                throw new IllegalStateException("Please configure the Navigator before you attach the SideBar to the UI");
            }
            this.getUI().getNavigator().addViewChangeListener((ViewChangeListener)this);
        }

        public void detach() {
            this.getUI().getNavigator().removeViewChangeListener((ViewChangeListener)this);
            super.detach();
        }

        public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
            return true;
        }

        public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
            if (event.getViewName().equals(this.viewName)) {
                this.addStyleName(STYLE_SELECTED);
            } else {
                this.removeStyleName(STYLE_SELECTED);
            }
        }
    }

    static class ItemButton
    extends Button {
        ItemButton(final SideBarItemDescriptor descriptor) {
            this.setPrimaryStyleName("valo-menu-item");
            this.setCaption(descriptor.getCaption());
            this.setIcon(descriptor.getIcon());
            this.setId(descriptor.getItemId());
            this.setDisableOnClick(true);
            this.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = -8512905888847432801L;

                public void buttonClick(Button.ClickEvent event) {
                    try {
                        descriptor.itemInvoked(this.getUI());
                    }
                    finally {
                        this.setEnabled(true);
                    }
                }
            });
        }
    }
}

