/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.ErrorManager;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;

public abstract class Children {
    static final Mutex.Privileged PR = new Mutex.Privileged();
    public static final Mutex MUTEX = new Mutex(PR);
    public static final Children LEAF = new Empty();
    private static final Object LOCK = new Object();
    private static final ErrorManager LOG_GET_ARRAY = ErrorManager.getDefault().getInstance("org.openide.nodes.Children.getArray");
    private static final boolean IS_LOG_GET_ARRAY = LOG_GET_ARRAY.isLoggable(1);
    private Node parent;
    private java.util.Map map;
    private Collection entries = Collections.EMPTY_LIST;
    Reference array = new WeakReference<Object>(null);
    private Thread initThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void attachTo(Node node) throws IllegalStateException {
        if (this == LEAF) {
            return;
        }
        Node[] nodeArray = this;
        synchronized (this) {
            if (this.parent != null) {
                throw new IllegalStateException("An instance of Children may not be used for more than one parent node.");
            }
            this.parent = node;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                PR.enterReadAccess();
                nodeArray = this.testNodes();
                if (nodeArray == null) {
                    return;
                }
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = nodeArray[i];
                    node2.assignTo((Children)this, i);
                    node2.fireParentNodeChange(null, this.parent);
                }
            }
            finally {
                PR.exitReadAccess();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detachFrom() {
        if (this == LEAF) {
            return;
        }
        Node node = null;
        Node[] nodeArray = this;
        synchronized (this) {
            if (this.parent == null) {
                throw new IllegalStateException("Trying to detach children which do not have parent");
            }
            node = this.parent;
            this.parent = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                PR.enterReadAccess();
                nodeArray = this.testNodes();
                if (nodeArray == null) {
                    return;
                }
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = nodeArray[i];
                    node2.deassignFrom((Children)this);
                    node2.fireParentNodeChange(node, null);
                }
            }
            finally {
                PR.exitReadAccess();
            }
            return;
        }
    }

    protected final Node getNode() {
        return this.parent;
    }

    final Object cloneHierarchy() throws CloneNotSupportedException {
        return this.clone();
    }

    protected Object clone() throws CloneNotSupportedException {
        Children children = (Children)super.clone();
        children.parent = null;
        children.map = null;
        children.entries = Collections.EMPTY_LIST;
        children.array = new WeakReference<Object>(null);
        return children;
    }

    public abstract boolean add(Node[] var1);

    public abstract boolean remove(Node[] var1);

    public final Enumeration nodes() {
        return Enumerations.array((Object[])this.getNodes());
    }

    public Node findChild(String string) {
        Node[] nodeArray = this.getNodes();
        if (nodeArray.length == 0) {
            return null;
        }
        if (string == null) {
            return nodeArray[0];
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!string.equals(nodeArray[i].getName())) continue;
            return nodeArray[i];
        }
        return null;
    }

    protected final boolean isInitialized() {
        ChildrenArray childrenArray = (ChildrenArray)this.array.get();
        return childrenArray != null && childrenArray.isInitialized();
    }

    final Node getNodeAt(int n) {
        return this.getNodes()[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node[] getNodes() {
        Node[] nodeArray;
        boolean[] blArray = new boolean[2];
        do {
            blArray[1] = this.isInitialized();
            ChildrenArray childrenArray = this.getArray(blArray);
            try {
                PR.enterReadAccess();
                nodeArray = childrenArray.nodes();
            }
            finally {
                PR.exitReadAccess();
            }
            if (!blArray[1]) continue;
            return nodeArray;
        } while (!blArray[0]);
        return nodeArray == null ? new Node[]{} : nodeArray;
    }

    public Node[] getNodes(boolean bl) {
        if (bl) {
            ChildrenArray childrenArray = this.getArray(null);
            this.findChild(null);
        }
        return this.getNodes();
    }

    public final int getNodesCount() {
        return this.getNodes().length;
    }

    protected void addNotify() {
    }

    protected void removeNotify() {
    }

    void callAddNotify() {
        this.addNotify();
    }

    private Node[] testNodes() {
        ChildrenArray childrenArray = (ChildrenArray)this.array.get();
        return childrenArray == null ? null : childrenArray.nodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChildrenArray getArray(boolean[] blArray) {
        ChildrenArray childrenArray;
        boolean bl = false;
        Object object = LOCK;
        synchronized (object) {
            childrenArray = (ChildrenArray)this.array.get();
            if (childrenArray == null) {
                childrenArray = new ChildrenArray();
                this.registerChildrenArray(childrenArray, true);
                bl = true;
                this.initThread = Thread.currentThread();
            }
        }
        if (bl) {
            class SetAndNotify
            implements Runnable {
                public ChildrenArray toSet;
                public Children whatSet;

                SetAndNotify() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = LOCK;
                    synchronized (object) {
                        Children.this.initThread = null;
                        LOCK.notifyAll();
                    }
                    if (IS_LOG_GET_ARRAY) {
                        LOG_GET_ARRAY.log("notifyAll done");
                    }
                }
            }
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.log("Initialize " + this + " on " + Thread.currentThread());
            }
            try {
                this.callAddNotify();
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.log("addNotify successfully called for " + this + " on " + Thread.currentThread());
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                boolean bl2 = MUTEX.isReadAccess();
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.log("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl2);
                }
                childrenArray.children = this;
                SetAndNotify setAndNotify = new SetAndNotify();
                setAndNotify.toSet = childrenArray;
                setAndNotify.whatSet = this;
                if (bl2) {
                    MUTEX.postWriteRequest((Runnable)setAndNotify);
                    throw throwable;
                } else {
                    setAndNotify.run();
                }
                throw throwable;
            }
            boolean bl3 = MUTEX.isReadAccess();
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.log("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl3);
            }
            childrenArray.children = this;
            SetAndNotify setAndNotify = new SetAndNotify();
            setAndNotify.toSet = childrenArray;
            setAndNotify.whatSet = this;
            if (bl3) {
                MUTEX.postWriteRequest((Runnable)setAndNotify);
                return childrenArray;
            }
            setAndNotify.run();
            return childrenArray;
        }
        if (MUTEX.isReadAccess() || this.initThread == Thread.currentThread()) {
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.log("cannot initialize better " + this + " on " + Thread.currentThread() + " read access: " + MUTEX.isReadAccess() + " initThread: " + this.initThread);
            }
            if (blArray == null) return childrenArray;
            blArray[0] = true;
            return childrenArray;
        }
        object = LOCK;
        synchronized (object) {
            while (this.initThread != null) {
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.log("waiting for children for " + this + " on " + Thread.currentThread());
                }
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!IS_LOG_GET_ARRAY) return childrenArray;
        LOG_GET_ARRAY.log(" children are here for " + this + " on " + Thread.currentThread() + " children " + childrenArray.children);
        return childrenArray;
    }

    private void clearNodes() {
        ChildrenArray childrenArray = (ChildrenArray)this.array.get();
        if (childrenArray != null) {
            childrenArray.clear();
        }
    }

    final void finalizeNodes() {
        ChildrenArray childrenArray = (ChildrenArray)this.array.get();
        if (childrenArray != null) {
            childrenArray.finalizeNodes();
        }
    }

    final void registerChildrenArray(final ChildrenArray childrenArray, boolean bl) {
        if (IS_LOG_GET_ARRAY) {
            LOG_GET_ARRAY.log("registerChildrenArray: " + childrenArray + " weak: " + bl);
        }
        this.array = bl ? new WeakReference<ChildrenArray>(childrenArray) : new WeakReference(childrenArray){

            public Object get() {
                return childrenArray;
            }
        };
        childrenArray.pointedBy(this.array);
        if (IS_LOG_GET_ARRAY) {
            LOG_GET_ARRAY.log("pointed by: " + childrenArray + " to: " + this.array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finalizedChildrenArray(Reference reference) {
        try {
            PR.enterWriteAccess();
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.log("previous array: " + this.array + " caller: " + reference);
            }
            if (this.array == reference) {
                this.removeNotify();
            }
        }
        finally {
            PR.exitWriteAccess();
        }
    }

    final Node[] justComputeNodes() {
        Node[] nodeArray;
        if (this.map == null) {
            this.map = new HashMap(17);
        }
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            nodeArray = (Node[])iterator.next();
            Info info = this.findInfo((Entry)nodeArray);
            try {
                linkedList.addAll(info.nodes());
            }
            catch (RuntimeException runtimeException) {
                NodeOp.warning(runtimeException);
            }
        }
        nodeArray = linkedList.toArray(new Node[linkedList.size()]);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            node.assignTo(this, i);
            node.fireParentNodeChange(null, this.parent);
        }
        return nodeArray;
    }

    private Info findInfo(Entry entry) {
        Info info = (Info)this.map.get(entry);
        if (info == null) {
            info = new Info(entry);
            this.map.put(entry, info);
        }
        return info;
    }

    final ArrayList getEntries() {
        return new ArrayList(this.entries);
    }

    final void setEntries(Collection collection) {
        List list;
        ChildrenArray childrenArray = (ChildrenArray)this.array.get();
        if (IS_LOG_GET_ARRAY) {
            LOG_GET_ARRAY.log("setEntries for " + this + " on " + Thread.currentThread());
            LOG_GET_ARRAY.log("       values: " + collection);
            LOG_GET_ARRAY.log("       holder: " + childrenArray);
        }
        if (childrenArray == null) {
            this.entries = collection;
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet(collection));
            }
            return;
        }
        Node[] nodeArray = childrenArray.nodes();
        if (nodeArray == null) {
            this.entries = collection;
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet(collection));
            }
            return;
        }
        this.map.keySet().retainAll(new HashSet(this.entries));
        HashSet hashSet = new HashSet(this.map.keySet());
        HashSet hashSet2 = new HashSet(collection);
        hashSet.removeAll(hashSet2);
        if (!hashSet.isEmpty()) {
            this.updateRemove(nodeArray, hashSet);
            nodeArray = childrenArray.nodes();
        }
        if (!(list = this.updateOrder(nodeArray, collection)).isEmpty()) {
            this.updateAdd(list, collection);
        }
    }

    private void updateRemove(Node[] nodeArray, Set set) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            Info info = (Info)this.map.remove(entry);
            linkedList.addAll(info.nodes());
        }
        this.entries.removeAll(set);
        this.clearNodes();
        this.notifyRemove(linkedList, nodeArray);
    }

    Node[] notifyRemove(Collection collection, Node[] nodeArray) {
        Node[] nodeArray2 = collection.toArray(new Node[collection.size()]);
        if (this.parent == null) {
            return nodeArray2;
        }
        this.parent.fireSubNodesChange(false, nodeArray2, nodeArray);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.deassignFrom(this);
            node.fireParentNodeChange(this.parent, null);
        }
        return nodeArray2;
    }

    private List updateOrder(Node[] nodeArray, Collection collection) {
        Object object;
        LinkedList<Info> linkedList = new LinkedList<Info>();
        HashMap<Info, Integer> hashMap = new HashMap<Info, Integer>();
        int n = 0;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            object = (Info)this.map.get(entry);
            if (object == null) {
                throw new IllegalStateException("Error in " + this.getClass().getName() + " with entry " + entry + " probably caused by faulty key implementation." + " The key hashCode() and equals() methods must behave as for an IMMUTABLE object" + " and the hashCode() must return the same value for equals() keys.");
            }
            hashMap.put((Info)object, new Integer(n));
            n += ((Info)object).length();
        }
        this.map.keySet().retainAll(new HashSet(this.entries));
        int[] nArray = new int[nodeArray.length];
        int n2 = 0;
        int n3 = 0;
        object = null;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Entry entry = (Entry)iterator2.next();
            Info info = (Info)this.map.get(entry);
            if (info == null) {
                info = new Info(entry);
                linkedList.add(info);
            } else {
                int n4 = info.length();
                if (object == null) {
                    object = new LinkedList();
                }
                ((LinkedList)object).add(entry);
                Integer n5 = (Integer)hashMap.get(info);
                int n6 = n5;
                if (n2 != n6) {
                    for (int i = 0; i < n4; ++i) {
                        nArray[n6 + i] = 1 + n2 + i;
                    }
                    n3 += n4;
                }
            }
            n2 += info.length();
        }
        if (n3 > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) {
                    nArray[i] = i;
                    continue;
                }
                int n7 = i;
                nArray[n7] = nArray[n7] - 1;
            }
            this.entries = object;
            this.clearNodes();
            Node node = this.parent;
            if (node != null) {
                node.fireReorderChange(nArray);
            }
        }
        return linkedList;
    }

    private void updateAdd(Collection collection, Collection collection2) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Info info = (Info)iterator.next();
            linkedList.addAll(info.nodes());
            this.map.put(info.entry, info);
        }
        this.entries = collection2;
        this.clearNodes();
        this.notifyAdd(linkedList);
    }

    private void notifyAdd(Collection collection) {
        Node[] nodeArray;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            nodeArray = (Node[])iterator.next();
            nodeArray.assignTo(this, -1);
            nodeArray.fireParentNodeChange(null, this.parent);
        }
        nodeArray = collection.toArray(new Node[collection.size()]);
        Node node = this.parent;
        if (node != null) {
            node.fireSubNodesChange(true, nodeArray, null);
        }
    }

    final void refreshEntry(Entry entry) {
        Collection collection;
        ChildrenArray childrenArray = (ChildrenArray)this.array.get();
        if (childrenArray == null) {
            return;
        }
        Node[] nodeArray = childrenArray.nodes();
        if (nodeArray == null) {
            return;
        }
        this.map.keySet().retainAll(new HashSet(this.entries));
        Info info = (Info)this.map.get(entry);
        if (info == null) {
            return;
        }
        Collection collection2 = info.nodes();
        if (((Object)collection2).equals(collection = info.entry.nodes())) {
            return;
        }
        HashSet hashSet = new HashSet(collection2);
        hashSet.removeAll(collection);
        if (!hashSet.isEmpty()) {
            collection2.removeAll(hashSet);
            this.clearNodes();
            this.notifyRemove(hashSet, nodeArray);
            nodeArray = childrenArray.nodes();
        }
        List list = this.refreshOrder(entry, collection2, collection);
        info.useNodes(collection);
        if (!list.isEmpty()) {
            this.clearNodes();
            this.notifyAdd(list);
        }
    }

    private List refreshOrder(Entry entry, Collection collection, Collection collection2) {
        Object object;
        Object object2;
        Object object3;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n = 0;
        Iterator iterator = this.entries.iterator();
        while (!(object3 = (Entry)iterator.next()).equals(entry)) {
            object2 = this.findInfo((Entry)object3);
            n += ((Info)object2).length();
        }
        object3 = new HashSet(collection);
        object2 = (HashSet)((HashSet)object3).clone();
        Node[] nodeArray = new Node[collection.size()];
        iterator = collection2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = (Node)iterator.next();
            if (((HashSet)object3).remove(object)) {
                nodeArray[n2++] = object;
                continue;
            }
            if (!((HashSet)object2).contains(object)) {
                linkedList.add(object);
                continue;
            }
            iterator.remove();
        }
        object = NodeOp.computePermutation(collection.toArray(new Node[collection.size()]), nodeArray);
        if (object != null) {
            this.clearNodes();
            this.findInfo(entry).useNodes(Arrays.asList(nodeArray));
            Node node = this.parent;
            if (node != null) {
                node.fireReorderChange((int[])object);
            }
        }
        return linkedList;
    }

    private static class Dupl
    implements Cloneable {
        protected Object key;

        Dupl() {
        }

        public final void updateList(Collection collection, Collection collection2) {
            HashMap hashMap = new HashMap(collection.size() * 2);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.updateListAndMap(e, collection2, hashMap);
            }
        }

        public final void updateList(Object[] objectArray, Collection collection) {
            HashMap hashMap = new HashMap(objectArray.length * 2);
            for (int i = 0; i < objectArray.length; ++i) {
                this.updateListAndMap(objectArray[i], collection, hashMap);
            }
        }

        public final void updateListAndMap(Object object, Collection collection, java.util.Map map) {
            Dupl dupl = map.put(object, this);
            if (dupl == null) {
                collection.add(this.createInstance(object, 0));
                return;
            }
            if (dupl == this) {
                map.put(object, new Integer(1));
                collection.add(this.createInstance(object, 1));
                return;
            }
            int n = (Integer)((Object)dupl) + 1;
            map.put(object, new Integer(n));
            collection.add(this.createInstance(object, n));
        }

        public final Object getKey() {
            if (this.key instanceof Dupl) {
                return ((Dupl)this.key).getKey();
            }
            return this.key;
        }

        public final int getCnt() {
            int n = 0;
            Dupl dupl = this;
            while (dupl.key instanceof Dupl) {
                dupl = (Dupl)dupl.key;
                ++n;
            }
            return n;
        }

        private final Dupl createInstance(Object object, int n) {
            try {
                Dupl dupl;
                Dupl dupl2 = dupl = (Dupl)this.clone();
                while (n-- > 0) {
                    Dupl dupl3 = (Dupl)this.clone();
                    dupl.key = dupl3;
                    dupl = dupl3;
                }
                dupl.key = object;
                return dupl2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Dupl) {
                Dupl dupl = (Dupl)object;
                return this.getKey().equals(dupl.getKey()) && this.getCnt() == dupl.getCnt();
            }
            return false;
        }

        public String toString() {
            String string = this.getKey().toString();
            if (string.length() > 80) {
                string = string.substring(0, 80);
            }
            return "Key (" + string + ", " + this.getCnt() + ")";
        }
    }

    public static abstract class Keys
    extends Array {
        private static HashMap lastRuns = new HashMap(11);
        private boolean before;

        public Keys() {
        }

        Keys(int n, int n2) {
            this();
        }

        public Object clone() {
            Keys keys = (Keys)super.clone();
            return keys;
        }

        public boolean add(Node[] nodeArray) {
            return super.add(nodeArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Node[] nodeArray) {
            try {
                PR.enterWriteAccess();
                if (this.nodes != null) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        if (this.nodes.contains(nodeArray[i])) continue;
                        nodeArray[i] = null;
                    }
                    this.superRemove(nodeArray);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
            return true;
        }

        final void superRemove(Node[] nodeArray) {
            super.remove(nodeArray);
        }

        protected final void refreshKey(Object object) {
            MUTEX.postWriteRequest(new Runnable(this, object){
                private final /* synthetic */ Object val$key;
                private final /* synthetic */ Keys this$0;
                {
                    this.this$0 = keys;
                    this.val$key = object;
                }

                public void run() {
                    this.this$0.refreshEntry(this.this$0.new KE(this.val$key));
                }
            });
        }

        protected final void setKeys(Collection collection) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>(collection.size() + 1);
            if (this.before) {
                arrayList.add(this.getNodesEntry());
            }
            KE kE = new KE();
            kE.updateList(collection, arrayList);
            if (!this.before) {
                arrayList.add(this.getNodesEntry());
            }
            this.applyKeys(arrayList);
        }

        protected final void setKeys(Object[] objectArray) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>(objectArray.length + 1);
            KE kE = new KE();
            if (this.before) {
                arrayList.add(this.getNodesEntry());
            }
            kE.updateList(objectArray, arrayList);
            if (!this.before) {
                arrayList.add(this.getNodesEntry());
            }
            this.applyKeys(arrayList);
        }

        private void applyKeys(ArrayList arrayList) {
            Runnable runnable = new Runnable(this, arrayList){
                private final /* synthetic */ ArrayList val$l;
                private final /* synthetic */ Keys this$0;
                {
                    this.this$0 = keys;
                    this.val$l = arrayList;
                }

                public void run() {
                    if (Keys.access$800(this.this$0, this)) {
                        this.this$0.setEntries(this.val$l);
                        Keys.access$900(this.this$0, this);
                    }
                }
            };
            Keys.keysEnter(this, runnable);
            MUTEX.postWriteRequest(runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void setBefore(boolean bl) {
            try {
                PR.enterWriteAccess();
                if (this.before != bl) {
                    ArrayList arrayList = this.getEntries();
                    arrayList.remove(this.getNodesEntry());
                    this.before = bl;
                    if (bl) {
                        arrayList.add(0, this.getNodesEntry());
                    } else {
                        arrayList.add(this.getNodesEntry());
                    }
                    this.setEntries(arrayList);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected abstract Node[] createNodes(Object var1);

        protected void destroyNodes(Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i].fireNodeDestroyed();
            }
        }

        Node[] notifyRemove(Collection collection, Node[] nodeArray) {
            Node[] nodeArray2 = super.notifyRemove(collection, nodeArray);
            this.destroyNodes(nodeArray2);
            return nodeArray2;
        }

        private static synchronized void keysEnter(Keys keys, Runnable runnable) {
            lastRuns.put(keys, runnable);
        }

        private static synchronized void keysExit(Keys keys, Runnable runnable) {
            Runnable runnable2 = (Runnable)lastRuns.remove(keys);
            if (runnable2 != null && !runnable2.equals(runnable)) {
                lastRuns.put(keys, runnable2);
            }
        }

        private static synchronized boolean keysCheck(Keys keys, Runnable runnable) {
            return runnable == lastRuns.get(keys);
        }

        static /* synthetic */ boolean access$800(Keys keys, Runnable runnable) {
            return Keys.keysCheck(keys, runnable);
        }

        static /* synthetic */ void access$900(Keys keys, Runnable runnable) {
            Keys.keysExit(keys, runnable);
        }

        private final class KE
        extends Dupl
        implements Entry {
            public KE() {
            }

            public KE(Object object) {
                this.key = object;
            }

            public Collection nodes() {
                Node[] nodeArray = Keys.this.createNodes(this.getKey());
                if (nodeArray == null) {
                    return Collections.EMPTY_LIST;
                }
                return new LinkedList<Node>(Arrays.asList(nodeArray));
            }
        }
    }

    public static class SortedMap
    extends Map {
        private Comparator comp;

        public SortedMap() {
        }

        protected SortedMap(java.util.Map map) {
            super(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator comparator) {
            try {
                PR.enterWriteAccess();
                this.comp = comparator;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator getComparator() {
            return this.comp;
        }

        Collection createEntries(java.util.Map map) {
            TreeSet<Map.ME> treeSet = new TreeSet<Map.ME>(new SMComparator());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                treeSet.add(new Map.ME(entry.getKey(), (Node)entry.getValue()));
            }
            return treeSet;
        }

        final class SMComparator
        implements Comparator {
            SMComparator() {
            }

            public int compare(Object object, Object object2) {
                Map.ME mE = (Map.ME)object;
                Map.ME mE2 = (Map.ME)object2;
                Comparator comparator = SortedMap.this.comp;
                if (comparator == null) {
                    return ((Comparable)mE.key).compareTo(mE2.key);
                }
                return comparator.compare(mE.node, mE2.node);
            }
        }
    }

    public static class SortedArray
    extends Array {
        private Comparator comp;

        public SortedArray() {
        }

        protected SortedArray(Collection collection) {
            super(collection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator comparator) {
            try {
                PR.enterWriteAccess();
                this.comp = comparator;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator getComparator() {
            return this.comp;
        }

        Entry createNodesEntry() {
            return new SAE();
        }

        private final class SAE
        implements Entry {
            public Collection nodes() {
                ArrayList arrayList = new ArrayList(SortedArray.this.getCollection());
                Collections.sort(arrayList, SortedArray.this.comp);
                return arrayList;
            }
        }
    }

    public static class Map
    extends Children {
        protected java.util.Map nodes;

        protected Map(java.util.Map map) {
            this.nodes = map;
        }

        public Map() {
        }

        final java.util.Map getMap() {
            if (this.nodes == null) {
                this.nodes = this.initMap();
            }
            return this.nodes;
        }

        final void callAddNotify() {
            this.setEntries(this.createEntries(this.getMap()));
            super.callAddNotify();
        }

        Collection createEntries(java.util.Map map) {
            LinkedList<ME> linkedList = new LinkedList<ME>();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                linkedList.add(new ME(entry.getKey(), (Node)entry.getValue()));
            }
            return linkedList;
        }

        final void refreshImpl() {
            this.setEntries(this.createEntries(this.getMap()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refresh() {
            try {
                PR.enterWriteAccess();
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        final void refreshKeyImpl(Object object) {
            this.refreshEntry(new ME(object, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refreshKey(Object object) {
            try {
                PR.enterWriteAccess();
                this.refreshKeyImpl(object);
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void putAll(java.util.Map map) {
            try {
                PR.enterWriteAccess();
                this.nodes.putAll(map);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void put(Object object, Node node) {
            try {
                PR.enterWriteAccess();
                if (this.nodes.put(object, node) != null) {
                    this.refreshKeyImpl(object);
                } else {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void removeAll(Collection collection) {
            try {
                PR.enterWriteAccess();
                this.nodes.keySet().removeAll(collection);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(Object object) {
            try {
                PR.enterWriteAccess();
                if (this.nodes.remove(object) != null) {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected java.util.Map initMap() {
            return new HashMap(7);
        }

        public boolean add(Node[] nodeArray) {
            return false;
        }

        public boolean remove(Node[] nodeArray) {
            return false;
        }

        static final class ME
        implements Entry {
            public Object key;
            public Node node;

            public ME(Object object, Node node) {
                this.key = object;
                this.node = node;
            }

            public Collection nodes() {
                return Collections.singleton(this.node);
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object object) {
                if (object instanceof ME) {
                    ME mE = (ME)object;
                    return this.key.equals(mE.key);
                }
                return false;
            }

            public String toString() {
                return "Key (" + this.key + ")";
            }
        }
    }

    public static class Array
    extends Children
    implements Cloneable {
        private Entry nodesEntry = this.createNodesEntry();
        protected Collection nodes;

        protected Array(Collection collection) {
            this();
            this.nodes = collection;
        }

        public Array() {
            this.setEntries(Collections.singleton(this.getNodesEntry()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object clone() {
            try {
                Array array = (Array)super.clone();
                try {
                    PR.enterReadAccess();
                    if (this.nodes != null) {
                        array.nodes = array.initCollection();
                        array.nodes.clear();
                        Iterator iterator = this.nodes.iterator();
                        while (iterator.hasNext()) {
                            Node node = (Node)iterator.next();
                            array.nodes.add(node.cloneNode());
                        }
                    }
                }
                finally {
                    PR.exitReadAccess();
                }
                return array;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        protected Collection initCollection() {
            return new ArrayList();
        }

        final void refreshImpl() {
            if (this.isInitialized()) {
                this.refreshEntry(this.getNodesEntry());
                ((Children)this).getArray(null).nodes();
            } else if (this.nodes != null) {
                Iterator iterator = this.nodes.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    node.assignTo(this, -1);
                }
            }
        }

        protected final void refresh() {
            MUTEX.postWriteRequest(new Runnable(this){
                private final /* synthetic */ Array this$0;
                {
                    this.this$0 = array;
                }

                public void run() {
                    this.this$0.refreshImpl();
                }
            });
        }

        final Entry getNodesEntry() {
            return this.nodesEntry;
        }

        Entry createNodesEntry() {
            return new AE();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection getCollection() {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (this.nodes == null) {
                    this.nodes = this.initCollection();
                }
            }
            return this.nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Node[] nodeArray) {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (!this.getCollection().addAll(Arrays.asList(nodeArray))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Node[] nodeArray) {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (!this.getCollection().removeAll(Arrays.asList(nodeArray))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        private final class AE
        implements Entry {
            AE() {
            }

            public Collection nodes() {
                Collection collection = Array.this.getCollection();
                if (collection.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                return new ArrayList(collection);
            }
        }
    }

    private static final class Empty
    extends Children {
        Empty() {
        }

        public boolean add(Node[] nodeArray) {
            return false;
        }

        public boolean remove(Node[] nodeArray) {
            return false;
        }
    }

    final class Info {
        int length;
        Entry entry;

        public Info(Entry entry) {
            this.entry = entry;
        }

        protected void finalize() {
            Children.this.finalizeNodes();
        }

        public Collection nodes() {
            ChildrenArray childrenArray = Children.this.getArray(null);
            return childrenArray.nodesFor(this);
        }

        public void useNodes(Collection collection) {
            ChildrenArray childrenArray = Children.this.getArray(null);
            childrenArray.useNodes(this, collection);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                node.assignTo(Children.this, -1);
                node.fireParentNodeChange(null, Children.this.parent);
            }
        }

        public int length() {
            return this.length;
        }
    }

    static interface Entry {
        public Collection nodes();
    }
}

