/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class FilterNode
extends Node {
    protected static final int DELEGATE_SET_NAME = 1;
    protected static final int DELEGATE_GET_NAME = 2;
    protected static final int DELEGATE_SET_DISPLAY_NAME = 4;
    protected static final int DELEGATE_GET_DISPLAY_NAME = 8;
    protected static final int DELEGATE_SET_SHORT_DESCRIPTION = 16;
    protected static final int DELEGATE_GET_SHORT_DESCRIPTION = 32;
    protected static final int DELEGATE_DESTROY = 64;
    protected static final int DELEGATE_GET_ACTIONS = 128;
    protected static final int DELEGATE_GET_CONTEXT_ACTIONS = 256;
    protected static final int DELEGATE_SET_VALUE = 512;
    protected static final int DELEGATE_GET_VALUE = 1024;
    private static final int DELEGATE_ALL = 2047;
    private static final WeakHashMap overridesGetDisplayNameCache;
    private static final WeakHashMap replaceProvidedLookupCache;
    private static volatile int hashCodeDepth;
    private Node original;
    private PropertyChangeListener propL;
    private NodeListener nodeL;
    private int delegateMask;
    private boolean pchlAttached = false;
    private boolean childrenProvided;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$util$LookupListener;

    public FilterNode(Node node) {
        this(node, null);
    }

    public FilterNode(Node node, org.openide.nodes.Children children) {
        this(node, children, new FilterLookup());
    }

    public FilterNode(Node node, org.openide.nodes.Children children, Lookup lookup) {
        super(children == null ? (node.isLeaf() ? org.openide.nodes.Children.LEAF : new Children(node)) : children, lookup);
        this.childrenProvided = children != null;
        this.original = node;
        this.init();
        Lookup lookup2 = this.internalLookup(false);
        if (lookup2 instanceof FilterLookup) {
            ((FilterLookup)lookup2).ownNode(this);
        } else if (lookup2 == null) {
            this.getNodeListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Lookup replaceProvidedLookup(Lookup lookup) {
        WeakHashMap weakHashMap = replaceProvidedLookupCache;
        synchronized (weakHashMap) {
            Boolean bl = (Boolean)replaceProvidedLookupCache.get(this.getClass());
            if (bl == null) {
                bl = this.overridesAMethod("getCookie", new Class[]{Class.class}) ? Boolean.FALSE : Boolean.TRUE;
                replaceProvidedLookupCache.put(this.getClass(), bl);
            }
            return bl != false ? lookup : null;
        }
    }

    private boolean overridesAMethod(String string, Class[] classArray) {
        if (this.getClass() == FilterNode.class) {
            return false;
        }
        try {
            Method method = this.getClass().getMethod(string, classArray);
            if (method.getDeclaringClass() != FilterNode.class) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
        }
        return false;
    }

    private void init() {
        this.delegateMask = 2047;
    }

    void notifyPropertyChangeListenerAdded(PropertyChangeListener propertyChangeListener) {
        if (!this.pchlAttached) {
            this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = true;
        }
    }

    void notifyPropertyChangeListenerRemoved(PropertyChangeListener propertyChangeListener) {
        if (this.getPropertyChangeListenersCount() == 0) {
            this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = false;
        }
    }

    protected void finalize() {
        this.original.removePropertyChangeListener(this.getPropertyChangeListener());
        this.original.removeNodeListener(this.getNodeListener());
    }

    protected final void enableDelegation(int n) {
        if ((n & 0xFFFFF800) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + n);
        }
        this.delegateMask |= n;
    }

    protected final void disableDelegation(int n) {
        if ((n & 0xFFFFF800) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + n);
        }
        this.delegateMask &= ~n;
    }

    private final boolean delegating(int n) {
        return (this.delegateMask & n) != 0;
    }

    public Node cloneNode() {
        if (this.isDefault()) {
            return new FilterNode(this.original);
        }
        return new FilterNode(this);
    }

    private boolean checkIfIamAccessibleFromOriginal(Node node) {
        if (this == node) {
            throw new IllegalArgumentException("Node cannot be its own original (even thru indirect chain)");
        }
        if (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            this.checkIfIamAccessibleFromOriginal(filterNode.original);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void changeOriginal(Node node, boolean bl) {
        Lookup lookup;
        if (bl && !(this.getChildren() instanceof Children) && this.getChildren() != Children.LEAF) {
            throw new IllegalStateException("Can't change implicitly defined Children on FilterNode");
        }
        if (!$assertionsDisabled && !this.checkIfIamAccessibleFromOriginal(node)) {
            throw new AssertionError((Object)"");
        }
        try {
            Children.PR.enterWriteAccess();
            this.original.removeNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            }
            this.original = node;
            this.original.addNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            }
            if (bl) {
                if (node.isLeaf() && this.getChildren() != Children.LEAF) {
                    this.setChildren(Children.LEAF);
                } else if (!node.isLeaf() && this.getChildren() == Children.LEAF) {
                    this.setChildren(new Children(node));
                } else if (!node.isLeaf() && this.getChildren() != Children.LEAF) {
                    ((Children)this.getChildren()).changeOriginal(node);
                }
            }
        }
        finally {
            Children.PR.exitWriteAccess();
        }
        if ((lookup = this.internalLookup(false)) instanceof FilterLookup) {
            ((FilterLookup)lookup).checkNode();
        }
        this.fireCookieChange();
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireShortDescriptionChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
        this.firePropertySetsChange(null, null);
    }

    public void setValue(String string, Object object) {
        if (this.delegating(512)) {
            this.original.setValue(string, object);
        } else {
            super.setValue(string, object);
        }
    }

    public Object getValue(String string) {
        if (this.delegating(1024)) {
            return this.original.getValue(string);
        }
        return super.getValue(string);
    }

    public void setName(String string) {
        if (this.delegating(1)) {
            this.original.setName(string);
        } else {
            super.setName(string);
        }
    }

    public String getName() {
        if (this.delegating(2)) {
            return this.original.getName();
        }
        return super.getName();
    }

    public void setDisplayName(String string) {
        if (this.delegating(4)) {
            this.original.setDisplayName(string);
        } else {
            super.setDisplayName(string);
        }
    }

    public String getDisplayName() {
        if (this.delegating(8)) {
            return this.original.getDisplayName();
        }
        return super.getDisplayName();
    }

    public void setShortDescription(String string) {
        if (this.delegating(16)) {
            this.original.setShortDescription(string);
        } else {
            super.setShortDescription(string);
        }
    }

    public String getShortDescription() {
        if (this.delegating(32)) {
            return this.original.getShortDescription();
        }
        return super.getShortDescription();
    }

    public Image getIcon(int n) {
        return this.original.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.original.getOpenedIcon(n);
    }

    public HelpCtx getHelpCtx() {
        return this.original.getHelpCtx();
    }

    public boolean canRename() {
        return this.original.canRename();
    }

    public boolean canDestroy() {
        return this.original.canDestroy();
    }

    public void destroy() throws IOException {
        if (this.delegating(64)) {
            this.original.destroy();
        } else {
            super.destroy();
        }
    }

    private final void originalDestroyed() {
        try {
            super.destroy();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public Node.PropertySet[] getPropertySets() {
        return this.original.getPropertySets();
    }

    public Transferable clipboardCopy() throws IOException {
        return this.original.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        return this.original.clipboardCut();
    }

    public boolean canCopy() {
        return this.original.canCopy();
    }

    public boolean canCut() {
        return this.original.canCut();
    }

    public Transferable drag() throws IOException {
        return this.original.drag();
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return this.original.getDropType(transferable, n, n2);
    }

    public PasteType[] getPasteTypes(Transferable transferable) {
        return this.original.getPasteTypes(transferable);
    }

    public NewType[] getNewTypes() {
        return this.original.getNewTypes();
    }

    public SystemAction[] getActions() {
        if (this.delegating(128)) {
            return this.original.getActions();
        }
        return super.getActions();
    }

    public SystemAction[] getContextActions() {
        if (this.delegating(256)) {
            return this.original.getContextActions();
        }
        return super.getContextActions();
    }

    public SystemAction getDefaultAction() {
        return this.original.getDefaultAction();
    }

    public Action[] getActions(boolean bl) {
        if (bl ? !this.delegating(128) || this.overridesAMethod("getContextActions", new Class[0]) : !this.delegating(256) || this.overridesAMethod("getActions", new Class[0])) {
            return super.getActions(bl);
        }
        Action[] actionArray = this.original.getActions(bl);
        return actionArray;
    }

    public Action getPreferredAction() {
        Action action = this.overridesAMethod("getDefaultAction", new Class[0]) ? super.getPreferredAction() : this.original.getPreferredAction();
        return action;
    }

    public String getHtmlDisplayName() {
        if (this.overridesGetDisplayName()) {
            return null;
        }
        return this.delegating(8) ? this.original.getHtmlDisplayName() : super.getHtmlDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean overridesGetDisplayName() {
        WeakHashMap weakHashMap = overridesGetDisplayNameCache;
        synchronized (weakHashMap) {
            Boolean bl = (Boolean)overridesGetDisplayNameCache.get(this.getClass());
            if (bl == null) {
                bl = this.overridesAMethod("getDisplayName", null) ? Boolean.TRUE : Boolean.FALSE;
                overridesGetDisplayNameCache.put(this.getClass(), bl);
            }
            return bl != false;
        }
    }

    public boolean hasCustomizer() {
        return this.original.hasCustomizer();
    }

    public Component getCustomizer() {
        return this.original.getCustomizer();
    }

    public Node.Cookie getCookie(Class clazz) {
        Object object;
        Lookup lookup = this.internalLookup(true);
        if (lookup != null && (object = lookup.lookup(clazz)) instanceof Node.Cookie) {
            return (Node.Cookie)object;
        }
        return this.original.getCookie(clazz);
    }

    public Node.Handle getHandle() {
        if (!this.isDefault()) {
            return null;
        }
        Node.Handle handle = this.original.getHandle();
        if (handle == null) {
            return null;
        }
        return new FilterHandle(handle);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Node node = FilterNode.getRepresentation(this);
        Node node2 = FilterNode.getRepresentation((Node)object);
        if (node instanceof FilterNode || node2 instanceof FilterNode) {
            return node == node2;
        }
        return node.equals(node2);
    }

    private static Node getRepresentation(Node node) {
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            if (!filterNode.isDefault()) {
                return node;
            }
            node = filterNode.original;
        }
        return node;
    }

    public int hashCode() {
        try {
            int n;
            if (!$assertionsDisabled && !FilterNode.hashCodeLogging(true)) {
                throw new AssertionError((Object)"");
            }
            int n2 = n = this.isDefault() ? this.original.hashCode() : System.identityHashCode(this);
            if (!$assertionsDisabled && !FilterNode.hashCodeLogging(false)) {
                throw new AssertionError((Object)"");
            }
            return n;
        }
        catch (StackError stackError) {
            stackError.add(this);
            throw stackError;
        }
    }

    private static boolean hashCodeLogging(boolean bl) {
        if (hashCodeDepth > 1000) {
            hashCodeDepth = 0;
            throw new StackError();
        }
        hashCodeDepth = bl ? ++hashCodeDepth : --hashCodeDepth;
        return true;
    }

    protected Node getOriginal() {
        return this.original;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeAdapter(this);
    }

    protected NodeListener createNodeListener() {
        return new NodeAdapter(this);
    }

    synchronized PropertyChangeListener getPropertyChangeListener() {
        if (this.propL == null) {
            this.propL = this.createPropertyChangeListener();
        }
        return this.propL;
    }

    synchronized NodeListener getNodeListener() {
        if (this.nodeL == null) {
            this.nodeL = this.createNodeListener();
            this.getOriginal().addNodeListener(this.nodeL);
        }
        return this.nodeL;
    }

    final void listenerAdded() {
        this.getNodeListener();
    }

    private boolean isDefault() {
        if (this.getClass() != FilterNode.class) {
            return false;
        }
        return !this.childrenProvided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateChildren() {
        if (this.isDefault()) {
            org.openide.nodes.Children children = null;
            try {
                Children.PR.enterReadAccess();
                if (this.original.hierarchy == Children.LEAF && this.hierarchy != Children.LEAF) {
                    children = Children.LEAF;
                } else if (this.original.hierarchy != Children.LEAF && this.hierarchy == Children.LEAF) {
                    children = new Children(this.original);
                }
            }
            finally {
                Children.PR.exitReadAccess();
            }
            if (children != null) {
                final org.openide.nodes.Children children2 = children;
                Children.MUTEX.postWriteRequest(new Runnable(){

                    public void run() {
                        FilterNode.this.setChildren(children2);
                    }
                });
            }
        }
    }

    static {
        $assertionsDisabled = !FilterNode.class.desiredAssertionStatus();
        overridesGetDisplayNameCache = new WeakHashMap(27);
        replaceProvidedLookupCache = new WeakHashMap(27);
    }

    private static final class FilterLookup
    extends Lookup {
        private FilterNode node;
        private Lookup delegate;
        private WeakSet results;

        FilterLookup() {
        }

        public void ownNode(FilterNode filterNode) {
            this.node = filterNode;
        }

        private Object replaceNodes(Object object, Class clazz) {
            if (FilterLookup.isNodeQuery(clazz) && object == this.node.getOriginal() && clazz.isInstance(this.node)) {
                return this.node;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup checkNode() {
            Lookup lookup = this.node.getOriginal().getLookup();
            if (this.delegate == lookup) {
                return lookup;
            }
            Iterator<Object> iterator = null;
            FilterLookup filterLookup = this;
            synchronized (filterLookup) {
                if (lookup != this.delegate) {
                    this.delegate = lookup;
                    if (this.results != null) {
                        iterator = Arrays.asList(this.results.toArray()).iterator();
                    }
                }
            }
            if (iterator != null) {
                filterLookup = iterator;
                while (filterLookup.hasNext()) {
                    ProxyResult proxyResult = (ProxyResult)((Object)filterLookup.next());
                    if (!proxyResult.updateLookup(lookup)) continue;
                    proxyResult.resultChanged(null);
                }
            }
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup.Result lookup(Lookup.Template template) {
            ProxyResult proxyResult = new ProxyResult(template);
            FilterLookup filterLookup = this;
            synchronized (filterLookup) {
                if (this.results == null) {
                    this.results = new WeakSet();
                }
                this.results.add((Object)proxyResult);
            }
            return proxyResult;
        }

        public Object lookup(Class clazz) {
            Object object = this.checkNode().lookup(clazz);
            if (FilterLookup.isNodeQuery(clazz) && object == null) {
                object = this.checkNode().lookup(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FilterNode.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
            }
            return this.replaceNodes(object, clazz);
        }

        private static boolean isNodeQuery(Class clazz) {
            return (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FilterNode.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node).isAssignableFrom(clazz) || clazz.isAssignableFrom(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FilterNode.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
        }

        public Lookup.Item lookupItem(Lookup.Template template) {
            boolean bl = FilterLookup.isNodeQuery(template.getType());
            Lookup.Item item = this.checkNode().lookupItem(template);
            if (bl && item == null) {
                item = this.checkNode().lookupItem(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FilterNode.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node, template.getId(), template.getInstance()));
            }
            return bl ? new FilterItem(item, template.getType()) : item;
        }

        private final class FilterItem
        extends Lookup.Item {
            private Lookup.Item delegate;
            private Class clazz;

            FilterItem(Lookup.Item item, Class clazz) {
                this.delegate = item;
                this.clazz = clazz;
            }

            public String getDisplayName() {
                return this.delegate.getDisplayName();
            }

            public String getId() {
                return this.delegate.getId();
            }

            public Object getInstance() {
                return FilterLookup.this.replaceNodes(this.delegate.getInstance(), this.clazz);
            }

            public Class getType() {
                return this.delegate.getType();
            }
        }

        private final class ProxyResult
        extends Lookup.Result
        implements LookupListener {
            private Lookup.Template template;
            private Lookup.Result delegate;
            private EventListenerList listeners;

            ProxyResult(Lookup.Template template) {
                this.template = template;
            }

            private Lookup.Result checkResult() {
                this.updateLookup(FilterLookup.this.checkNode());
                return this.delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean updateLookup(Lookup lookup) {
                Collection collection = this.delegate != null ? this.delegate.allItems() : null;
                Object object = this;
                synchronized (object) {
                    if (this.delegate != null) {
                        this.delegate.removeLookupListener((LookupListener)this);
                    }
                    this.delegate = lookup.lookup(this.template);
                    if (FilterLookup.isNodeQuery(this.template.getType()) && this.delegate.allItems().isEmpty()) {
                        this.delegate = lookup.lookup(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FilterNode.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node, this.template.getId(), this.template.getInstance()));
                    }
                    this.delegate.addLookupListener((LookupListener)this);
                }
                if (collection == null) {
                    return false;
                }
                object = this.delegate.allItems();
                return !((Object)collection).equals(object);
            }

            public synchronized void addLookupListener(LookupListener lookupListener) {
                if (this.listeners == null) {
                    this.listeners = new EventListenerList();
                }
                this.listeners.add(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = FilterNode.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, lookupListener);
            }

            public synchronized void removeLookupListener(LookupListener lookupListener) {
                if (this.listeners != null) {
                    this.listeners.remove(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = FilterNode.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, lookupListener);
                }
            }

            public Collection allInstances() {
                Collection collection = this.checkResult().allInstances();
                if (FilterLookup.isNodeQuery(this.template.getType())) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(FilterLookup.this.replaceNodes(iterator.next(), this.template.getType()));
                    }
                    return arrayList;
                }
                return collection;
            }

            public Set allClasses() {
                return this.checkResult().allClasses();
            }

            public Collection allItems() {
                return this.checkResult().allItems();
            }

            public void resultChanged(LookupEvent lookupEvent) {
                EventListenerList eventListenerList = this.listeners;
                if (eventListenerList == null) {
                    return;
                }
                Object[] objectArray = eventListenerList.getListenerList();
                if (objectArray.length == 0) {
                    return;
                }
                LookupEvent lookupEvent2 = new LookupEvent((Lookup.Result)this);
                for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                    LookupListener lookupListener = (LookupListener)objectArray[i];
                    lookupListener.resultChanged(lookupEvent2);
                }
            }
        }
    }

    private static final class FilterHandle
    implements Node.Handle {
        static final long serialVersionUID = 7928908039428333839L;
        private Node.Handle original;

        public FilterHandle(Node.Handle handle) {
            this.original = handle;
        }

        public Node getNode() throws IOException {
            return new FilterNode(this.original.getNode());
        }

        public String toString() {
            return "FilterHandle[" + this.original + "]";
        }
    }

    private static class ChildrenAdapter
    implements NodeListener,
    Runnable {
        private WeakReference children;

        public ChildrenAdapter(Children children) {
            this.children = new WeakReference<Children>(children);
        }

        public void run() {
            Children children = (Children)this.children.get();
            if (children != null) {
                Object[] objectArray = children.original.getChildren().getNodes();
                children.setKeys(objectArray);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenAdded(nodeMemberEvent);
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenRemoved(nodeMemberEvent);
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenReordered(nodeReorderEvent);
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }
    }

    public static class Children
    extends Children.Keys
    implements Cloneable {
        protected Node original;
        private ChildrenAdapter nodeL;

        public Children(Node node) {
            this.original = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void changeOriginal(Node node) {
            try {
                boolean bl;
                PR.enterWriteAccess();
                boolean bl2 = bl = this.nodeL != null;
                if (bl) {
                    this.original.removeNodeListener(this.nodeL);
                    this.nodeL = null;
                }
                this.original = node;
                if (bl) {
                    this.addNotifyImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected void finalize() {
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
            }
            this.nodeL = null;
        }

        public Object clone() {
            return new Children(this.original);
        }

        protected void addNotify() {
            this.addNotifyImpl();
        }

        private void addNotifyImpl() {
            this.nodeL = new ChildrenAdapter(this);
            this.original.addNodeListener(this.nodeL);
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
                this.nodeL = null;
            }
        }

        protected Node copyNode(Node node) {
            return node.cloneNode();
        }

        public Node findChild(String string) {
            this.original.getChildren().findChild(string);
            return super.findChild(string);
        }

        protected Node[] createNodes(Object object) {
            Node node = (Node)object;
            return new Node[]{this.copyNode(node)};
        }

        public boolean add(Node[] nodeArray) {
            return this.original.getChildren().add(nodeArray);
        }

        public boolean remove(Node[] nodeArray) {
            return this.original.getChildren().remove(nodeArray);
        }

        protected void filterChildrenAdded(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        protected void filterChildrenRemoved(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        protected void filterChildrenReordered(NodeReorderEvent nodeReorderEvent) {
            this.updateKeys();
        }

        private void updateKeys() {
            ChildrenAdapter childrenAdapter = this.nodeL;
            if (childrenAdapter != null) {
                childrenAdapter.run();
            }
        }

        public Node[] getNodes(boolean bl) {
            if (bl) {
                this.setKeys(this.original.getChildren().getNodes(true));
            }
            return this.getNodes();
        }
    }

    protected static class NodeAdapter
    implements NodeListener {
        private WeakReference fn;

        public NodeAdapter(FilterNode filterNode) {
            this.fn = new WeakReference<FilterNode>(filterNode);
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FilterNode filterNode = (FilterNode)this.fn.get();
            if (filterNode == null) {
                return;
            }
            this.propertyChange(filterNode, propertyChangeEvent);
        }

        protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("parentNode")) {
                return;
            }
            if (string.equals("displayName")) {
                filterNode.fireOwnPropertyChange("displayName", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("name")) {
                filterNode.fireOwnPropertyChange("name", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("shortDescription")) {
                filterNode.fireOwnPropertyChange("shortDescription", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("icon")) {
                filterNode.fireIconChange();
                return;
            }
            if (string.equals("openedIcon")) {
                filterNode.fireOpenedIconChange();
                return;
            }
            if (string.equals("propertySets")) {
                filterNode.firePropertySetsChange((Node.PropertySet[])propertyChangeEvent.getOldValue(), (Node.PropertySet[])propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("cookie")) {
                filterNode.fireCookieChange();
                return;
            }
            if (string.equals("leaf")) {
                filterNode.updateChildren();
            }
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public final void nodeDestroyed(NodeEvent nodeEvent) {
            FilterNode filterNode = (FilterNode)this.fn.get();
            if (filterNode == null) {
                return;
            }
            filterNode.originalDestroyed();
        }
    }

    protected static class PropertyChangeAdapter
    implements PropertyChangeListener {
        private WeakReference fn;

        public PropertyChangeAdapter(FilterNode filterNode) {
            this.fn = new WeakReference<FilterNode>(filterNode);
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FilterNode filterNode = (FilterNode)this.fn.get();
            if (filterNode == null) {
                return;
            }
            this.propertyChange(filterNode, propertyChangeEvent);
        }

        protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
            filterNode.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private static class StackError
    extends StackOverflowError {
        private IdentityHashMap nodes;

        private StackError() {
        }

        public void add(FilterNode filterNode) {
            if (this.nodes == null) {
                this.nodes = new IdentityHashMap();
            }
            if (this.nodes.get(filterNode) == null) {
                this.nodes.put(filterNode, filterNode);
            }
        }

        public String getMessage() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("StackOver in FilterNodes:\n");
            Iterator iterator = this.nodes.keySet().iterator();
            while (iterator.hasNext()) {
                FilterNode filterNode = (FilterNode)iterator.next();
                stringBuffer.append("  class: ");
                stringBuffer.append(filterNode.getClass().getName());
                stringBuffer.append(" id: ");
                stringBuffer.append(Integer.toString(System.identityHashCode(filterNode), 16));
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

