/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.FilterNode;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeLookup;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public abstract class Node
extends FeatureDescriptor
implements Lookup.Provider,
HelpCtx.Provider {
    public static final Node EMPTY = new AbstractNode(Children.LEAF);
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_NAME = "name";
    public static final String PROP_SHORT_DESCRIPTION = "shortDescription";
    public static final String PROP_ICON = "icon";
    public static final String PROP_OPENED_ICON = "openedIcon";
    public static final String PROP_PARENT_NODE = "parentNode";
    public static final String PROP_PROPERTY_SETS = "propertySets";
    public static final String PROP_COOKIE = "cookie";
    public static final String PROP_LEAF = "leaf";
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.nodes.Node");
    private static final boolean doLog = err.isLoggable(1);
    private static final boolean doWarn = err.isLoggable(16);
    private static WeakHashMap lookups = new WeakHashMap(37);
    private static final Set warnedBadProperties = new HashSet(100);
    private static final Lookup.Template TEMPL_COOKIE = new Lookup.Template(Cookie.class);
    private static final Object INIT_LOCK = new Object();
    private Object parent;
    Children hierarchy;
    private transient EventListenerList listeners;

    protected Node(Children children) throws IllegalStateException {
        this(children, null);
    }

    protected Node(Children children, Lookup lookup) throws IllegalStateException {
        this.hierarchy = children;
        lookup = this.replaceProvidedLookup(lookup);
        this.listeners = lookup != null ? new LookupEventList(lookup) : new EventListenerList();
        children.attachTo(this);
    }

    Lookup replaceProvidedLookup(Lookup lookup) {
        return lookup;
    }

    final Lookup internalLookup(boolean bl) {
        if (this.listeners instanceof LookupEventList) {
            return ((LookupEventList)this.listeners).init(bl);
        }
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        Children children = this.hierarchy instanceof Cloneable ? (Children)this.hierarchy.cloneHierarchy() : Children.LEAF;
        node.hierarchy = children;
        children.attachTo(node);
        node.parent = null;
        node.listeners = this.listeners instanceof LookupEventList ? new LookupEventList(this.internalLookup(false)) : new EventListenerList();
        return node;
    }

    public abstract Node cloneNode();

    private Children getParentChildren() {
        return this.parent instanceof ChildrenArray ? ((ChildrenArray)this.parent).getChildren() : (Children)this.parent;
    }

    final synchronized void assignTo(Children children, int n) {
        Children children2 = this.getParentChildren();
        if (children2 != null && children2 != children) {
            throw new IllegalStateException("Cannot initialize " + n + "th child of node " + children.getNode() + "; it already belongs to node " + children2.getNode());
        }
        if (!(this.parent instanceof ChildrenArray)) {
            this.parent = children;
        }
    }

    final synchronized void reassignTo(Children children, ChildrenArray childrenArray) {
        if (this.parent != children && this.parent != childrenArray) {
            throw new IllegalStateException("Unauthorized call to change parent: " + this.parent + " and should be: " + children);
        }
        this.parent = childrenArray;
    }

    final synchronized void deassignFrom(Children children) {
        Children children2 = this.getParentChildren();
        if (children != children2) {
            throw new IllegalArgumentException("Deassign from wrong parent. Old: " + children2 + " Caller: " + children);
        }
        this.parent = null;
    }

    public void setName(String string) {
        String string2 = super.getName();
        if (string2 == null || !string2.equals(string)) {
            super.setName(string);
            this.fireNameChange(string2, string);
        }
    }

    public void setDisplayName(String string) {
        String string2 = super.getDisplayName();
        if (string2 == null || !string2.equals(string)) {
            super.setDisplayName(string);
            this.fireDisplayNameChange(string2, string);
        }
    }

    public void setShortDescription(String string) {
        String string2 = super.getShortDescription();
        if (string2 == null || !string2.equals(string)) {
            super.setShortDescription(string);
            this.fireShortDescriptionChange(string2, string);
        }
    }

    public abstract Image getIcon(int var1);

    public abstract Image getOpenedIcon(int var1);

    public abstract HelpCtx getHelpCtx();

    public final Children getChildren() {
        this.updateChildren();
        return this.hierarchy;
    }

    void updateChildren() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setChildren(Children children) {
        try {
            Children.PR.enterWriteAccess();
            Node[] nodeArray = null;
            if (this.hierarchy.isInitialized()) {
                nodeArray = this.hierarchy.getNodes();
            }
            this.hierarchy.detachFrom();
            boolean bl = this.hierarchy == Children.LEAF;
            this.hierarchy = children;
            this.hierarchy.attachTo(this);
            if (bl != (this.hierarchy == Children.LEAF)) {
                this.fireOwnPropertyChange(PROP_LEAF, bl ? Boolean.TRUE : Boolean.FALSE, this.hierarchy == Children.LEAF ? Boolean.TRUE : Boolean.FALSE);
            }
            if (nodeArray != null && !bl) {
                this.fireSubNodesChange(false, nodeArray, nodeArray);
                this.fireSubNodesChange(true, this.hierarchy.getNodes(), null);
            }
        }
        finally {
            Children.PR.exitWriteAccess();
        }
    }

    public final boolean isLeaf() {
        this.updateChildren();
        return this.hierarchy == Children.LEAF;
    }

    public final Node getParentNode() {
        Children children = this.getParentChildren();
        return children == null ? null : children.getNode();
    }

    public abstract boolean canRename();

    public abstract boolean canDestroy();

    public void destroy() throws IOException {
        Children.MUTEX.postWriteRequest(new Runnable(){

            public void run() {
                Children children = Node.this.getParentChildren();
                if (children != null) {
                    children.remove(new Node[]{Node.this});
                }
                Node.this.fireNodeDestroyed();
            }
        });
    }

    public abstract PropertySet[] getPropertySets();

    public abstract Transferable clipboardCopy() throws IOException;

    public abstract Transferable clipboardCut() throws IOException;

    public abstract Transferable drag() throws IOException;

    public abstract boolean canCopy();

    public abstract boolean canCut();

    public abstract PasteType[] getPasteTypes(Transferable var1);

    public abstract PasteType getDropType(Transferable var1, int var2, int var3);

    public abstract NewType[] getNewTypes();

    public Action[] getActions(boolean bl) {
        return bl ? this.getContextActions() : this.getActions();
    }

    public SystemAction[] getActions() {
        return NodeOp.getDefaultActions();
    }

    public SystemAction[] getContextActions() {
        return this.getActions();
    }

    public SystemAction getDefaultAction() {
        return null;
    }

    public Action getPreferredAction() {
        return this.getDefaultAction();
    }

    public final JPopupMenu getContextMenu() {
        return NodeOp.findContextMenuImpl(new Node[]{this}, null);
    }

    public abstract boolean hasCustomizer();

    public abstract Component getCustomizer();

    public Cookie getCookie(Class clazz) {
        Object object;
        Lookup lookup = this.internalLookup(true);
        if (lookup != null && (object = lookup.lookup(clazz)) instanceof Cookie) {
            return (Cookie)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup getLookup() {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            Lookup lookup = this.internalLookup(true);
            if (lookup != null) {
                return lookup;
            }
            lookup = this.findDelegatingLookup();
            if (lookup != null) {
                return lookup;
            }
            NodeLookup nodeLookup = new NodeLookup(this);
            this.registerDelegatingLookup(nodeLookup);
            return nodeLookup;
        }
    }

    public String getHtmlDisplayName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerDelegatingLookup(NodeLookup nodeLookup) {
        WeakHashMap weakHashMap = lookups;
        synchronized (weakHashMap) {
            lookups.put(this.listeners, new WeakReference<NodeLookup>(nodeLookup));
        }
    }

    final Lookup findDelegatingLookup() {
        WeakReference weakReference = (WeakReference)lookups.get(this.listeners);
        return weakReference == null ? null : (Lookup)weakReference.get();
    }

    public abstract Handle getHandle();

    public final void addNodeListener(NodeListener nodeListener) {
        this.listeners.add(NodeListener.class, nodeListener);
        this.listenerAdded();
    }

    void listenerAdded() {
    }

    public final void removeNodeListener(NodeListener nodeListener) {
        this.listeners.remove(NodeListener.class, nodeListener);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        int n = -1;
        if (doLog) {
            n = this.getPropertyChangeListenersCount();
        }
        this.listeners.add(PropertyChangeListener.class, propertyChangeListener);
        if (doLog) {
            err.log(1, "ADD - " + this.getName() + " [" + n + "]->[" + this.getPropertyChangeListenersCount() + "] " + propertyChangeListener);
        }
        this.notifyPropertyChangeListenerAdded(propertyChangeListener);
    }

    void notifyPropertyChangeListenerAdded(PropertyChangeListener propertyChangeListener) {
    }

    int getPropertyChangeListenersCount() {
        return this.listeners.getListenerCount(PropertyChangeListener.class);
    }

    protected final boolean hasPropertyChangeListener() {
        return this.getPropertyChangeListenersCount() > 0;
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        int n = -1;
        if (doLog) {
            n = this.getPropertyChangeListenersCount();
        }
        this.listeners.remove(PropertyChangeListener.class, propertyChangeListener);
        if (doLog) {
            err.log(1, "RMV - " + this.getName() + " [" + n + "]->[" + this.getPropertyChangeListenersCount() + "] " + propertyChangeListener);
        }
        this.notifyPropertyChangeListenerRemoved(propertyChangeListener);
    }

    void notifyPropertyChangeListenerRemoved(PropertyChangeListener propertyChangeListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void firePropertyChange(String string, Object object, Object object2) {
        int n;
        Object object3;
        if (doWarn && string != null && this.propertySetsAreKnown()) {
            Object object4;
            object3 = this.getPropertySets();
            boolean bl = false;
            block3: for (n = 0; n < ((PropertySet[])object3).length; ++n) {
                object4 = object3[n].getProperties();
                for (int i = 0; i < ((Property[])object4).length; ++i) {
                    if (!object4[i].getName().equals(string)) continue;
                    bl = true;
                    continue block3;
                }
            }
            if (!bl) {
                Set set = warnedBadProperties;
                synchronized (set) {
                    object4 = this.getClass().getName();
                    if (warnedBadProperties.add((String)object4 + "." + string)) {
                        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Warning - the node \"" + this.getDisplayName() + "\" [" + (String)object4 + "] is trying to fire the property " + string + " which is not included in its property sets. This is illegal. See IZ #31413 for details."));
                    }
                }
            }
        }
        if (object != null && object2 != null && (object == object2 || object.equals(object2))) {
            return;
        }
        object3 = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (n = objectArray.length - 2; n >= 0; n -= 2) {
            if (objectArray[n] != (class$java$beans$PropertyChangeListener == null ? Node.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
            if (object3 == null) {
                object3 = new PropertyChangeEvent(this, string, object, object2);
            }
            ((PropertyChangeListener)objectArray[n + 1]).propertyChange((PropertyChangeEvent)object3);
        }
    }

    boolean propertySetsAreKnown() {
        return false;
    }

    protected final void fireNameChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_NAME, string, string2);
    }

    protected final void fireDisplayNameChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_DISPLAY_NAME, string, string2);
    }

    protected final void fireShortDescriptionChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_SHORT_DESCRIPTION, string, string2);
    }

    protected final void fireIconChange() {
        this.fireOwnPropertyChange(PROP_ICON, null, null);
    }

    protected final void fireOpenedIconChange() {
        this.fireOwnPropertyChange(PROP_OPENED_ICON, null, null);
    }

    final void fireSubNodesChange(boolean bl, Node[] nodeArray, Node[] nodeArray2) {
        NodeMemberEvent nodeMemberEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) continue;
            if (nodeMemberEvent == null) {
                nodeMemberEvent = new NodeMemberEvent(this, bl, nodeArray, nodeArray2);
            }
            if (bl) {
                ((NodeListener)objectArray[i + 1]).childrenAdded(nodeMemberEvent);
                continue;
            }
            ((NodeListener)objectArray[i + 1]).childrenRemoved(nodeMemberEvent);
        }
    }

    final void fireReorderChange(int[] nArray) {
        NodeReorderEvent nodeReorderEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) continue;
            if (nodeReorderEvent == null) {
                nodeReorderEvent = new NodeReorderEvent(this, nArray);
            }
            ((NodeListener)objectArray[i + 1]).childrenReordered(nodeReorderEvent);
        }
    }

    protected final void fireNodeDestroyed() {
        NodeEvent nodeEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) continue;
            if (nodeEvent == null) {
                nodeEvent = new NodeEvent(this);
            }
            ((NodeListener)objectArray[i + 1]).nodeDestroyed(nodeEvent);
        }
    }

    final void fireParentNodeChange(Node node, Node node2) {
        this.fireOwnPropertyChange(PROP_PARENT_NODE, node, node2);
    }

    protected final void firePropertySetsChange(PropertySet[] propertySetArray, PropertySet[] propertySetArray2) {
        this.fireOwnPropertyChange(PROP_PROPERTY_SETS, propertySetArray, propertySetArray2);
    }

    protected final void fireCookieChange() {
        Lookup lookup = this.findDelegatingLookup();
        if (lookup instanceof NodeLookup) {
            ((NodeLookup)lookup).updateLookupAsCookiesAreChanged(null);
        }
        this.fireOwnPropertyChange(PROP_COOKIE, null, null);
    }

    final void fireOwnPropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && (object == object2 || object.equals(object2))) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) continue;
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            }
            ((NodeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FilterNode) {
            return ((FilterNode)object).equals(this);
        }
        return this == object;
    }

    static String getString(String string) {
        return NbBundle.getBundle((Class)Node.class).getString(string);
    }

    public String toString() {
        return super.toString() + "[Name=" + this.getName() + ", displayName=" + this.getDisplayName() + "]";
    }

    private final class LookupEventList
    extends EventListenerList
    implements LookupListener {
        public final Lookup lookup;
        private Lookup.Result result;
        static final /* synthetic */ boolean $assertionsDisabled;

        public LookupEventList(Lookup lookup) {
            this.lookup = lookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup init(boolean bl) {
            boolean bl2 = false;
            Object object = INIT_LOCK;
            synchronized (object) {
                if (bl && this.result == null) {
                    this.result = this.lookup.lookup(TEMPL_COOKIE);
                    if (!$assertionsDisabled && this.result == null) {
                        throw new AssertionError((Object)("Null lookup result from " + this.lookup + " in " + Node.this));
                    }
                    this.result.addLookupListener((LookupListener)this);
                    bl2 = true;
                }
            }
            if (bl2) {
                this.result.allItems();
            }
            return this.lookup;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            FilterNode filterNode;
            if (Node.this instanceof FilterNode && (filterNode = (FilterNode)Node.this).getOriginal() == NodeLookup.NO_COOKIE_CHANGE.get()) {
                return;
            }
            Node.this.fireCookieChange();
        }

        static {
            $assertionsDisabled = !(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = Node.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node).desiredAssertionStatus();
        }
    }

    public static abstract class IndexedProperty
    extends Property {
        private Class elementType;

        public IndexedProperty(Class clazz, Class clazz2) {
            super(clazz);
            this.elementType = clazz2;
        }

        public abstract boolean canIndexedRead();

        public Class getElementType() {
            return this.elementType;
        }

        public abstract Object getIndexedValue(int var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public abstract boolean canIndexedWrite();

        public abstract void setIndexedValue(int var1, Object var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public PropertyEditor getIndexedPropertyEditor() {
            return PropertyEditorManager.findEditor(this.elementType);
        }

        public boolean equals(Object object) {
            try {
                if (!super.equals(object)) {
                    return false;
                }
                Class clazz = ((IndexedProperty)object).getElementType();
                Class clazz2 = this.getElementType();
                if (clazz == null && clazz2 != null || clazz != null && clazz2 == null) {
                    return false;
                }
                return clazz == null && clazz2 == null || clazz.equals(clazz2);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            Class clazz = this.getElementType();
            return super.hashCode() * (this.elementType == null ? 1 : this.elementType.hashCode());
        }
    }

    public static abstract class Property
    extends FeatureDescriptor {
        private static final Set warnedNames = new HashSet();
        private Class type;
        SoftReference edRef = null;

        public Property(Class clazz) {
            this.type = clazz;
            super.setName("");
        }

        public Class getValueType() {
            return this.type;
        }

        public abstract boolean canRead();

        public abstract Object getValue() throws IllegalAccessException, InvocationTargetException;

        public abstract boolean canWrite();

        public abstract void setValue(Object var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public boolean supportsDefaultValue() {
            return false;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        }

        public boolean isDefaultValue() {
            String string = this.getClass().getName();
            if (this.supportsDefaultValue() && warnedNames.add(string)) {
                ErrorManager.getDefault().log(16, "Class " + string + " must override isDefaultValue() since it " + "overrides supportsDefaultValue() to be true");
            }
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.type == null) {
                return null;
            }
            PropertyEditor propertyEditor = null;
            if (this.edRef != null) {
                propertyEditor = (PropertyEditor)this.edRef.get();
            }
            if (propertyEditor == null) {
                propertyEditor = PropertyEditorManager.findEditor(this.type);
                this.edRef = new SoftReference<PropertyEditor>(propertyEditor);
            }
            return propertyEditor;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Property)) {
                return false;
            }
            Class clazz = ((Property)object).getValueType();
            Class clazz2 = this.getValueType();
            if (clazz == null && clazz2 != null || clazz != null && clazz2 == null) {
                return false;
            }
            return ((Property)object).getName().equals(this.getName()) && (clazz == null && clazz2 == null || clazz.equals(clazz2));
        }

        public int hashCode() {
            Class clazz = this.getValueType();
            return this.getName().hashCode() * (clazz == null ? 1 : clazz.hashCode());
        }

        public String getHtmlDisplayName() {
            return null;
        }
    }

    public static abstract class PropertySet
    extends FeatureDescriptor {
        public PropertySet() {
        }

        public PropertySet(String string, String string2, String string3) {
            super.setName(string);
            super.setDisplayName(string2);
            super.setShortDescription(string3);
        }

        public abstract Property[] getProperties();

        public boolean equals(Object object) {
            if (!(object instanceof PropertySet)) {
                return false;
            }
            return ((PropertySet)object).getName().equals(this.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String getHtmlDisplayName() {
            return null;
        }
    }

    public static interface Handle
    extends Serializable {
        public static final long serialVersionUID = -4518262478987434353L;

        public Node getNode() throws IOException;
    }

    public static interface Cookie {
    }
}

