/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPopupMenu;
import org.openide.ErrorManager;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeNotFoundException;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NodeOp {
    private static SystemAction[] defaultActions;

    private NodeOp() {
    }

    public static SystemAction[] getDefaultActions() {
        if (defaultActions == null) {
            defaultActions = NodeOp.createFromNames(new String[]{"Tools", "Properties"});
        }
        return defaultActions;
    }

    public static void setDefaultActions(SystemAction[] systemActionArray) {
        throw new SecurityException();
    }

    public static JPopupMenu findContextMenu(Node[] nodeArray) {
        return NodeOp.findContextMenuImpl(nodeArray, null);
    }

    static JPopupMenu findContextMenuImpl(Node[] nodeArray, ActionMap actionMap) {
        Action[] actionArray = NodeOp.findActions(nodeArray);
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        for (int i = 0; i < nodeArray.length; ++i) {
            arrayList.add(nodeArray[i].getLookup());
        }
        if (actionMap != null) {
            arrayList.add(Lookups.singleton((Object)actionMap));
        }
        ProxyLookup proxyLookup = new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
        return Utilities.actionsToPopup((Action[])actionArray, (Lookup)proxyLookup);
    }

    public static Action[] findActions(Node[] nodeArray) {
        Object object;
        int n;
        HashSet<Action> hashSet;
        HashMap<Action, Integer> hashMap = new HashMap<Action, Integer>();
        Action[][] actionArrayArray = new Action[nodeArray.length][];
        for (int i = 0; i < nodeArray.length; ++i) {
            actionArrayArray[i] = nodeArray[i].getActions(false);
            if (actionArrayArray[i] == null) {
                actionArrayArray[i] = defaultActions;
            }
            hashSet = new HashSet();
            for (n = 0; n < actionArrayArray[i].length; ++n) {
                if (actionArrayArray[i][n] == null || hashSet.contains(actionArrayArray[i][n])) continue;
                hashSet.add(actionArrayArray[i][n]);
                object = (Integer)hashMap.get(actionArrayArray[i][n]);
                int n2 = object == null ? 0 : (Integer)object;
                hashMap.put(actionArrayArray[i][n], new Integer(n2 + 1));
            }
        }
        if (!hashMap.isEmpty()) {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            hashSet = new HashSet<Action>();
            for (n = 0; n < actionArrayArray[0].length; ++n) {
                object = actionArrayArray[0][n];
                if (object != null) {
                    int n3;
                    if (hashSet.contains(object)) continue;
                    hashSet.add((Action)object);
                    Integer n4 = (Integer)hashMap.get(object);
                    int n5 = n3 = n4 == null ? 0 : n4;
                    if (n3 != nodeArray.length) continue;
                    arrayList.add((Action)object);
                    continue;
                }
                arrayList.add(null);
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }
        return new Action[0];
    }

    public static boolean isSon(Node node, Node node2) {
        return node2.getParentNode() == node;
    }

    public static String[] createPath(Node node, Node node2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (node != null && node != node2) {
            if (node.getName() == null) {
                boolean bl = false;
                if (node instanceof FilterNode) {
                    bl = true;
                }
                throw new IllegalArgumentException("Node:" + node.getClass() + "[" + node.getDisplayName() + "]" + (bl ? " of original:" + ((FilterNode)node).getOriginal().getClass() : "") + " gets null name!");
            }
            linkedList.addFirst(node.getName());
            node = node.getParentNode();
        }
        String[] stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    public static Node findChild(Node node, String string) {
        return node.getChildren().findChild(string);
    }

    public static Node findPath(Node node, Enumeration enumeration) throws NodeNotFoundException {
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Node node2 = NodeOp.findChild(node, string);
            if (node2 == null) {
                throw new NodeNotFoundException(node, string, n);
            }
            node = node2;
            ++n;
        }
        return node;
    }

    public static Node findPath(Node node, String[] stringArray) throws NodeNotFoundException {
        return NodeOp.findPath(node, Enumerations.array((Object[])stringArray));
    }

    public static Node findRoot(Node node) {
        Node node2;
        while ((node2 = node.getParentNode()) != null) {
            node = node2;
        }
        return node;
    }

    public static int[] computePermutation(Node[] nodeArray, Node[] nodeArray2) throws IllegalArgumentException {
        if (nodeArray.length != nodeArray2.length) {
            int n = Math.max(nodeArray.length, nodeArray2.length);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(i + " ");
                if (i < nodeArray.length) {
                    stringBuffer.append(nodeArray[i].getName());
                } else {
                    stringBuffer.append("---");
                }
                stringBuffer.append(" = ");
                if (i < nodeArray2.length) {
                    stringBuffer.append(nodeArray2[i].getName());
                } else {
                    stringBuffer.append("---");
                }
                stringBuffer.append('\n');
            }
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        for (int i = 0; i < nodeArray2.length; ++i) {
            hashMap.put(nodeArray2[i], new Integer(i));
        }
        int[] nArray = new int[nodeArray.length];
        int n = 0;
        for (int i = 0; i < nodeArray.length; ++i) {
            Integer n2 = (Integer)hashMap.get(nodeArray[i]);
            if (n2 == null) {
                throw new IllegalArgumentException("Missing permutation index " + i);
            }
            nArray[i] = n2;
            if (nArray[i] == i) continue;
            ++n;
        }
        return n == 0 ? null : nArray;
    }

    public static Node.Handle[] toHandles(Node[] nodeArray) {
        LinkedList<Node.Handle> linkedList = new LinkedList<Node.Handle>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node.Handle handle = nodeArray[i].getHandle();
            if (handle == null) continue;
            linkedList.add(handle);
        }
        return linkedList.toArray(new Node.Handle[linkedList.size()]);
    }

    public static Node[] fromHandles(Node.Handle[] handleArray) throws IOException {
        Node[] nodeArray = new Node[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            nodeArray[i] = handleArray[i].getNode();
        }
        return nodeArray;
    }

    public static NodeListener weakNodeListener(NodeListener nodeListener, Object object) {
        return (NodeListener)WeakListeners.create((Class)NodeListener.class, (EventListener)nodeListener, (Object)object);
    }

    static SystemAction[] createFromNames(String[] stringArray) {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
        LinkedList<SystemAction> linkedList = new LinkedList<SystemAction>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                linkedList.add(null);
                continue;
            }
            String string = "org.openide.actions." + stringArray[i] + "Action";
            try {
                Class<?> clazz = Class.forName(string);
                linkedList.add(SystemAction.get(clazz));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (errorManager == null) continue;
                errorManager.log(1, "NodeOp.java: Missing class " + string);
            }
        }
        return linkedList.toArray(new SystemAction[linkedList.size()]);
    }

    static void exception(Throwable throwable) {
        ErrorManager.getDefault().notify(1, throwable);
    }

    static void warning(Throwable throwable) {
        ErrorManager.getDefault().notify(16, throwable);
    }
}

