/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public abstract class CloneableTopComponent
extends TopComponent
implements Externalizable,
TopComponent.Cloneable {
    static final long serialVersionUID = 4893753008783256289L;
    public static final Ref EMPTY = new Ref();
    private Ref ref;

    public final Object clone() {
        return this.cloneComponent();
    }

    public final CloneableTopComponent cloneTopComponent() {
        CloneableTopComponent cloneableTopComponent = this.createClonedObject();
        cloneableTopComponent.setReference(this.getReference());
        return cloneableTopComponent;
    }

    public final TopComponent cloneComponent() {
        return this.cloneTopComponent();
    }

    protected CloneableTopComponent createClonedObject() {
        try {
            NbMarshalledObject nbMarshalledObject = new NbMarshalledObject((Object)this);
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)nbMarshalledObject.get();
            return cloneableTopComponent;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new InternalError();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new InternalError();
        }
    }

    public final synchronized Ref getReference() {
        if (this.ref == null) {
            this.ref = new Ref(this);
        }
        return this.ref;
    }

    public final synchronized void setReference(Ref ref) {
        if (ref == EMPTY) {
            throw new IllegalArgumentException(NbBundle.getBundle((Class)CloneableTopComponent.class).getString("EXC_CannotAssign"));
        }
        if (this.ref != null) {
            this.ref.removeComponent(this);
        }
        ref.register(this);
        this.ref = ref;
    }

    protected void componentClosed() {
        super.componentClosed();
        if (!this.isOpened()) {
            this.getReference().unregister(this);
        }
    }

    public boolean canClose() {
        if (!this.isOpened()) {
            return false;
        }
        return this.getReference().unregister(this);
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        if (bl) {
            return this.getReference().unregister(this);
        }
        return true;
    }

    protected boolean closeLast() {
        return true;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Ref ref;
        super.readExternal(objectInput);
        if (this.serialVersion != 0 && (ref = (Ref)objectInput.readObject()) != null) {
            this.setReference(ref);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.ref);
    }

    public static class Ref
    implements Serializable {
        static final long serialVersionUID = 5543148876020730556L;
        private static final Object LOCK = new Object();
        private transient Set componentSet = new HashSet(7);

        protected Ref() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ref(CloneableTopComponent cloneableTopComponent) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.add(cloneableTopComponent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration getComponents() {
            HashSet hashSet;
            Object object = LOCK;
            synchronized (object) {
                hashSet = new HashSet(this.componentSet);
            }
            return Collections.enumeration(hashSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = LOCK;
            synchronized (object) {
                return this.componentSet.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloneableTopComponent getAnyComponent() {
            Object object = LOCK;
            synchronized (object) {
                return (CloneableTopComponent)this.componentSet.iterator().next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloneableTopComponent getArbitraryComponent() {
            TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
            Object object = LOCK;
            synchronized (object) {
                if (this.componentSet.contains(topComponent)) {
                    return (CloneableTopComponent)topComponent;
                }
                Iterator iterator = this.componentSet.iterator();
                if (iterator.hasNext()) {
                    return (CloneableTopComponent)iterator.next();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void register(CloneableTopComponent cloneableTopComponent) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.add(cloneableTopComponent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean unregister(CloneableTopComponent cloneableTopComponent) {
            int n;
            Object object = LOCK;
            synchronized (object) {
                if (!this.componentSet.contains(cloneableTopComponent)) {
                    return true;
                }
                n = this.componentSet.size();
            }
            if (n > 1 || cloneableTopComponent.closeLast()) {
                this.removeComponent(cloneableTopComponent);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeComponent(CloneableTopComponent cloneableTopComponent) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.remove(cloneableTopComponent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Object object = LOCK;
            synchronized (object) {
                this.componentSet = new HashSet(7);
            }
        }
    }
}

