/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.Keymap;
import org.netbeans.modules.openide.windows.GlobalActionContextImpl;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.windows.DefaultTopComponentLookup;
import org.openide.windows.DelegateActionMap;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class TopComponent
extends JComponent
implements Externalizable,
Accessible,
HelpCtx.Provider,
Lookup.Provider {
    static final long serialVersionUID = -3022538025284122942L;
    public static final int CLOSE_EACH = 0;
    public static final int CLOSE_LAST = 1;
    public static final int PERSISTENCE_ALWAYS = 0;
    public static final int PERSISTENCE_ONLY_OPENED = 1;
    public static final int PERSISTENCE_NEVER = 2;
    private static Object defaultLookupLock = new Object();
    private static final Set warnedTCPIClasses = new WeakSet();
    private static final Set warnedClasses = new WeakSet();
    private Object defaultLookupRef;
    private NodeName nodeName;
    private int closeOperation = 1;
    private transient Image icon;
    private transient Node[] activatedNodes;
    private transient String displayName;
    private String htmlDisplayName;
    short serialVersion = 1;
    private AttentionGetter attentionGetter = null;
    static /* synthetic */ Class class$org$openide$nodes$NodeListener;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$io$ObjectStreamException;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$openide$nodes$Node;

    public TopComponent() {
        this(null);
    }

    public TopComponent(Lookup lookup) {
        if (lookup != null) {
            this.setLookup(lookup, true);
        }
        this.enableEvents(8L);
        this.setFocusable(false);
        this.initActionMap();
    }

    private void initActionMap() {
        DelegateActionMap delegateActionMap = new DelegateActionMap(this, new ActionMap());
        if (this instanceof Cloneable) {
            ((ActionMap)delegateActionMap).put("cloneWindow", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TopComponent topComponent = ((Cloneable)((Object)TopComponent.this)).cloneComponent();
                    topComponent.open();
                    topComponent.requestActive();
                }
            });
        }
        ((ActionMap)delegateActionMap).put("closeWindow", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopComponent.this.close();
            }
        });
        this.setActionMap(delegateActionMap);
    }

    public static final Registry getRegistry() {
        return WindowManager.getDefault().getRegistry();
    }

    public final Node[] getActivatedNodes() {
        return this.activatedNodes;
    }

    public final void setActivatedNodes(Node[] nodeArray) {
        if (Arrays.equals(this.activatedNodes, nodeArray)) {
            return;
        }
        Lookup lookup = this.getLookup(false);
        if (lookup instanceof DefaultTopComponentLookup) {
            ((DefaultTopComponentLookup)lookup).updateLookups(nodeArray);
        }
        Node[] nodeArray2 = this.activatedNodes;
        this.activatedNodes = nodeArray;
        WindowManager.getDefault().topComponentActivatedNodesChanged(this, this.activatedNodes);
        this.firePropertyChange("activatedNodes", nodeArray2, this.activatedNodes);
    }

    public int getPersistenceType() {
        String string;
        if (warnedClasses.add(this.getClass()) && !TopComponent.class.equals(this.getClass())) {
            ErrorManager.getDefault().log(16, "Note - " + this.getClass().getName() + " ought to override getPersistenceType()" + " rather than using the client property or accepting the default.");
        }
        if ((string = (String)this.getClientProperty("PersistenceType")) == null) {
            return 0;
        }
        if ("Never".equals(string)) {
            return 2;
        }
        if ("OnlyOpened".equals(string)) {
            return 1;
        }
        return 0;
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void open() {
        this.open(null);
    }

    public void open(Workspace workspace) {
        WindowManager.getDefault().topComponentOpen(this);
    }

    public final boolean isOpened() {
        return this.isOpened(null);
    }

    public final boolean isOpened(Workspace workspace) {
        return WindowManager.getDefault().topComponentIsOpened(this);
    }

    public final boolean close() {
        return this.close(null);
    }

    public final boolean close(Workspace workspace) {
        if (!this.isOpened()) {
            return true;
        }
        if (this.canClose()) {
            WindowManager.getDefault().topComponentClose(this);
            return true;
        }
        return false;
    }

    public boolean canClose() {
        if (!this.isOpened()) {
            return false;
        }
        return this.canClose(null, true);
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        return true;
    }

    protected void openNotify() {
    }

    protected void closeNotify() {
    }

    public SystemAction[] getSystemActions() {
        return new SystemAction[0];
    }

    public Action[] getActions() {
        Action[] actionArray = WindowManager.getDefault().topComponentDefaultActions(this);
        SystemAction[] systemActionArray = this.getSystemActions();
        if (systemActionArray.length > 0) {
            ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(actionArray));
            arrayList.addAll(Arrays.asList(systemActionArray));
            return arrayList.toArray(new Action[0]);
        }
        return actionArray;
    }

    public final void setCloseOperation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(NbBundle.getBundle((Class)TopComponent.class).getString("EXC_UnknownOperation"));
        }
        if (this.closeOperation == n) {
            return;
        }
        this.closeOperation = n;
        this.firePropertyChange("closeOperation", null, null);
    }

    public final int getCloseOperation() {
        return this.closeOperation;
    }

    protected String preferredID() {
        String string;
        Class<?> clazz = this.getClass();
        if (this.getPersistenceType() != 2 && warnedTCPIClasses.add(clazz)) {
            ErrorManager.getDefault().log(16, "Warning: " + clazz.getName() + " should override preferredID()");
        }
        if ((string = this.getName()) == null) {
            int n = clazz.getName().lastIndexOf(46);
            string = n == -1 ? clazz.getName() : clazz.getName().substring(n + 1);
        }
        return string;
    }

    protected void componentOpened() {
        this.openNotify();
    }

    protected void componentClosed() {
        this.closeNotify();
    }

    protected void componentShowing() {
    }

    protected void componentHidden() {
    }

    protected void componentActivated() {
    }

    protected void componentDeactivated() {
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.isFocusable()) {
            return super.requestFocusInWindow();
        }
        return false;
    }

    public void requestActive() {
        WindowManager.getDefault().topComponentRequestActive(this);
    }

    public void toFront() {
        WindowManager.getDefault().topComponentToFront(this);
    }

    public void requestVisible() {
        WindowManager.getDefault().topComponentRequestVisible(this);
        GlobalActionContextImpl.blickActionMap(this.getActionMap());
    }

    public final void requestAttention(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TopComponent.this.attentionGetter != null && !bl) {
                    TopComponent.this.attentionGetter.kill();
                } else if (!bl) {
                    WindowManager.getDefault().topComponentRequestAttention(TopComponent.this);
                } else if (TopComponent.this.attentionGetter != null) {
                    TopComponent.this.attentionGetter.reset();
                } else {
                    TopComponent.this.attentionGetter = new AttentionGetter();
                }
            }
        });
    }

    public final void cancelRequestAttention() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TopComponent.this.attentionGetter != null) {
                    TopComponent.this.attentionGetter.stop();
                } else {
                    WindowManager.getDefault().topComponentCancelRequestAttention(TopComponent.this);
                }
            }
        });
    }

    public void setName(String string) {
        String string2 = this.getName();
        if (string != null && string.equals(string2)) {
            return;
        }
        super.setName(string);
        this.firePropertyChange("name", string2, string);
        WindowManager.getDefault().topComponentDisplayNameChanged(this, string);
    }

    public void setDisplayName(String string) {
        String string2 = this.displayName;
        if (string == string2 || string != null && string.equals(string2)) {
            return;
        }
        if (BasicHTML.isHTMLString(string)) {
            ErrorManager.getDefault().log(16, "WARNING: Call of " + this.getClass().getName() + ".setDisplayName(\"" + string + "\")" + " shouldn't contain any HTML tags. Please use " + this.getClass().getName() + ".setHtmlDisplayName(String)" + "for such purpose. For details please see http://www.netbeans.org/issues/show_bug.cgi?id=66777.");
        }
        this.displayName = string;
        this.firePropertyChange("displayName", string2, string);
        WindowManager.getDefault().topComponentDisplayNameChanged(this, string);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setHtmlDisplayName(String string) {
        String string2 = this.htmlDisplayName;
        if (string == string2 || string != null && string.equals(string2)) {
            return;
        }
        this.htmlDisplayName = string;
        this.firePropertyChange("htmlDisplayName", string2, string);
        WindowManager.getDefault().topComponentHtmlDisplayNameChanged(this, string);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public void setToolTipText(String string) {
        if (string != null && string.equals(this.getToolTipText())) {
            return;
        }
        super.setToolTipText(string);
        WindowManager.getDefault().topComponentToolTipChanged(this, string);
    }

    public void setIcon(Image image) {
        if (image == this.icon) {
            return;
        }
        Image image2 = this.icon;
        this.icon = image;
        WindowManager.getDefault().topComponentIconChanged(this, this.icon);
        this.firePropertyChange("icon", image2, image);
    }

    public Image getIcon() {
        return this.icon;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TopComponent.class);
    }

    public List availableModes(List list) {
        return list;
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        if (1 == n && !bl2 && !keyEvent.isConsumed()) {
            Object object;
            Action action;
            Keymap keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
            Action action2 = action = keymap != null ? keymap.getAction(keyStroke) : null;
            if (action == null) {
                return false;
            }
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(this.getLookup());
            } else if (SwingUtilities.getWindowAncestor(keyEvent.getComponent()) instanceof Dialog && !Boolean.TRUE.equals(object = action.getValue("OpenIDE-Transmodal-Action"))) {
                return false;
            }
            if (action.isEnabled()) {
                object = new ActionEvent(this, 1001, Utilities.keyToString((KeyStroke)keyStroke));
                action.actionPerformed((ActionEvent)object);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return true;
        }
        return bl2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Short(this.serialVersion));
        objectOutput.writeInt(this.closeOperation);
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.getToolTipText());
        if (this.getDisplayName() != null) {
            objectOutput.writeObject(this.getDisplayName());
        }
        Node node = this.nodeName == null ? null : this.nodeName.getNode();
        Node.Handle handle = node == null ? null : node.getHandle();
        objectOutput.writeObject(handle);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        if (object instanceof Integer) {
            this.serialVersion = 0;
            this.closeOperation = (Integer)object;
            objectInput.readObject();
            super.setName((String)objectInput.readObject());
            this.setToolTipText((String)objectInput.readObject());
        } else {
            Node.Handle handle;
            this.serialVersion = (Short)object;
            this.closeOperation = objectInput.readInt();
            super.setName((String)objectInput.readObject());
            this.setToolTipText((String)objectInput.readObject());
            Object object2 = objectInput.readObject();
            if (object2 instanceof String) {
                this.setDisplayName((String)object2);
                object2 = objectInput.readObject();
            }
            if ((handle = (Node.Handle)object2) != null) {
                Node node = handle.getNode();
                NodeName.connect(this, node);
            }
        }
        if (this.closeOperation != 0 && this.closeOperation != 1) {
            throw new IOException("invalid closeOperation: " + this.closeOperation);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Replacer(this);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return TopComponent.this.getName();
                }

                public String getToolTipText() {
                    return TopComponent.this.getToolTipText();
                }
            };
        }
        return this.accessibleContext;
    }

    public Lookup getLookup() {
        return this.getLookup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup getLookup(boolean bl) {
        Object object = defaultLookupLock;
        synchronized (object) {
            Object object2;
            if (this.defaultLookupRef instanceof Lookup) {
                return (Lookup)this.defaultLookupRef;
            }
            if (this.defaultLookupRef instanceof Object[]) {
                return (Lookup)((Object[])this.defaultLookupRef)[0];
            }
            if (this.defaultLookupRef instanceof Reference && (object2 = ((Reference)this.defaultLookupRef).get()) instanceof Lookup) {
                return (Lookup)object2;
            }
            if (!bl) {
                return null;
            }
            object2 = new DefaultTopComponentLookup(this);
            this.defaultLookupRef = new WeakReference(object2);
            return object2;
        }
    }

    protected final void associateLookup(Lookup lookup) {
        this.setLookup(lookup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setLookup(Lookup lookup, boolean bl) {
        Object object = defaultLookupLock;
        synchronized (object) {
            if (this.defaultLookupRef != null) {
                throw new IllegalStateException("Trying to set lookup " + lookup + " but there already is " + this.defaultLookupRef + " for component: " + this);
            }
            this.defaultLookupRef = lookup;
            if (bl) {
                this.defaultLookupRef = new Object[]{this.defaultLookupRef, new SynchronizeNodes(lookup)};
            }
        }
    }

    private void attachNodeName(NodeName nodeName) {
        this.nodeName = nodeName;
    }

    private class SynchronizeNodes
    implements LookupListener,
    Runnable {
        private Lookup.Result res;

        public SynchronizeNodes(Lookup lookup) {
            this.res = lookup.lookup(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = TopComponent.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node));
            this.res.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (TopComponent.this.isVisible() && SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            TopComponent.this.setActivatedNodes(this.res.allInstances().toArray(new Node[0]));
        }
    }

    private static final class Replacer
    implements Serializable {
        static final long serialVersionUID = -8897067133215740572L;
        transient TopComponent tc;

        public Replacer(TopComponent topComponent) {
            this.tc = topComponent;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
            objectOutputStream.writeObject(this.tc.getClass().getName());
            this.tc.writeExternal(objectOutputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            block13: {
                String string = (String)objectInputStream.readObject();
                string = Utilities.translate((String)string);
                try {
                    Class<?>[] classArray;
                    ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = TopComponent.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    Class<?> clazz = Class.forName(string, true, classLoader);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    try {
                        this.tc = (TopComponent)constructor.newInstance(new Object[0]);
                    }
                    finally {
                        constructor.setAccessible(false);
                    }
                    this.tc.readExternal(objectInputStream);
                    Method method = Replacer.findReadResolveMethod(clazz);
                    if (method == null || (classArray = method.getExceptionTypes()).length != 1 || !(class$java$io$ObjectStreamException == null ? (class$java$io$ObjectStreamException = TopComponent.class$("java.io.ObjectStreamException")) : class$java$io$ObjectStreamException).equals(classArray[0]) || !(class$java$lang$Object == null ? (class$java$lang$Object = TopComponent.class$("java.lang.Object")) : class$java$lang$Object).equals(method.getReturnType())) break block13;
                    method.setAccessible(true);
                    try {
                        TopComponent topComponent = this.tc;
                        this.tc = (TopComponent)method.invoke((Object)this.tc, (Object[])new Class[0]);
                        if (this.tc == null) {
                            throw new InvalidObjectException("TopComponent.readResolve() cannot return null. See http://www.netbeans.org/issues/show_bug.cgi?id=27849 for more info. TopComponent:" + topComponent);
                        }
                    }
                    finally {
                        method.setAccessible(false);
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable).getTargetException();
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    IOException iOException = new IOException(throwable.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)iOException, throwable);
                    throw iOException;
                }
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.tc;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method method = null;
            Class[] classArray = new Class[]{};
            try {
                method = clazz.getMethod("readResolve", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Class clazz2 = clazz; clazz2 != null && clazz2 != (class$org$openide$windows$TopComponent == null ? TopComponent.class$("org.openide.windows.TopComponent") : class$org$openide$windows$TopComponent); clazz2 = clazz2.getSuperclass()) {
                    try {
                        method = clazz2.getDeclaredMethod("readResolve", classArray);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        continue;
                    }
                }
            }
            return method;
        }
    }

    public static class NodeName
    extends NodeAdapter {
        private TopComponent top;
        private Reference node;
        private NodeListener nodeL;

        public static void connect(TopComponent topComponent, Node node) {
            new NodeName(topComponent).attach(node);
        }

        public NodeName(TopComponent topComponent) {
            this.top = topComponent;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node node;
            if (propertyChangeEvent.getPropertyName().equals("displayName") && (node = (Node)this.node.get()) != null) {
                this.top.setName(node.getDisplayName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attach(Node node) {
            TopComponent topComponent = this.top;
            synchronized (topComponent) {
                this.node = new WeakReference<Node>(node);
                this.nodeL = (NodeListener)WeakListeners.create((Class)(class$org$openide$nodes$NodeListener == null ? (class$org$openide$nodes$NodeListener = TopComponent.class$("org.openide.nodes.NodeListener")) : class$org$openide$nodes$NodeListener), (EventListener)((Object)this), (Object)node);
                node.addNodeListener(this.nodeL);
                this.top.attachNodeName(this);
                this.top.setActivatedNodes(new Node[]{node});
                this.top.setName(node.getDisplayName());
            }
        }

        private Node getNode() {
            return (Node)this.node.get();
        }
    }

    private class AttentionGetter
    implements ActionListener {
        Timer timer = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public AttentionGetter() {
            this.reset();
        }

        public void reset() {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            if (this.timer != null) {
                this.timer.stop();
            }
            this.start();
            this.timer = new Timer(3500, this);
            this.timer.setRepeats(false);
            this.timer.start();
        }

        private void start() {
            WindowManager.getDefault().topComponentRequestAttention(TopComponent.this);
        }

        public void kill() {
            this.timer.stop();
            TopComponent.this.attentionGetter = null;
        }

        private void stop() {
            if (this.timer != null) {
                this.timer.stop();
            }
            TopComponent.this.attentionGetter = null;
            WindowManager.getDefault().topComponentCancelRequestAttention(TopComponent.this);
            TopComponent.this.attentionGetter = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.stop();
        }

        static {
            $assertionsDisabled = !(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponent.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).desiredAssertionStatus();
        }
    }

    public static interface Registry {
        public static final String PROP_OPENED = "opened";
        public static final String PROP_ACTIVATED = "activated";
        public static final String PROP_CURRENT_NODES = "currentNodes";
        public static final String PROP_ACTIVATED_NODES = "activatedNodes";

        public Set getOpened();

        public TopComponent getActivated();

        public Node[] getCurrentNodes();

        public Node[] getActivatedNodes();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    public static interface Cloneable {
        public TopComponent cloneComponent();
    }
}

