/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web;

import com.vaadin.server.CustomizedSystemMessages;
import com.vaadin.server.SystemMessages;
import com.vaadin.server.SystemMessagesInfo;
import com.vaadin.server.SystemMessagesProvider;
import java.util.Locale;
import org.openthinclient.api.logs.LogMvcConfiguration;
import org.openthinclient.api.rest.ApplianceRestApiConfiguration;
import org.openthinclient.api.rest.RestApiConfiguration;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.web.SchemaService;
import org.openthinclient.web.VaadinCustomizationConfiguration;
import org.openthinclient.web.WebApplicationSecurityConfiguration;
import org.openthinclient.web.view.DashboardSections;
import org.openthinclient.web.view.dashboard.DashboardNotificationService;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.vaadin.spring.i18n.MessageProvider;
import org.vaadin.spring.i18n.ResourceBundleMessageProvider;
import org.vaadin.spring.sidebar.annotation.EnableSideBar;

@SpringBootApplication(exclude={SecurityAutoConfiguration.class})
@EnableSideBar
@Import(value={WebApplicationSecurityConfiguration.class, VaadinCustomizationConfiguration.class, RestApiConfiguration.class, ApplianceRestApiConfiguration.class, LogMvcConfiguration.class})
public class WebApplicationConfiguration {
    @Bean
    SystemMessagesProvider systemMessagesProvider() {
        return new SystemMessagesProvider(){
            private static final long serialVersionUID = 2570216527087874367L;

            public SystemMessages getSystemMessages(SystemMessagesInfo systemMessagesInfo) {
                CustomizedSystemMessages systemMessages = new CustomizedSystemMessages();
                systemMessages.setSessionExpiredNotificationEnabled(false);
                return systemMessages;
            }
        };
    }

    @Bean
    MessageProvider communicationMessages() {
        return new ResourceBundleMessageProvider("i18n/console-web-messages");
    }

    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver slr = new SessionLocaleResolver();
        slr.setDefaultLocale(Locale.GERMAN);
        return slr;
    }

    @Bean
    public DashboardSections dashboardSections() {
        return new DashboardSections();
    }

    @Bean
    public SchemaService schemaService(PackageManager packageManager, ApplicationService applicationService, SchemaProvider schemaProvider, RealmService realmService) {
        return new SchemaService(packageManager, applicationService, schemaProvider, realmService);
    }

    @Bean
    public DashboardNotificationService dashboardNotificationService() {
        return new DashboardNotificationService.Dummy();
    }
}

