/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.devices;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import javax.annotation.PostConstruct;
import org.openthinclient.api.rest.appliance.TokenManager;
import org.openthinclient.service.common.home.impl.ApplianceConfiguration;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.novnc.NoVNCComponent;
import org.openthinclient.web.ui.ViewHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="devices")
@SideBarItem(sectionId="device-management", captionCode="UI_DEVICEMANAGEMENT_HEADER", order=-100)
public class ManageDevicesView
extends Panel
implements View {
    private static final long serialVersionUID = -8836200902351197949L;
    final MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    final VerticalLayout root;
    @Autowired
    ApplianceConfiguration applianceConfiguration;
    @Autowired
    TokenManager tokenManager;

    public ManageDevicesView() {
        this.addStyleName("borderless");
        this.setSizeFull();
        this.root = new VerticalLayout();
        this.root.setSizeFull();
        this.root.setMargin(true);
        this.root.addStyleName("dashboard-view");
        this.setContent((Component)this.root);
        Responsive.makeResponsive((Component[])new Component[]{this.root});
        this.root.addComponent((Component)new ViewHeader(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICEMANAGEMENT_CONSOLE_ABOUT_HEADER, new Object[0])));
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICEMANAGEMENT_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        Component content = this.buildContent();
        this.root.addComponent(content);
        this.root.setExpandRatio(content, 1.0f);
    }

    private Component buildContent() {
        if (this.applianceConfiguration.isEnabled()) {
            return this.buildApplianceContent();
        }
        return this.buildPlaceholderContent();
    }

    private Component buildApplianceContent() {
        String host = this.applianceConfiguration.getNoVNCConsoleHostname();
        if (host == null || host.trim().isEmpty()) {
            host = UI.getCurrent().getPage().getLocation().getHost();
        }
        ExternalResource tr = new ExternalResource("/VAADIN/themes/dashboard/novnc/vnc.html?host=" + host + "&port=" + this.applianceConfiguration.getNoVNCConsolePort() + "&encrypt=" + (this.applianceConfiguration.isNoVNCConsoleEncrypted() ? "1" : "0") + "&allowfullscreen=" + this.applianceConfiguration.isNoVNCConsoleAllowfullscreen() + "&autoconnect=" + this.applianceConfiguration.isNoVNCConsoleAutoconnect() + "&path=?token=" + this.tokenManager.createToken(VaadinRequest.getCurrent().getRemoteAddr()));
        NoVNCComponent browser = new NoVNCComponent();
        browser.setNoVNCPageResource((Resource)tr);
        browser.setWidth("1100px");
        browser.setHeight("780px");
        Link linkOpen = new Link();
        linkOpen.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICEMANAGEMENT_CONSOLE_ABOUT_JNLP_LINK, new Object[0]));
        linkOpen.setResource((Resource)new ExternalResource("/console/launch.jnlp"));
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setMargin(false);
        verticalLayout.setSpacing(true);
        verticalLayout.addComponents(new Component[]{linkOpen, browser});
        return verticalLayout;
    }

    private Component buildPlaceholderContent() {
        HorizontalLayout content = new HorizontalLayout();
        Label labelDescription = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICEMANAGEMENT_CONSOLE_ABOUT_DESCRIPTION, new Object[0]), ContentMode.HTML);
        labelDescription.setStyleName("devicemanagement-description");
        VerticalLayout leftPane = new VerticalLayout();
        leftPane.setStyleName("devicemanagement-leftpane");
        Image image = new Image("", (Resource)new ThemeResource("./img/screenshot-manager.png"));
        image.setWidth(400.0f, Sizeable.Unit.PIXELS);
        leftPane.addComponent((Component)image);
        Link linkOpen = new Link();
        linkOpen.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICEMANAGEMENT_CONSOLE_ABOUT_LINK, new Object[0]));
        linkOpen.setResource((Resource)new ExternalResource("/console/launch.jnlp"));
        leftPane.addComponent((Component)linkOpen);
        content.addComponent((Component)leftPane);
        content.addComponent((Component)labelDescription);
        return content;
    }
}

