/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.filebrowser;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.server.FileResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.util.FileTypeResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import org.openthinclient.web.filebrowser.FileBrowserView;
import org.openthinclient.web.i18n.ConsoleWebMessages;

public class ContentViewSubWindow
extends Window {
    private static final long serialVersionUID = -6794768759901017749L;

    public ContentViewSubWindow(FileBrowserView fileBrowserView, Path doc) {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.addCloseListener((Window.CloseListener & Serializable)event -> UI.getCurrent().removeWindow((Window)this));
        this.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_VIEWFILE_CAPTION, new Object[]{doc.getFileName()}));
        this.setHeight("400px");
        this.setWidth("500px");
        this.center();
        VerticalLayout subContent = new VerticalLayout();
        subContent.setMargin(true);
        subContent.setSizeFull();
        this.setContent((Component)subContent);
        if (this.isImage(doc)) {
            Embedded image = new Embedded();
            image.setSource((Resource)new FileResource(doc.toFile()));
            subContent.addComponent((Component)image);
        } else {
            TextArea text = new TextArea();
            try {
                text.setValue(new String(Files.readAllBytes(doc.toAbsolutePath())));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read file " + doc.toAbsolutePath());
            }
            text.setSizeFull();
            subContent.addComponent((Component)text);
        }
    }

    private boolean isImage(Path doc) {
        String mimeType;
        switch (mimeType = FileTypeResolver.getMIMEType((File)doc.toFile())) {
            case "image/jpeg": 
            case "image/gif": 
            case "image/png": {
                return true;
            }
        }
        return false;
    }
}

