/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.filebrowser;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.google.common.base.Strings;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.AbstractBackEndHierarchicalDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.HierarchicalQuery;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.event.CollapseEvent;
import com.vaadin.event.ExpandEvent;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Extension;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.FileResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.shared.ui.grid.GridClientRpc;
import com.vaadin.shared.ui.grid.ScrollDestination;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TreeGrid;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.components.grid.ItemClickListener;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.DateRenderer;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.util.FileTypeResolver;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.openthinclient.meta.Bookmark;
import org.openthinclient.meta.PackageMetadataManager;
import org.openthinclient.meta.PackageMetadataUtil;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.filebrowser.ContentViewSubWindow;
import org.openthinclient.web.filebrowser.CreateDirectorySubWindow;
import org.openthinclient.web.filebrowser.FileUploadSubWindow;
import org.openthinclient.web.filebrowser.RemoveItemSubWindow;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.ViewHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="filebrowser")
@SideBarItem(sectionId="common", captionCode="UI_FILEBROWSER_HEADER", order=99)
public final class FileBrowserView
extends Panel
implements View {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBrowserView.class);
    public static final String ICON_PREFIX_VAADIN = "vaadin:";
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private PackageMetadataManager metadataManager;
    @Autowired
    private EventBus.SessionEventBus eventBus;
    private final IMessageConveyor mc;
    private final VerticalLayout root;
    private VerticalLayout content;
    private Button removeDirButton;
    private Path selectedFileItem;
    private Button contentButton;
    private Button createDirButton;
    private Button downloadButton;
    private Button uploadButton;
    private TreeGrid<File> docList;
    private Window subWindow;
    private FileSystemDataProvider dataProvider;
    private ComboBox<Bookmark> bookmarkComboBox;
    private List<File> visibleItems = new ArrayList<File>();

    public FileBrowserView() {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.addStyleName("borderless");
        this.setSizeFull();
        this.root = new VerticalLayout();
        this.root.setSizeFull();
        this.root.setMargin(false);
        this.root.addStyleName("dashboard-view");
        this.setContent((Component)this.root);
        Responsive.makeResponsive((Component[])new Component[]{this.root});
        this.root.addComponent((Component)new ViewHeader(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_HEADER, new Object[0])));
    }

    public static boolean isMimeTypeSupported(String mimeType) {
        switch (mimeType) {
            case "text/plain": 
            case "text/xml": 
            case "text/html": 
            case "image/png": 
            case "image/gif": 
            case "image/jpg": 
            case "image/jpeg": {
                return true;
            }
        }
        return false;
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        Component content = this.buildContent();
        this.root.addComponent(content);
        this.root.setExpandRatio(content, 1.0f);
    }

    private Component buildContent() {
        LOGGER.debug("Managing files from ", (Object)this.managerHome.getLocation());
        this.selectedFileItem = this.managerHome.getLocation().toPath();
        this.content = new VerticalLayout();
        this.content.setSpacing(true);
        this.content.setMargin(new MarginInfo(false, true, false, false));
        this.content.setSizeFull();
        HorizontalLayout controlBar = new HorizontalLayout();
        controlBar.setSpacing(true);
        this.contentButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_BUTTON_VIEWCONTENT, new Object[0]), (Button.ClickListener & Serializable)event -> this.showSubwindow(new ContentViewSubWindow(this, this.selectedFileItem)));
        this.contentButton.setEnabled(false);
        this.contentButton.setIcon((Resource)FontAwesome.EYE);
        this.contentButton.addStyleName("icon-only");
        controlBar.addComponent((Component)this.contentButton);
        this.createDirButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_BUTTON_MKDIR, new Object[0]), (Button.ClickListener & Serializable)event -> this.showSubwindow(new CreateDirectorySubWindow(this, this.selectedFileItem, this.managerHome.getLocation().toPath())));
        this.createDirButton.setIcon((Resource)FontAwesome.FOLDER_O);
        this.createDirButton.addStyleName("icon-only");
        controlBar.addComponent((Component)this.createDirButton);
        this.removeDirButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_BUTTON_RMDIR, new Object[0]), (Button.ClickListener & Serializable)event -> this.showSubwindow(new RemoveItemSubWindow(this, this.selectedFileItem)));
        this.removeDirButton.setIcon((Resource)FontAwesome.TIMES);
        this.removeDirButton.addStyleName("icon-only");
        this.removeDirButton.setEnabled(false);
        controlBar.addComponent((Component)this.removeDirButton);
        CssLayout groupUploadDownload = new CssLayout();
        groupUploadDownload.addStyleName("v-component-group");
        this.downloadButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_BUTTON_DOWNLOAD, new Object[0]));
        this.downloadButton.setIcon((Resource)FontAwesome.DOWNLOAD);
        this.downloadButton.addStyleName("icon-only");
        this.downloadButton.setEnabled(false);
        groupUploadDownload.addComponent((Component)this.downloadButton);
        this.uploadButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_BUTTON_UPLOAD, new Object[0]), (Button.ClickListener & Serializable)event -> this.showSubwindow(new FileUploadSubWindow(this, this.selectedFileItem, this.managerHome.getLocation().toPath())));
        this.uploadButton.setIcon((Resource)FontAwesome.UPLOAD);
        this.uploadButton.addStyleName("icon-only");
        groupUploadDownload.addComponent((Component)this.uploadButton);
        controlBar.addComponent((Component)groupUploadDownload);
        this.bookmarkComboBox = new ComboBox();
        this.bookmarkComboBox.setTextInputAllowed(false);
        this.bookmarkComboBox.setPlaceholder(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_BOOKMARKS, new Object[0]));
        this.bookmarkComboBox.setEmptySelectionAllowed(true);
        this.bookmarkComboBox.setItemIconGenerator(FileBrowserView::resolveIcon);
        this.bookmarkComboBox.setItemCaptionGenerator(this::resolveBookmarkLabel);
        this.bookmarkComboBox.setItems(this.metadataManager.getBookmarks());
        this.bookmarkComboBox.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.bookmarkComboBox.addValueChangeListener(this::navigatoToBookmark);
        controlBar.addComponent(this.bookmarkComboBox);
        controlBar.setExpandRatio(this.bookmarkComboBox, 1.0f);
        controlBar.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.content.addComponent((Component)controlBar);
        this.createTreeGrid();
        this.content.addComponent(this.docList);
        this.content.setExpandRatio(this.docList, 1.0f);
        return this.content;
    }

    private void navigatoToBookmark(HasValue.ValueChangeEvent<Bookmark> e) {
        if (e.isUserOriginated()) {
            Path targetPath;
            Bookmark bookmark = (Bookmark)e.getValue();
            if (bookmark != null) {
                Path path = Paths.get(bookmark.getPath(), new String[0]);
                targetPath = this.managerHome.getLocation().toPath().resolve(path);
            } else {
                targetPath = this.managerHome.getLocation().toPath();
            }
            this.refresh(targetPath);
        }
    }

    private String resolveBookmarkLabel(Bookmark bookmark) {
        UI ui;
        Locale locale = this.getLocale();
        if (locale == null && (ui = UI.getCurrent()) != null) {
            locale = ui.getLocale();
        }
        return PackageMetadataUtil.resolveLabel((Locale)locale, (Bookmark)bookmark);
    }

    static Resource resolveIcon(Bookmark bookmark) {
        if (!Strings.isNullOrEmpty((String)bookmark.getIcon()) && bookmark.getIcon().startsWith(ICON_PREFIX_VAADIN)) {
            String icon = bookmark.getIcon().substring(ICON_PREFIX_VAADIN.length());
            try {
                return VaadinIcons.valueOf((String)icon.toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("Non existing icon requested: " + icon, (Throwable)e);
            }
        }
        return null;
    }

    private void showSubwindow(Window windowToShow) {
        UI.getCurrent().removeWindow(this.subWindow);
        this.subWindow = windowToShow;
        UI.getCurrent().addWindow(this.subWindow);
    }

    private void createTreeGrid() {
        this.docList = new TreeGrid(){

            public void scrollTo(int row, ScrollDestination destination) {
                Objects.requireNonNull(destination, "ScrollDestination can not be null");
                ((GridClientRpc)this.getRpcProxy(GridClientRpc.class)).scrollToRow(row, destination);
            }
        };
        this.dataProvider = new FileSystemDataProvider(this.managerHome.getLocation());
        this.visibleItems = this.dataProvider.fetchChildrenFromBackEnd((HierarchicalQuery<File, FilenameFilter>)new HierarchicalQuery(null, (Object)this.managerHome.getLocation())).collect(Collectors.toList());
        this.docList.setDataProvider((DataProvider)this.dataProvider);
        this.docList.setSizeFull();
        this.docList.addItemClickListener((ItemClickListener & Serializable)event -> this.onSelectedFileItemChanged((File)event.getItem()));
        this.docList.addCollapseListener((CollapseEvent.CollapseListener & Serializable)event -> this.visibleItems.removeAll(this.getCollapsedChilds((File)event.getCollapsedItem())));
        this.docList.addExpandListener((ExpandEvent.ExpandListener & Serializable)event -> {
            File item = (File)event.getExpandedItem();
            List<File> childrenExpanded = this.getExpandedChilds(item);
            this.visibleItems.addAll(this.visibleItems.indexOf(item) + 1, childrenExpanded);
        });
        this.docList.addColumn((ValueProvider & Serializable)file -> {
            String iconHtml = file.isDirectory() ? VaadinIcons.FOLDER_O.getHtml() : VaadinIcons.FILE_O.getHtml();
            return iconHtml + " " + Jsoup.clean((String)file.getName(), (Whitelist)Whitelist.simpleText());
        }, (AbstractRenderer)new HtmlRenderer()).setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_COLUMN_NAME, new Object[0])).setId("file-name");
        this.docList.addColumn((ValueProvider & Serializable)file -> file.isDirectory() ? "--" : file.length() + " bytes").setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_COLUMN_SIZE, new Object[0])).setId("file-size");
        this.docList.addColumn((ValueProvider & Serializable)file -> new Date(file.lastModified()), (AbstractRenderer)new DateRenderer()).setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_COLUMN_MODIFIED, new Object[0])).setId("file-last-modified");
        this.docList.setHierarchyColumn("file-name");
    }

    private List<File> getCollapsedChilds(File item) {
        ArrayList<File> collapsedChilds = new ArrayList<File>();
        this.dataProvider.fetchChildrenFromBackEnd((HierarchicalQuery<File, FilenameFilter>)new HierarchicalQuery(null, (Object)item)).forEach(child -> {
            collapsedChilds.add((File)child);
            if (this.docList.isExpanded(child)) {
                collapsedChilds.addAll(this.getCollapsedChilds((File)child));
            }
        });
        return collapsedChilds;
    }

    private List<File> getExpandedChilds(File item) {
        ArrayList<File> expandedChilds = new ArrayList<File>();
        this.dataProvider.fetchChildrenFromBackEnd((HierarchicalQuery<File, FilenameFilter>)new HierarchicalQuery(null, (Object)item)).forEach(child -> {
            expandedChilds.add((File)child);
            if (this.docList.isExpanded(child)) {
                expandedChilds.addAll(expandedChilds.indexOf(child) + 1, this.getExpandedChilds((File)child));
            }
        });
        return expandedChilds;
    }

    public void refresh(Path expand) {
        this.selectedFileItem = expand;
        this.dataProvider.refreshAll();
        if (expand != null) {
            File managerHome = this.managerHome.getLocation();
            Path directory = Files.isDirectory(expand, new LinkOption[0]) ? expand : expand.getParent();
            ArrayList<File> pathsToExpand = new ArrayList<File>();
            while (!directory.equals(managerHome.toPath())) {
                File file = directory.toFile();
                if (!this.docList.isExpanded((Object)file)) {
                    pathsToExpand.add(file);
                }
                directory = directory.getParent();
            }
            Collections.reverse(pathsToExpand);
            this.docList.expand(pathsToExpand);
            int indexOf = this.visibleItems.indexOf(expand.toFile());
            this.docList.scrollTo(indexOf, ScrollDestination.START);
            if (expand.equals(managerHome.toPath())) {
                this.selectedFileItem = null;
                this.docList.deselectAll();
                try {
                    Files.newDirectoryStream(managerHome.toPath(), path -> path.toFile().isDirectory()).forEach(path -> this.docList.collapse((Object[])new File[]{path.toFile()}));
                }
                catch (IOException e) {
                    LOGGER.error("Error occurred while resolving directories in managerHome: " + e.getMessage());
                }
            } else {
                this.docList.select((Object)expand.toFile());
            }
            this.enableOrDisableButtons();
        }
    }

    private void onSelectedFileItemChanged(File value) {
        Optional<Bookmark> bookmarkExists;
        this.selectedFileItem = value != null ? value.toPath() : null;
        this.enableOrDisableButtons();
        new ArrayList<Extension>(this.downloadButton.getExtensions()).forEach(ex -> this.downloadButton.removeExtension(ex));
        if (this.selectedFileItem != null && Files.isRegularFile(this.selectedFileItem, new LinkOption[0])) {
            FileDownloader fileDownloader = new FileDownloader((Resource)new FileResource(this.selectedFileItem.toFile()));
            fileDownloader.setOverrideContentType(false);
            fileDownloader.extend((AbstractComponent)this.downloadButton);
        }
        if ((bookmarkExists = this.metadataManager.getBookmarks().filter(bookmark -> this.selectedFileItem.toAbsolutePath().equals(this.managerHome.getLocation().toPath().resolve(Paths.get(bookmark.getPath(), new String[0])))).findFirst()).isPresent()) {
            this.bookmarkComboBox.setValue((Object)bookmarkExists.get());
        } else {
            this.bookmarkComboBox.setValue(null);
        }
    }

    private void enableOrDisableButtons() {
        this.contentButton.setEnabled(this.selectedFileItem != null && FileBrowserView.isMimeTypeSupported(FileTypeResolver.getMIMEType((File)this.selectedFileItem.toFile())));
        this.removeDirButton.setEnabled(this.selectedFileItem != null);
        this.downloadButton.setEnabled(this.selectedFileItem != null);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }

    class FileSystemDataProvider
    extends AbstractBackEndHierarchicalDataProvider<File, FilenameFilter> {
        private final Comparator<File> nameComparator = (fileA, fileB) -> String.CASE_INSENSITIVE_ORDER.compare(fileA.getName(), fileB.getName());
        private final Comparator<File> sizeComparator = Comparator.comparingLong(File::length);
        private final Comparator<File> lastModifiedComparator = Comparator.comparingLong(File::lastModified);
        private final File root;

        public FileSystemDataProvider(File root) {
            this.root = root;
        }

        public int getChildCount(HierarchicalQuery<File, FilenameFilter> query) {
            return (int)this.fetchChildren(query).count();
        }

        protected Stream<File> fetchChildrenFromBackEnd(HierarchicalQuery<File, FilenameFilter> query) {
            File parent = query.getParentOptional().orElse(this.root);
            Stream<File> filteredFiles = query.getFilter().map(filter -> Stream.of(parent.listFiles((FilenameFilter)filter))).orElse(Stream.of(parent.listFiles())).skip(query.getOffset()).limit(query.getLimit());
            return this.sortFileStream(filteredFiles, query.getSortOrders());
        }

        public boolean hasChildren(File item) {
            return item.list() != null && item.list().length > 0;
        }

        private Stream<File> sortFileStream(Stream<File> fileStream, List<QuerySortOrder> sortOrders) {
            if (sortOrders.isEmpty()) {
                return fileStream;
            }
            List comparators = sortOrders.stream().map(sortOrder -> {
                Comparator<File> comparator = null;
                if (sortOrder.getSorted().equals("file-name")) {
                    comparator = this.nameComparator;
                } else if (sortOrder.getSorted().equals("file-size")) {
                    comparator = this.sizeComparator;
                } else if (sortOrder.getSorted().equals("file-last-modified")) {
                    comparator = this.lastModifiedComparator;
                }
                if (comparator != null && sortOrder.getDirection() == SortDirection.DESCENDING) {
                    comparator = comparator.reversed();
                }
                return comparator;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (comparators.isEmpty()) {
                return fileStream;
            }
            Comparator first = (Comparator)comparators.remove(0);
            Comparator combinedComparators = comparators.stream().reduce(first, Comparator::thenComparing);
            return fileStream.sorted(combinedComparators);
        }
    }
}

