/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.filebrowser;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.openthinclient.web.filebrowser.FileBrowserView;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveItemSubWindow
extends Window {
    private static final long serialVersionUID = 9051875905013039615L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveItemSubWindow.class);

    public RemoveItemSubWindow(FileBrowserView fileBrowserView, Path doc) {
        this.addCloseListener((Window.CloseListener & Serializable)event -> UI.getCurrent().removeWindow((Window)this));
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_REMOVE_CAPTION, new Object[]{""}));
        this.setHeight("140px");
        this.setWidth("500px");
        this.center();
        VerticalLayout subContent = new VerticalLayout();
        subContent.setMargin(true);
        subContent.setSizeFull();
        this.setContent((Component)subContent);
        Label tf = new Label(doc.getFileName().toString());
        subContent.addComponent((Component)tf);
        subContent.addComponent((Component)new Button(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_REMOVE_CAPTION, new Object[0]), arg_0 -> this.lambda$new$cc8c409c$1(doc, fileBrowserView, (IMessageConveyor)mc, arg_0)));
    }

    private /* synthetic */ void lambda$new$cc8c409c$1(Path doc, FileBrowserView fileBrowserView, IMessageConveyor mc, Button.ClickEvent event) {
        LOGGER.debug("Remove directory: ", (Object)doc);
        try {
            Path parent = doc.getParent();
            Files.delete(doc);
            fileBrowserView.refresh(parent);
        }
        catch (Exception exception) {
            if (exception instanceof DirectoryNotEmptyException) {
                Notification.show((String)mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_REMOVE_FOLDERNOTEMPTY, new Object[]{doc.getFileName().toString()}), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
            Notification.show((String)mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_REMOVE_FAIL, new Object[]{doc.getFileName().toString()}), (Notification.Type)Notification.Type.ERROR_MESSAGE);
        }
        this.close();
    }
}

