/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui;

import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.ui.AbstractLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.op.InstallPlanStep;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.util.dpkg.PackageReference;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.AbstractSummaryDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.viritin.layouts.MVerticalLayout;

public class InstallationPlanSummaryDialog
extends AbstractSummaryDialog {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_PACKAGE_NAME = "packageName";
    public static final String PROPERTY_PACKAGE_VERSION = "packageVersion";
    public static final String PROPERTY_INSTALLED_VERSION = "newVersion";
    private static final Logger LOG = LoggerFactory.getLogger(InstallationPlanSummaryDialog.class);
    private static final String PROPERTY_ICON = "icon";
    private final List<Runnable> onInstallListeners;
    private final Map<GridTypes, Grid<InstallationSummary>> tables;
    private final PackageManagerOperation packageManagerOperation;
    private final PackageManager packageManager;
    private final CheckBox licenseAgreementCheckBox = new CheckBox();
    private final TextArea licenceTextArea = new TextArea();
    private final List<Button> licenceButtons = new ArrayList<Button>();
    private AbstractLayout updateServerHint;

    public InstallationPlanSummaryDialog(PackageManagerOperation packageManagerOperation, PackageManager packageManager) {
        this.packageManager = packageManager;
        this.packageManagerOperation = packageManagerOperation;
        this.tables = new HashMap<GridTypes, Grid<InstallationSummary>>();
        this.proceedButton.setCaption(this.getActionButtonCaption());
        this.proceedButton.setEnabled(packageManagerOperation.getUnresolved().isEmpty() && packageManagerOperation.getConflicts().isEmpty());
        this.onInstallListeners = new ArrayList<Runnable>(2);
    }

    @Override
    protected void onCancel() {
        this.close();
    }

    private String getActionButtonCaption() {
        String actionButtonCaption = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_INSTALL_BUTTON_CAPTION, new Object[0]);
        if (this.packageManagerOperation.hasPackagesToUninstall()) {
            actionButtonCaption = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_UNINSTALL_BUTTON_CAPTION, new Object[0]);
        }
        return actionButtonCaption;
    }

    private String getHeadlineText() {
        String headlineText = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_INSTALL_HEADLINE, new Object[0]);
        if (this.packageManagerOperation.hasPackagesToUninstall()) {
            headlineText = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_UNINSTALL_HEADLINE, new Object[0]);
        }
        return headlineText;
    }

    @Override
    protected void createContent(MVerticalLayout content) {
        content.setStyleName("installationplansummary");
        Label l = new Label(this.getHeadlineText());
        l.addStyleName("huge");
        l.addStyleName("colored");
        content.addComponent((Component)l);
        this.tables.put(GridTypes.INSTALL_UNINSTALL, this.createTable(GridTypes.INSTALL_UNINSTALL));
        content.addComponent((Component)new Label(this.getActionButtonCaption() + " " + this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_ITEMS, new Object[0])));
        content.addComponent((Component)this.tables.get((Object)GridTypes.INSTALL_UNINSTALL));
        if (!this.packageManagerOperation.getConflicts().isEmpty()) {
            this.tables.put(GridTypes.CONFLICTS, this.createTable(GridTypes.CONFLICTS));
            content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_CONFLICTS, new Object[0])));
            content.addComponent((Component)this.tables.get((Object)GridTypes.CONFLICTS));
        }
        if (!this.packageManagerOperation.getUnresolved().isEmpty()) {
            this.tables.put(GridTypes.UNRESOVED, this.createTable(GridTypes.UNRESOVED));
            if (this.packageManagerOperation.hasPackagesToUninstall()) {
                content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_DEPENDING_PACKAGE, new Object[0])));
            } else {
                content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_UNRESOLVED, new Object[0])));
            }
            content.addComponent((Component)this.tables.get((Object)GridTypes.UNRESOVED));
        }
        if (!this.packageManagerOperation.getSuggested().isEmpty()) {
            this.tables.put(GridTypes.SUGGESTED, this.createTable(GridTypes.SUGGESTED));
            content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_SUGGESTED, new Object[0])));
            content.addComponent((Component)this.tables.get((Object)GridTypes.SUGGESTED));
        }
        this.licenceTextArea.addStyleNames(new String[]{"otc-content-wrap", "license-area"});
        this.licenceTextArea.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.licenceTextArea.setVisible(false);
        content.add(new Component[]{this.licenceTextArea});
        if (this.containsLicenseAgreement()) {
            content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_INSTALLATIONPLAN_LICENSE_CAPTION, new Object[0])));
            this.licenseAgreementCheckBox.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_LICENSE_CHECKBOX_CAPTION, new Object[0]));
            if (this.proceedButton.isEnabled()) {
                this.proceedButton.setEnabled(false);
                this.licenseAgreementCheckBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.proceedButton.setEnabled(((Boolean)e.getValue()).booleanValue()));
            } else {
                this.licenseAgreementCheckBox.setEnabled(false);
            }
            content.addComponent((Component)this.licenseAgreementCheckBox);
        }
        this.updateServerHint = new CssLayout();
        this.updateServerHint.addStyleName("update-server-hint");
        this.updateServerHint.setVisible(false);
        Label label = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_MANAGER_TOO_OLD, new Object[0]));
        label.setContentMode(ContentMode.HTML);
        Button link = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_MANAGER_TOO_OLD_CHECK_BUTTON, new Object[0]));
        link.addClickListener((Button.ClickListener & Serializable)e -> {
            UI.getCurrent().getNavigator().navigateTo("support");
            ArrayList windows = new ArrayList(UI.getCurrent().getWindows());
            windows.forEach(arg_0 -> ((UI)UI.getCurrent()).removeWindow(arg_0));
        });
        this.updateServerHint.addComponents(new Component[]{label, link});
        content.add(new Component[]{this.updateServerHint});
    }

    private Grid<InstallationSummary> createTable(GridTypes type) {
        Grid summary = new Grid();
        summary.setDataProvider((DataProvider)DataProvider.ofCollection((Collection)Collections.EMPTY_LIST));
        summary.setSelectionMode(Grid.SelectionMode.NONE);
        summary.addColumn(InstallationSummary::getPackageName).setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_NAME, new Object[0]));
        summary.addColumn(InstallationSummary::getPackageVersion).setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_VERSION, new Object[0]));
        if (type == GridTypes.INSTALL_UNINSTALL && !this.packageManagerOperation.hasPackagesToUninstall()) {
            summary.addComponentColumn((ValueProvider & Serializable)is -> {
                if (is.getLicense() != null) {
                    Button button = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_LICENSE_SHOW, new Object[0]));
                    button.addClickListener((Button.ClickListener & Serializable)click -> {
                        this.licenceButtons.stream().filter(b -> !b.equals((Object)button)).forEach(b -> {
                            if (b.getCaption().equals(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_LICENSE_HIDE, new Object[0]))) {
                                b.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_LICENSE_SHOW, new Object[0]));
                            }
                        });
                        if (button.getCaption().equals(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_LICENSE_SHOW, new Object[0]))) {
                            this.licenceTextArea.setVisible(true);
                            this.licenceTextArea.setValue(is.getLicense());
                        } else {
                            this.licenceTextArea.setVisible(false);
                        }
                        button.setCaption(this.licenceTextArea.isVisible() ? this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_LICENSE_HIDE, new Object[0]) : this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_LICENSE_SHOW, new Object[0]));
                    });
                    button.addStyleName("package_install_summary_display_license_button");
                    this.licenceButtons.add(button);
                    return button;
                }
                return null;
            }).setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_LICENSE, new Object[0]));
        }
        summary.addStyleName("borderless");
        summary.addStyleName("no-header");
        summary.addStyleName("no-vertical-lines");
        summary.addStyleName("no-horizontal-lines");
        summary.setHeightMode(HeightMode.ROW);
        summary.addStyleName("scrollable");
        return summary;
    }

    @Override
    public void update() {
        Grid<InstallationSummary> suggestedTable;
        Grid<InstallationSummary> unresolvedTable;
        Grid<InstallationSummary> installTable = this.tables.get((Object)GridTypes.INSTALL_UNINSTALL);
        ArrayList<Object> installationSummaries = new ArrayList<Object>();
        for (InstallPlanStep step : this.packageManagerOperation.getInstallPlan().getSteps()) {
            Package pkg2;
            InstallationSummary is2 = new InstallationSummary();
            if (step instanceof InstallPlanStep.PackageInstallStep) {
                pkg2 = ((InstallPlanStep.PackageInstallStep)step).getPackage();
                is2.setIcon((Resource)VaadinIcons.DOWNLOAD);
            } else if (step instanceof InstallPlanStep.PackageUninstallStep) {
                pkg2 = ((InstallPlanStep.PackageUninstallStep)step).getInstalledPackage();
                is2.setIcon((Resource)VaadinIcons.TRASH);
            } else if (step instanceof InstallPlanStep.PackageVersionChangeStep) {
                pkg2 = ((InstallPlanStep.PackageVersionChangeStep)step).getTargetPackage();
                Package installedPackage = ((InstallPlanStep.PackageVersionChangeStep)step).getInstalledPackage();
                is2.setInstalledVersion(installedPackage.getVersion().toStringWithoutEpoch());
                if (installedPackage.getVersion().compareTo((Object)pkg2.getVersion()) < 0) {
                    is2.setIcon((Resource)VaadinIcons.ARROW_CIRCLE_UP_O);
                } else {
                    is2.setIcon((Resource)VaadinIcons.ARROW_CIRCLE_DOWN_O);
                }
            } else {
                LOG.error("Unsupported type of Install Plan Step:" + step);
                continue;
            }
            is2.setPackageName(pkg2.getName());
            is2.setPackageVersion(pkg2.getVersion().toStringWithoutEpoch());
            is2.setLicense(pkg2.getLicense());
            installationSummaries.add(is2);
        }
        installTable.setDataProvider((DataProvider)DataProvider.ofCollection(installationSummaries));
        this.setGridHeight(installTable, installationSummaries.size());
        Grid<InstallationSummary> conflictsTable = this.tables.get((Object)GridTypes.CONFLICTS);
        if (conflictsTable != null) {
            ArrayList<InstallationSummary> conflictsSummaries = new ArrayList<InstallationSummary>();
            for (PackageManagerOperation.PackageConflict conflict : this.packageManagerOperation.getConflicts()) {
                Package pkg3 = conflict.getConflicting();
                Optional<InstallationSummary> any = conflictsSummaries.stream().filter(is -> ((InstallationSummary)is).packageName.equals(pkg3.getName()) && ((InstallationSummary)is).packageVersion.equals(pkg3.getVersion().toString())).findAny();
                if (!any.isPresent()) {
                    conflictsSummaries.add(new InstallationSummary(pkg3.getName(), pkg3.getVersion() != null ? pkg3.getDisplayVersion() : "", pkg3.getLicense()));
                }
                if (!pkg3.getName().equals("openthinclient-manager-version")) continue;
                this.updateServerHint.setVisible(true);
            }
            conflictsTable.setDataProvider((DataProvider)DataProvider.ofCollection(conflictsSummaries));
            this.setGridHeight(conflictsTable, conflictsSummaries.size());
        }
        if ((unresolvedTable = this.tables.get((Object)GridTypes.UNRESOVED)) != null) {
            ArrayList<InstallationSummary> unresolvedSummaries = new ArrayList<InstallationSummary>();
            for (PackageManagerOperation.UnresolvedDependency unresolvedDep : this.packageManagerOperation.getUnresolved()) {
                if (this.packageManagerOperation.hasPackagesToUninstall()) {
                    Package pkg4 = unresolvedDep.getSource();
                    if (pkg4 == null) continue;
                    unresolvedSummaries.add(new InstallationSummary(pkg4.getName(), pkg4.getVersion() != null ? pkg4.getDisplayVersion() : "", pkg4.getLicense()));
                    continue;
                }
                if (!(unresolvedDep.getMissing() instanceof PackageReference.SingleReference)) continue;
                PackageReference.SingleReference missing = (PackageReference.SingleReference)unresolvedDep.getMissing();
                unresolvedSummaries.add(new InstallationSummary(missing.getName(), missing.getVersion() != null ? missing.getVersion().toStringWithoutEpoch() : "", null));
                if (!missing.getName().equals("openthinclient-manager-version")) continue;
                this.updateServerHint.setVisible(true);
            }
            unresolvedTable.setDataProvider((DataProvider)DataProvider.ofCollection(unresolvedSummaries));
            this.setGridHeight(unresolvedTable, unresolvedSummaries.size());
        }
        if ((suggestedTable = this.tables.get((Object)GridTypes.SUGGESTED)) != null) {
            suggestedTable.setDataProvider((DataProvider)DataProvider.ofCollection((Collection)this.packageManagerOperation.getSuggested().stream().map(pkg -> new InstallationSummary(pkg.getName(), pkg.getVersion().toStringWithoutEpoch(), pkg.getLicense())).collect(Collectors.toList())));
            this.setGridHeight(suggestedTable, this.packageManagerOperation.getSuggested().size());
        }
    }

    private boolean containsLicenseAgreement() {
        for (InstallPlanStep step : this.packageManagerOperation.getInstallPlan().getSteps()) {
            Package pkg;
            if (step instanceof InstallPlanStep.PackageInstallStep) {
                pkg = ((InstallPlanStep.PackageInstallStep)step).getPackage();
            } else {
                if (!(step instanceof InstallPlanStep.PackageVersionChangeStep)) continue;
                pkg = ((InstallPlanStep.PackageVersionChangeStep)step).getTargetPackage();
            }
            if (pkg.getLicense() == null) continue;
            return true;
        }
        return false;
    }

    private void setGridHeight(Grid grid, int size) {
        grid.setWidth("100%");
        if (size == 0) {
            grid.setHeight(39.0f, Sizeable.Unit.PIXELS);
        } else {
            grid.setHeightByRows((double)size);
        }
    }

    private Package getPackage(PackageReference packageReference) {
        List installableAndExistingPackages = Stream.concat(this.packageManager.getInstalledPackages().stream(), this.packageManager.getInstallablePackages().stream()).collect(Collectors.toList());
        for (Package _package : installableAndExistingPackages) {
            if (!packageReference.matches(_package)) continue;
            return _package;
        }
        return null;
    }

    @Override
    protected void onProceed() {
        this.close();
        this.onInstallListeners.forEach(Runnable::run);
    }

    public void onInstallClicked(Runnable runnable) {
        this.onInstallListeners.add(runnable);
    }

    class InstallationSummary {
        private Resource icon;
        private Class propertyType;
        private String packageName;
        private String packageVersion;
        private String installedVersion;
        private String license;

        public InstallationSummary() {
        }

        public InstallationSummary(String pkgName, String packageVersion, String license) {
            this.packageName = pkgName;
            this.packageVersion = packageVersion;
            this.license = license;
        }

        public Resource getIcon() {
            return this.icon;
        }

        public void setIcon(Resource icon) {
            this.icon = icon;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public void setPropertyType(Class propertyType) {
            this.propertyType = propertyType;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }

        public void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        public String getInstalledVersion() {
            return this.installedVersion;
        }

        public void setInstalledVersion(String installedVersion) {
            this.installedVersion = installedVersion;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.license = license;
        }
    }

    static enum GridTypes {
        INSTALL_UNINSTALL,
        CONFLICTS,
        UNRESOVED,
        SUGGESTED;

    }
}

