/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Responsive;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.progress.PackageManagerExecutionEngine;
import org.openthinclient.progress.Registration;
import org.openthinclient.web.SchemaService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.presenter.AvailablePackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageActionOverviewPresenter;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageDetailsListPresenter;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.presenter.UpdateablePackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.PackageActionOverviewView;
import org.openthinclient.web.pkgmngr.ui.view.PackageListMasterDetailsView;
import org.openthinclient.web.pkgmngr.ui.view.PackageManagerMainView;
import org.openthinclient.web.ui.ViewHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="package-management")
@SideBarItem(sectionId="package-management", captionCode="UI_PACKAGEMANAGERMAINNAVIGATORVIEW_CAPTION")
public class PackageManagerMainNavigatorView
extends Panel
implements View {
    private static final long serialVersionUID = -1596921762830560217L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageManagerMainNavigatorView.class);
    private final VerticalLayout root;
    private final PackageListMasterDetailsPresenter availablePackagesPresenter;
    private final PackageListMasterDetailsPresenter installedPackagesPresenter;
    private final PackageListMasterDetailsPresenter updateablePackagesPresenter;
    private final PackageManager packageManager;
    private final SchemaService schemaService;
    private final PackageManagerMainView mainView;
    private final ClientService clientService;
    private final Registration handler;
    private final ApplicationService applicationService;

    @Autowired
    public PackageManagerMainNavigatorView(PackageManager packageManager, PackageManagerExecutionEngine packageManagerExecutionEngine, SchemaService schemaService, ApplicationService applicationService, ClientService clientService) {
        this.packageManager = packageManager;
        this.schemaService = schemaService;
        this.applicationService = applicationService;
        this.clientService = clientService;
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.addStyleName("borderless");
        this.setSizeFull();
        this.root = new VerticalLayout();
        this.root.setSizeFull();
        this.root.setMargin(true);
        this.root.addStyleName("dashboard-view");
        this.setContent((Component)this.root);
        Responsive.makeResponsive((Component[])new Component[]{this.root});
        this.root.addComponent((Component)new ViewHeader(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGERMAINNAVIGATORVIEW_CAPTION, new Object[0])));
        this.mainView = new PackageManagerMainView();
        this.mainView.setTabCaption((Component)this.mainView.getAvailablePackagesView(), mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_TAB_AVAILABLEPACKAGES, new Object[0]));
        this.mainView.setTabCaption((Component)this.mainView.getUpdateablePackagesView(), mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_TAB_UPDATEABLEPACKAGES, new Object[0]));
        this.mainView.setTabCaption((Component)this.mainView.getInstalledPackagesView(), mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_TAB_INSTALLEDPACKAGES, new Object[0]));
        this.mainView.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener & Serializable)event -> {
            this.updateablePackagesPresenter.refreshUpdatePanel();
            this.availablePackagesPresenter.refreshUpdatePanel();
        });
        this.availablePackagesPresenter = this.createPresenter(PackageDetailsListPresenter.Mode.INSTALL, this.mainView.getAvailablePackagesView());
        this.updateablePackagesPresenter = this.createPresenter(PackageDetailsListPresenter.Mode.UPDATE, this.mainView.getUpdateablePackagesView());
        this.installedPackagesPresenter = this.createPresenter(PackageDetailsListPresenter.Mode.UNINSTALL, this.mainView.getInstalledPackagesView());
        this.mainView.getInstalledPackagesView().hideSourceUpdatePanel();
        this.root.addComponent((Component)this.mainView);
        this.root.setExpandRatio((Component)this.mainView, 1.0f);
        this.handler = packageManagerExecutionEngine.addTaskFinalizedHandler(e -> this.bindPackageLists());
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.bindPackageLists();
    }

    private void bindPackageLists() {
        this.bindPackageList(this.availablePackagesPresenter, () -> ((PackageManager)this.packageManager).getInstallablePackagesWithoutInstalledOfSameVersion());
        this.bindPackageList(this.installedPackagesPresenter, () -> ((PackageManager)this.packageManager).getInstalledPackages());
        this.bindPackageList(this.updateablePackagesPresenter, () -> ((PackageManager)this.packageManager).getUpdateablePackages());
    }

    private PackageListMasterDetailsPresenter createPresenter(PackageDetailsListPresenter.Mode mode, PackageListMasterDetailsView masterDetailsView) {
        PackageActionOverviewView packageActionOverviewView = new PackageActionOverviewView();
        masterDetailsView.getDetailsContainer().addComponent((Component)packageActionOverviewView);
        PackageDetailsListPresenter packageDetailsListPresenter = new PackageDetailsListPresenter(mode, new PackageActionOverviewPresenter(packageActionOverviewView), this.packageManager, this.schemaService, this.applicationService, this.clientService);
        Consumer<Collection<Package>> presenter = packageDetailsListPresenter::setPackages;
        if (mode == PackageDetailsListPresenter.Mode.INSTALL) {
            return new AvailablePackageListMasterDetailsPresenter(masterDetailsView, presenter, this.packageManager, this.clientService);
        }
        if (mode == PackageDetailsListPresenter.Mode.UPDATE) {
            return new UpdateablePackageListMasterDetailsPresenter(masterDetailsView, presenter, this.packageManager, this.clientService);
        }
        return new PackageListMasterDetailsPresenter(masterDetailsView, presenter, this.packageManager, this.clientService);
    }

    private void bindPackageList(PackageListMasterDetailsPresenter presenter, Callable<Collection<Package>> packagesProvider) {
        try {
            presenter.setPackages(packagesProvider.call());
        }
        catch (Exception e) {
            presenter.showPackageListLoadingError(e);
            LOGGER.error("Failed to load package list", (Throwable)e);
        }
    }

    @PreDestroy
    public void cleanup() {
        LOGGER.debug("Cleaup {} and unregister {}", (Object)this, (Object)this.handler);
        this.handler.unregister();
    }
}

