/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.services.ui;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.Setter;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import org.openthinclient.common.model.util.Config;
import org.openthinclient.service.common.ManagedService;
import org.openthinclient.service.common.ServiceManager;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.dhcp.DHCPService;
import org.openthinclient.service.dhcp.DhcpServiceConfiguration;
import org.openthinclient.web.SchemaService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.services.ui.EnumMessageConveyorCaptionGenerator;
import org.openthinclient.web.ui.ViewHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="service-dhcp")
@SideBarItem(sectionId="service-management", captionCode="UI_SERVICE_DHCP_CAPTION")
public class DhcpServiceConfigurationView
extends Panel
implements View {
    private static final Logger LOGGER = LoggerFactory.getLogger(DhcpServiceConfigurationView.class);
    private final ManagedService<DHCPService, DhcpServiceConfiguration> service;
    private final MessageConveyor conveyor = new MessageConveyor(UI.getCurrent().getLocale());
    private final Button startButton;
    private final Button stopButton;
    private final NativeSelect<DhcpServiceConfiguration.PXEType> typeSelect;
    private final CheckBox trackClientsCheckbox;
    private final NativeSelect<DhcpServiceConfiguration.PXEPolicy> policySelect;
    private final Button saveButton;
    private final Binder<DhcpServiceConfiguration> binder;

    @Autowired
    public DhcpServiceConfigurationView(ServiceManager serviceManager, ManagerHome managerHome, SchemaService schemaService) {
        this.service = serviceManager.getManagedService(DHCPService.class);
        this.addStyleName("borderless");
        this.setSizeFull();
        VerticalLayout root = new VerticalLayout();
        root.setSizeFull();
        root.setMargin(true);
        root.addStyleName("dashboard-view");
        this.setContent((Component)root);
        Responsive.makeResponsive((Component[])new Component[]{root});
        root.addComponent((Component)new ViewHeader(this.conveyor.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CAPTION, new Object[0])));
        ViewHeader header = new ViewHeader("", false);
        this.startButton = new Button(this.conveyor.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_START, new Object[0]));
        header.addTool((Component)this.startButton);
        this.stopButton = new Button(this.conveyor.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_STOP, new Object[0]));
        header.addTool((Component)this.stopButton);
        this.startButton.setIcon((Resource)FontAwesome.PLAY);
        this.startButton.setStyleName("friendly");
        this.stopButton.setIcon((Resource)FontAwesome.STOP);
        this.stopButton.setStyleName("danger");
        root.addComponent((Component)header);
        this.startButton.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.service != null && !this.service.isRunning()) {
                this.service.start();
                this.refreshButtons();
            }
        });
        this.stopButton.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.service != null && this.service.isRunning()) {
                this.service.stop();
                this.refreshButtons();
            }
        });
        FormLayout formLayout = new FormLayout();
        this.binder = new Binder();
        DhcpServiceConfiguration configuration = (DhcpServiceConfiguration)this.service.getService().getConfiguration();
        this.binder.setBean((Object)configuration);
        this.typeSelect = new NativeSelect(this.conveyor.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE, new Object[0]));
        this.typeSelect.setItems((Object[])DhcpServiceConfiguration.PXEType.values());
        EnumMessageConveyorCaptionGenerator<DhcpServiceConfiguration.PXEType, ConsoleWebMessages> captionGenerator = new EnumMessageConveyorCaptionGenerator<DhcpServiceConfiguration.PXEType, ConsoleWebMessages>(this.conveyor);
        captionGenerator.addMapping(DhcpServiceConfiguration.PXEType.AUTO, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_AUTO);
        captionGenerator.addMapping(DhcpServiceConfiguration.PXEType.BIND_TO_ADDRESS, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_BIND_TO_ADDRESS);
        captionGenerator.addMapping(DhcpServiceConfiguration.PXEType.EAVESDROPPING, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_EAVESDROPPING);
        captionGenerator.addMapping(DhcpServiceConfiguration.PXEType.SINGLE_HOMED, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_SINGLE_HOMED);
        captionGenerator.addMapping(DhcpServiceConfiguration.PXEType.SINGLE_HOMED_BROADCAST, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_SINGLE_HOMED_BROADCAST);
        this.typeSelect.setItemCaptionGenerator(captionGenerator);
        this.typeSelect.setEmptySelectionAllowed(false);
        this.binder.forField(this.typeSelect).bind((ValueProvider & Serializable)conf -> conf.getPxe().getType(), (Setter & Serializable)(conf, type) -> conf.getPxe().setType(type));
        this.trackClientsCheckbox = new CheckBox(this.conveyor.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_TRACK_CLIENTS, new Object[0]));
        this.binder.forField((HasValue)this.trackClientsCheckbox).bind(DhcpServiceConfiguration::isTrackUnrecognizedPXEClients, DhcpServiceConfiguration::setTrackUnrecognizedPXEClients);
        this.policySelect = new NativeSelect(this.conveyor.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXEPOLICY, new Object[0]));
        this.policySelect.setItems((Object[])DhcpServiceConfiguration.PXEPolicy.values());
        EnumMessageConveyorCaptionGenerator<DhcpServiceConfiguration.PXEPolicy, ConsoleWebMessages> policyCaptionGenerator = new EnumMessageConveyorCaptionGenerator<DhcpServiceConfiguration.PXEPolicy, ConsoleWebMessages>(this.conveyor);
        policyCaptionGenerator.addMapping(DhcpServiceConfiguration.PXEPolicy.ANY_CLIENT, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXEPOLICY_ANY_CLIENT);
        policyCaptionGenerator.addMapping(DhcpServiceConfiguration.PXEPolicy.ONLY_CONFIGURED, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXEPOLICY_ONLY_CONFIGURED);
        this.policySelect.setItemCaptionGenerator(policyCaptionGenerator);
        this.policySelect.setEmptySelectionAllowed(false);
        this.binder.forField(this.policySelect).bind((ValueProvider & Serializable)conf -> conf.getPxe().getPolicy(), (Setter & Serializable)(conf, policy) -> conf.getPxe().setPolicy(policy));
        Label configCaptionLabel = new Label(this.conveyor.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_CAPTION, new Object[0]));
        configCaptionLabel.addStyleName("h2");
        configCaptionLabel.addStyleName("colored");
        formLayout.addComponent((Component)configCaptionLabel);
        formLayout.addComponent(this.typeSelect);
        formLayout.addComponent((Component)this.trackClientsCheckbox);
        formLayout.addComponent(this.policySelect);
        this.saveButton = new Button(this.conveyor.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_SAVE, new Object[0]));
        formLayout.addComponent((Component)new HorizontalLayout(new Component[]{this.saveButton}));
        this.saveButton.addClickListener((Button.ClickListener & Serializable)e -> {
            this.binder.writeBeanIfValid((Object)((DhcpServiceConfiguration)this.service.getService().getConfiguration()));
            managerHome.save(this.service.getService().getConfigurationClass());
            DhcpServiceConfiguration.PXEPolicy pxePolicy = (DhcpServiceConfiguration.PXEPolicy)this.policySelect.getValue();
            schemaService.saveTftpPolicy(pxePolicy == DhcpServiceConfiguration.PXEPolicy.ANY_CLIENT ? Config.BootOptions.PXEServicePolicyType.AnyClient : Config.BootOptions.PXEServicePolicyType.RegisteredOnly);
            this.service.restart();
        });
        root.addComponent((Component)formLayout);
        root.setExpandRatio((Component)formLayout, 1.0f);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.refreshButtons();
        this.binder.setBean((Object)((DhcpServiceConfiguration)this.service.getService().getConfiguration()));
    }

    private void refreshButtons() {
        this.startButton.setEnabled(!this.service.isRunning());
        this.stopButton.setEnabled(this.service.isRunning());
    }
}

