/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.services.ui;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import org.openthinclient.service.common.ManagedService;
import org.openthinclient.service.common.Service;
import org.openthinclient.service.common.ServiceManager;

public class ServiceOverviewPanel
extends Panel {
    private final Class<Service> serviceClass;
    private final ServiceManager serviceManager;
    private final Label stateLabel;
    private final Button startButton;
    private final Button stopButton;

    public ServiceOverviewPanel(ServiceManager serviceManager, Class serviceClass) {
        this.serviceClass = serviceClass;
        this.serviceManager = serviceManager;
        String serviceName = serviceClass.getSimpleName();
        if (serviceName.endsWith("Service")) {
            serviceName = serviceName.substring(0, serviceName.length() - 7);
        }
        this.setCaption(serviceName);
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(true);
        this.stateLabel = new Label();
        layout.addComponent((Component)this.stateLabel);
        Component[] componentArray = new Component[2];
        this.startButton = new Button("Start");
        componentArray[0] = this.startButton;
        this.stopButton = new Button("Stop");
        componentArray[1] = this.stopButton;
        HorizontalLayout buttonBar = new HorizontalLayout(componentArray);
        buttonBar.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        buttonBar.setSpacing(true);
        buttonBar.setExpandRatio((Component)this.startButton, 1.0f);
        buttonBar.setExpandRatio((Component)this.stopButton, 1.0f);
        this.startButton.setStyleName("friendly");
        this.startButton.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.startButton.setIcon((Resource)FontAwesome.PLAY);
        this.stopButton.setStyleName("danger");
        this.stopButton.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.stopButton.setIcon((Resource)FontAwesome.STOP);
        layout.addComponent((Component)buttonBar);
        this.setContent((Component)layout);
        this.startButton.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.getService() != null && !this.getService().isRunning()) {
                this.getService().start();
                this.refresh();
            }
        });
        this.stopButton.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.getService() != null && this.getService().isRunning()) {
                this.getService().stop();
                this.refresh();
            }
        });
    }

    public void attach() {
        super.attach();
        this.refresh();
    }

    public void refresh() {
        ManagedService service = this.getService();
        if (service != null) {
            if (service.isRunning()) {
                this.stateLabel.setValue("Running");
                this.stateLabel.setStyleName("success");
                this.startButton.setEnabled(false);
                this.stopButton.setEnabled(true);
            } else {
                if (service.isFaulty()) {
                    this.stateLabel.setValue("Error");
                    this.stateLabel.setStyleName("failure");
                } else {
                    this.stateLabel.setValue("Stopped");
                    this.stateLabel.setStyleName("failure");
                }
                this.startButton.setEnabled(true);
                this.stopButton.setEnabled(false);
            }
        }
    }

    private ManagedService getService() {
        return this.serviceManager.getManagedService(this.serviceClass);
    }
}

