/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.services.ui;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Responsive;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.openthinclient.service.apacheds.DirectoryService;
import org.openthinclient.service.common.ServiceManager;
import org.openthinclient.service.dhcp.DHCPService;
import org.openthinclient.service.nfs.NFSService;
import org.openthinclient.syslogd.SyslogService;
import org.openthinclient.tftp.TFTPService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.services.ui.ServiceOverviewPanel;
import org.openthinclient.web.ui.ViewHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="services-overview")
@SideBarItem(sectionId="service-management", captionCode="UI_SERVICESOVERVIEW_CAPTION", order=1)
public class ServicesOverviewView
extends Panel
implements View {
    private static final long serialVersionUID = 7856636768058411222L;
    private final ServiceOverviewPanel directoryServiceOverviewPanel;
    private final ServiceOverviewPanel tftpServiceOverviewPanel;
    private final ServiceOverviewPanel syslogServiceOverviewPanel;
    private final ServiceOverviewPanel nfsServiceOverviewPanel;
    private final ServiceOverviewPanel dhcpServiceOverviewPanel;
    EventBus.SessionEventBus eventBus;

    @Autowired
    public ServicesOverviewView(ServiceManager serviceManager, EventBus.SessionEventBus eventBus) {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.addStyleName("borderless");
        this.setSizeFull();
        this.eventBus = eventBus;
        VerticalLayout root = new VerticalLayout();
        root.setSizeFull();
        root.addStyleName("dashboard-view");
        this.setContent((Component)root);
        Responsive.makeResponsive((Component[])new Component[]{root});
        root.addComponent((Component)new ViewHeader(mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICESOVERVIEW_CAPTION, new Object[0])));
        HorizontalLayout content = new HorizontalLayout();
        content.setStyleName("services-wrap");
        root.addComponent((Component)content);
        root.setExpandRatio((Component)content, 1.0f);
        this.directoryServiceOverviewPanel = new ServiceOverviewPanel(serviceManager, DirectoryService.class);
        this.tftpServiceOverviewPanel = new ServiceOverviewPanel(serviceManager, TFTPService.class);
        this.syslogServiceOverviewPanel = new ServiceOverviewPanel(serviceManager, SyslogService.class);
        this.nfsServiceOverviewPanel = new ServiceOverviewPanel(serviceManager, NFSService.class);
        this.dhcpServiceOverviewPanel = new ServiceOverviewPanel(serviceManager, DHCPService.class);
        content.setSpacing(true);
        content.setMargin(false);
        content.addComponent((Component)this.directoryServiceOverviewPanel);
        content.addComponent((Component)this.tftpServiceOverviewPanel);
        content.addComponent((Component)this.syslogServiceOverviewPanel);
        content.addComponent((Component)this.nfsServiceOverviewPanel);
        content.addComponent((Component)this.dhcpServiceOverviewPanel);
        Responsive.makeResponsive((Component[])new Component[]{content});
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.directoryServiceOverviewPanel.refresh();
        this.tftpServiceOverviewPanel.refresh();
        this.syslogServiceOverviewPanel.refresh();
        this.nfsServiceOverviewPanel.refresh();
        this.dhcpServiceOverviewPanel.refresh();
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }
}

